/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.planner;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.planner.ExecutionPlan;
import com.edb.gridsql.planner.ExecutionStep;
import com.edb.gridsql.planner.NodeUsage;
import com.edb.gridsql.planner.StepDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecutionPlanPreparedHandler {
    private List<PlanPrepStatement> planPrepStatementList;
    private List<Parameter> parameterList;
    private XDBSessionContext client;
    private int[] paramTypes;

    public ExecutionPlanPreparedHandler(XDBSessionContext xDBSessionContext, int[] nArray) {
        this.client = xDBSessionContext;
        this.paramTypes = nArray;
    }

    public void preparePlanParameters(ExecutionPlan executionPlan) {
        if (executionPlan.unionPlanList.size() > 0) {
            this.prepareUnionPlanParameters(executionPlan.unionPlanList);
        }
        for (ExecutionPlan executionPlan2 : executionPlan.scalarPlanList) {
            this.preparePlanParameters(executionPlan2);
        }
        for (ExecutionPlan object : executionPlan.relationPlanList) {
            this.preparePlanParameters(object);
        }
        for (ExecutionStep executionStep : executionPlan.stepList) {
            if (executionStep.correlatedSubPlan != null) {
                this.preparePlanParameters(executionStep.correlatedSubPlan);
            }
            if (executionStep.uncorrelatedSubPlanList != null) {
                for (ExecutionPlan executionPlan2 : executionStep.uncorrelatedSubPlanList) {
                    this.preparePlanParameters(executionPlan2);
                }
            }
            this.prepareStepParameters(executionStep);
        }
    }

    private void prepareUnionPlanParameters(List list) {
        for (int i = 0; i < list.size(); ++i) {
            ExecutionPlan executionPlan = (ExecutionPlan)list.get(i);
            this.preparePlanParameters(executionPlan);
        }
    }

    private PlanPrepStatement addPlanPrepStatement(ExecutionStep executionStep) {
        if (this.planPrepStatementList == null) {
            this.planPrepStatementList = new ArrayList<PlanPrepStatement>();
        }
        PlanPrepStatement planPrepStatement = new PlanPrepStatement(executionStep);
        planPrepStatement.setPartitionParameterInfo(executionStep.getPartitionParameterExpression());
        this.planPrepStatementList.add(planPrepStatement);
        return planPrepStatement;
    }

    private void addParameter(int n, int n2, PlanPrepStatement planPrepStatement) {
        if (this.parameterList == null) {
            this.parameterList = new ArrayList<Parameter>();
        }
        this.parameterList.add(new Parameter(n, n2, planPrepStatement));
    }

    private void prepareStepParameters(ExecutionStep executionStep) {
        StepDetail stepDetail = executionStep.aStepDetail;
        if (stepDetail.queryString != null) {
            int n = 0;
            n = executionStep.aStepDetail.queryString.indexOf("&xp");
            if (n >= 0) {
                PlanPrepStatement planPrepStatement = this.addPlanPrepStatement(executionStep);
                while (n >= 0) {
                    int n2 = n += 3;
                    String string = new String();
                    while (stepDetail.queryString.length() > n && stepDetail.queryString.charAt(n) >= '0' && stepDetail.queryString.charAt(n) <= '0') {
                        ++n;
                    }
                    int n3 = Integer.valueOf(stepDetail.queryString.substring(n2, n + 1));
                    this.addParameter(n3, this.paramTypes[n3 - 1], planPrepStatement);
                    n = stepDetail.queryString.indexOf("&xp", n);
                }
            }
        }
    }

    public void substituteParameterValues(String[] stringArray) {
        this.resetStatements();
        for (Parameter parameter : this.parameterList) {
            if (parameter.paramNum > stringArray.length) continue;
            parameter.substitute(stringArray[parameter.paramNum - 1]);
        }
    }

    private void resetStatements() {
        for (PlanPrepStatement planPrepStatement : this.planPrepStatementList) {
            planPrepStatement.reset();
        }
    }

    private class Parameter {
        private int paramNum;
        private boolean addQuote;
        private PlanPrepStatement aPlanPrepStatement;

        Parameter(int n, int n2, PlanPrepStatement planPrepStatement) {
            this.paramNum = n;
            this.aPlanPrepStatement = planPrepStatement;
            try {
                this.addQuote = !ExpressionType.isNumeric(n2);
            }
            catch (Exception exception) {
                this.addQuote = true;
            }
        }

        public void substitute(String string) {
            this.aPlanPrepStatement.substitute(this.paramNum, string, this.addQuote);
            ExecutionPlanPreparedHandler.this.parameterList = null;
        }
    }

    class PlanPrepStatement {
        private ExecutionStep anExecutionStep;
        private String originalQueryString;
        private SqlExpression parameterExpression;

        PlanPrepStatement(ExecutionStep executionStep) {
            this.anExecutionStep = executionStep;
            this.originalQueryString = executionStep.aStepDetail.queryString;
            this.parameterExpression = null;
        }

        public void substitute(int n, String string, boolean bl) {
            this.anExecutionStep.aStepDetail.queryString = string == null ? this.anExecutionStep.aStepDetail.queryString.replace("&xp" + n, "null") : this.anExecutionStep.aStepDetail.queryString.replace("&xp" + n, bl ? "'" + string + "'" : string);
            if (this.parameterExpression != null) {
                this.updateDestinationFromParameter(this.anExecutionStep, string, this.parameterExpression);
            }
        }

        protected void updateDestinationFromParameter(ExecutionStep executionStep, String string, SqlExpression sqlExpression) {
            SysTable sysTable = ExecutionPlanPreparedHandler.this.client.getSysDatabase().getSysTable(sqlExpression.getColumn().getTableName());
            Collection<DBNode> collection = sysTable.getNode(SqlExpression.createConstantExpression(string, sqlExpression.getExprDataType()).getNormalizedValue());
            int n = ((DBNode)collection.toArray()[0]).getNodeId();
            for (NodeUsage nodeUsage : executionStep.nodeUsageTable.values()) {
                NodeUsage nodeUsage2 = executionStep.nodeUsageTable.get(new Integer(nodeUsage.nodeId));
                if (nodeUsage2 == null) continue;
                if (nodeUsage2.nodeId == n) {
                    nodeUsage2.isProducer = true;
                    continue;
                }
                nodeUsage2.isProducer = false;
            }
        }

        public void reset() {
            this.anExecutionStep.aStepDetail.queryString = this.originalQueryString;
        }

        public void setPartitionParameterInfo(SqlExpression sqlExpression) {
            this.parameterExpression = sqlExpression;
        }
    }
}

