/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser.handler;

import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.core.syntaxtree.WhereClause;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereClauseHandler
extends ObjectDepthFirst {
    short outerCounter = 0;
    QueryTree aQueryTree;
    Command commandToExecute;
    SysTable targetTable;

    public WhereClauseHandler(Command command) {
        this.commandToExecute = command;
    }

    public SysTable getTargetTable(String string) throws XDBServerException {
        if (this.targetTable == null) {
            this.targetTable = this.commandToExecute.getClientContext().getSysDatabase().getSysTable(string);
        }
        return this.targetTable;
    }

    @Override
    public Object visit(WhereClause whereClause, Object object) {
        whereClause.f0.accept(this, object);
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
        whereClause.f1.accept(queryConditionHandler, object);
        this.aQueryTree = (QueryTree)object;
        List<QueryCondition> list = this.getAllConditions(queryConditionHandler.aRootCondition, queryConditionHandler.aRootCondition.getOperator());
        this.optimizeQueryTreeForPrepStmt(this.aQueryTree, list);
        if (queryConditionHandler.isHandleLeftOuterNeeded()) {
            this.handleLeftOuter(queryConditionHandler);
        } else {
            queryConditionHandler.queryCondList.clear();
            queryConditionHandler.innerQueryCondList.clear();
        }
        this.aQueryTree.setWhereRootCondition(this.optimizeConditions(queryConditionHandler.aRootCondition));
        return null;
    }

    private void optimizeQueryTreeForPrepStmt(QueryTree queryTree, List<QueryCondition> list) {
        for (RelationNode relationNode : queryTree.getRelationNodeList()) {
            String string = relationNode.getTableName();
            for (QueryCondition queryCondition : list) {
                SqlExpression sqlExpression = null;
                if (queryCondition.getRightCond() != null) {
                    sqlExpression = queryCondition.getRightCond().getExpr();
                }
                if (sqlExpression == null || sqlExpression.getExprType() != 1024) continue;
                for (SqlExpression sqlExpression2 : queryTree.getProjectionList()) {
                    if (sqlExpression2.getColumn() == null) continue;
                    sqlExpression2.getColumn().isPrepSqlColumn = true;
                }
                if (string == null || sqlExpression.getExprDataType() == null) continue;
                for (SysColumn sysColumn : this.getTargetTable(string).getRowID()) {
                    AttributeColumn attributeColumn = null;
                    if (queryCondition.getLeftCond() != null && queryCondition.getLeftCond().getExpr() != null) {
                        attributeColumn = queryCondition.getLeftCond().getExpr().getColumn();
                    }
                    if (attributeColumn == null || !attributeColumn.getColumnName().equalsIgnoreCase(sysColumn.getColName())) continue;
                    attributeColumn.isPrepSqlColumn = true;
                    sqlExpression.setExprDataType(sqlExpression.setExpressionResultType(sqlExpression, sysColumn));
                }
            }
        }
    }

    private Vector<String> getTableNames(Vector<QueryCondition> vector) {
        Vector<String> vector2 = new Vector<String>();
        for (QueryCondition queryCondition : vector) {
            for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                for (SqlExpression sqlExpression : queryCondition2.getExpr().getNodes(queryCondition2.getExpr(), 4)) {
                    AttributeColumn attributeColumn = sqlExpression.getColumn();
                    RelationNode relationNode = attributeColumn.relationNode;
                    if (relationNode != null) {
                        vector2.add(relationNode.getTableName());
                        continue;
                    }
                    if (attributeColumn.getTableName() != null && attributeColumn.getTableName().length() > 0) {
                        vector2.add(attributeColumn.getTableName());
                        continue;
                    }
                    if (attributeColumn.getTableAlias() == null || attributeColumn.getTableAlias().length() <= 0) continue;
                    vector2.add(this.aQueryTree.getTableNameOfAlias(attributeColumn.getTableAlias()));
                }
            }
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleLeftOuter(Object object) {
        this.aQueryTree.setOuterJoin(true);
        QueryConditionHandler queryConditionHandler = (QueryConditionHandler)object;
        try {
            Object object2;
            Vector<SqlExpression> vector;
            Vector<QueryCondition> vector2;
            QueryCondition queryCondition;
            int n;
            Vector<String> vector3 = this.getTableNames(queryConditionHandler.queryCondList);
            for (n = 0; n < queryConditionHandler.queryCondList.size(); ++n) {
                queryCondition = queryConditionHandler.queryCondList.get(n);
                this.aQueryTree.getFromClauseConditions().add(queryCondition);
                vector2 = QueryCondition.getNodes(queryCondition, 4);
                vector = new Vector<SqlExpression>();
                for (QueryCondition queryCondition2 : vector2) {
                    vector.add(queryCondition2.getExpr());
                }
                QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(vector.iterator(), this.aQueryTree.getRelationNodeList(), null, 2, this.commandToExecute.getaQueryTreeTracker(), this.commandToExecute.getClientContext().getSysDatabase());
                object2 = new HashSet();
                RelationNode object32 = this.aQueryTree.getRelHandlerInfo().get(vector3.get(n));
                block5: for (RelationNode relationNode : this.aQueryTree.getRelationNodeList()) {
                    if (relationNode == object32) continue;
                    for (QueryCondition queryCondition3 : vector2) {
                        if (!queryCondition3.getExpr().contains(relationNode)) continue;
                        ((HashSet)object2).add(relationNode);
                        continue block5;
                    }
                }
                this.outerCounter = (short)(this.outerCounter + 1);
                object32.addParentNodes((Collection<RelationNode>)object2, true, this.outerCounter);
            }
            if (queryConditionHandler.isHandleInnerJoinNeeded()) {
                vector3 = this.getTableNames(queryConditionHandler.innerQueryCondList);
                for (n = 0; n < queryConditionHandler.innerQueryCondList.size(); ++n) {
                    queryCondition = queryConditionHandler.innerQueryCondList.get(n);
                    this.aQueryTree.getFromClauseConditions().add(queryCondition);
                    vector2 = QueryCondition.getNodes(queryCondition, 4);
                    vector = new Vector();
                    for (QueryCondition queryCondition4 : vector2) {
                        vector.add(queryCondition4.getExpr());
                    }
                    QueryTreeHandler.analyzeAndCompleteColInfoAndNodeInfo(vector.iterator(), this.aQueryTree.getRelationNodeList(), null, 2, this.commandToExecute.getaQueryTreeTracker(), this.commandToExecute.getClientContext().getSysDatabase());
                    object2 = this.aQueryTree.getRelHandlerInfo().get(vector3.get(n));
                    for (Object object3 : this.aQueryTree.getRelationNodeList()) {
                        if (object3 == object2) continue;
                        for (QueryCondition queryCondition5 : vector2) {
                            if (!queryCondition5.getExpr().contains((RelationNode)object3)) continue;
                            ((RelationNode)object2).addSiblingJoin((RelationNode)object3);
                        }
                    }
                }
            }
        }
        finally {
            queryConditionHandler.innerQueryCondList.clear();
            queryConditionHandler.queryCondList.clear();
        }
    }

    private QueryCondition optimizeConditions(QueryCondition queryCondition) {
        queryCondition.rebuildCondString();
        List<QueryCondition> list = this.getAllConditions(queryCondition, "OR");
        if (list.size() == 1 && list.get(0) == queryCondition) {
            return queryCondition;
        }
        List<QueryCondition> list2 = this.findCommonConditions(list, "AND");
        QueryCondition queryCondition2 = this.buildNewCondition(list, list2);
        queryCondition2.rebuildCondString();
        return queryCondition2;
    }

    private SqlExpression getNotConstantExpr(QueryCondition queryCondition) {
        if (queryCondition.getLeftCond().getExpr().getExprType() == 2) {
            return queryCondition.getRightCond().getExpr();
        }
        return queryCondition.getLeftCond().getExpr();
    }

    private boolean hasSameNode(QueryCondition queryCondition, QueryCondition queryCondition2) {
        if (queryCondition == null || queryCondition2 == null) {
            return false;
        }
        if (queryCondition.getLeftCond().getCondType() != 4 || queryCondition.getRightCond().getCondType() != 4 || queryCondition2.getLeftCond().getCondType() != 4 || queryCondition2.getRightCond().getCondType() != 4) {
            return false;
        }
        if (!(queryCondition.getLeftCond().getExpr().getExprType() != 2 && queryCondition.getRightCond().getExpr().getExprType() != 2 || queryCondition2.getLeftCond().getExpr().getExprType() != 2 && queryCondition2.getRightCond().getExpr().getExprType() != 2)) {
            SqlExpression sqlExpression = this.getNotConstantExpr(queryCondition);
            SqlExpression sqlExpression2 = this.getNotConstantExpr(queryCondition2);
            if (sqlExpression.getColumn().getTableAlias().endsWith(sqlExpression2.getColumn().getTableAlias())) {
                return true;
            }
        }
        return false;
    }

    private List<QueryCondition> remakeConditionsForCommonNode(QueryCondition queryCondition, QueryCondition queryCondition2) {
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        ArrayList<QueryCondition> arrayList2 = new ArrayList<QueryCondition>();
        List<QueryCondition> list = this.getAllConditions(queryCondition, "AND");
        List<QueryCondition> list2 = this.getAllConditions(queryCondition2, "AND");
        if (list.size() != list.size() || list.size() == 0 || list2.size() == 0) {
            return null;
        }
        ArrayList<QueryCondition> arrayList3 = new ArrayList<QueryCondition>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList2.clear();
            QueryCondition queryCondition3 = list.get(i);
            for (int j = 0; j < list2.size(); ++j) {
                QueryCondition queryCondition4 = list2.get(j);
                if (!this.hasSameNode(queryCondition3, queryCondition4)) continue;
                arrayList2.clear();
                arrayList2.add(queryCondition3);
                arrayList2.add(queryCondition4);
                list2.set(j, null);
                break;
            }
            if (arrayList2.size() != 0) {
                arrayList3.add(this.createOperatorConditions(arrayList2, "OR"));
                continue;
            }
            arrayList3.add(queryCondition3);
        }
        Iterator<Object> iterator = arrayList3.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        arrayList.add(this.createOperatorConditions(arrayList3, "AND"));
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        if (list2.size() != 0) {
            return null;
        }
        arrayList.add(this.createOperatorConditions(list2, "AND"));
        return arrayList;
    }

    private QueryCondition remakeConditionsForCommonNode(List<QueryCondition> list) {
        List<Object> list2 = new ArrayList();
        if (list == null || list.size() != 2) {
            return null;
        }
        list2 = this.remakeConditionsForCommonNode(list.get(0), list.get(1));
        if (list2 == null) {
            return null;
        }
        Iterator<Object> iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != null) continue;
            iterator.remove();
        }
        if (list2.size() != 1) {
            return null;
        }
        return (QueryCondition)list2.get(0);
    }

    private QueryCondition buildNewCondition(List<QueryCondition> list, List<QueryCondition> list2) {
        QueryCondition queryCondition = new QueryCondition();
        QueryCondition queryCondition2 = this.createOperatorConditions(list2, "AND");
        List<QueryCondition> list3 = this.removeCommonConditions(list, list2);
        QueryCondition queryCondition3 = this.createOperatorConditions(list3, "OR");
        QueryCondition queryCondition4 = this.remakeConditionsForCommonNode(list3);
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        arrayList.add(queryCondition2);
        arrayList.add(queryCondition3);
        arrayList.add(queryCondition4);
        queryCondition = this.createOperatorConditions(arrayList, "AND");
        return queryCondition;
    }

    private List<QueryCondition> removeCommonConditions(List<QueryCondition> list, List<QueryCondition> list2) {
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        for (QueryCondition queryCondition : list) {
            QueryCondition queryCondition2 = this.removeConditions(queryCondition, list2);
            if (queryCondition2 == null) continue;
            queryCondition2.rebuildCondString();
            arrayList.add(queryCondition2);
        }
        return arrayList;
    }

    private QueryCondition removeConditions(QueryCondition queryCondition, List<QueryCondition> list) {
        List<QueryCondition> list2 = this.getAllConditions(queryCondition, "AND");
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        for (QueryCondition queryCondition2 : list2) {
            boolean bl = false;
            for (QueryCondition queryCondition3 : list) {
                if (!this.isConditionsSimilar(queryCondition2, queryCondition3)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(queryCondition2);
        }
        QueryCondition queryCondition4 = this.createOperatorConditions(arrayList, "AND");
        return queryCondition4;
    }

    private QueryCondition createOperatorConditions(List<QueryCondition> list, String string) {
        Object object = list.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            object.remove();
        }
        object = new QueryCondition();
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        arrayList.addAll(list);
        if (arrayList == null || arrayList.size() == 0) {
            return null;
        }
        if (arrayList.size() == 1) {
            if (arrayList.get(0) == null) {
                return null;
            }
            return (QueryCondition)arrayList.get(0);
        }
        if (arrayList.get(1) == null) {
            return null;
        }
        ((QueryCondition)object).setCondType(8);
        ((QueryCondition)object).setOperator(string);
        ((QueryCondition)object).setLeftCond((QueryCondition)arrayList.get(0));
        arrayList.remove(0);
        ((QueryCondition)object).setRightCond(this.createOperatorConditions(arrayList, string));
        ((QueryCondition)object).rebuildCondString();
        return object;
    }

    private List<QueryCondition> findCommonConditions(List<QueryCondition> list, String string) {
        List<QueryCondition> list2 = this.getAllConditions(list.get(0), string);
        for (int i = 1; i < list.size(); ++i) {
            QueryCondition queryCondition = list.get(i);
            list2 = this.findCommonConditions(list2, this.getAllConditions(queryCondition, string));
        }
        return list2;
    }

    private List<QueryCondition> findCommonConditions(List<QueryCondition> list, List<QueryCondition> list2) {
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        for (QueryCondition queryCondition : list) {
            for (QueryCondition queryCondition2 : list2) {
                if (!this.isConditionsSimilar(queryCondition, queryCondition2)) continue;
                arrayList.add(queryCondition);
            }
        }
        return arrayList;
    }

    private boolean isConditionsSimilar(QueryCondition queryCondition, QueryCondition queryCondition2) {
        String string;
        String string2 = queryCondition.rebuildString().trim().toUpperCase();
        return string2.equals(string = queryCondition2.rebuildString().trim().toUpperCase());
    }

    private List<QueryCondition> getAllConditions(QueryCondition queryCondition, String string) {
        ArrayList<QueryCondition> arrayList = new ArrayList<QueryCondition>();
        if (queryCondition.getCondType() == 8 && queryCondition.getOperator().compareTo(string) == 0) {
            arrayList.addAll(this.getAllConditions(queryCondition.getLeftCond(), string));
            arrayList.addAll(this.getAllConditions(queryCondition.getRightCond(), string));
        } else {
            arrayList.add(queryCondition);
        }
        return arrayList;
    }
}

