/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysLogin;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.ShutdownXDB;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlShutdownServer
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlShutdownServer.class);
    private XDBSessionContext client;
    private boolean prepared = false;
    private boolean force = false;

    public SqlShutdownServer(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        if (!this.prepared && this.client.getCurrentUser().getLogin().getUserClass() != 0) {
            throw new XDBSecurityException("You are not allowed to shutdown server");
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        XDBSessionContext xDBSessionContext = XDBSessionContext.createSession();
        SysLogin sysLogin = this.client.getCurrentUser().getLogin();
        try {
            for (SysDatabase sysDatabase : MetaData.getMetaData().getSysDatabases()) {
                if (sysDatabase.getDbname().equalsIgnoreCase(Props.XDB_ADMIN_DATABASE) || !sysDatabase.isStarted()) continue;
                if (this.force) {
                    xDBSessionContext.useDB(sysDatabase.getDbname(), "A");
                    xDBSessionContext.login(sysLogin);
                    xDBSessionContext.shutdownDatabase();
                    continue;
                }
                throw new XDBServerException("Database " + sysDatabase.getDbname() + " is still online. Use force mode option to force a shutdown.");
            }
        }
        finally {
            xDBSessionContext.logout();
        }
        this.client.shutdown();
        Iterator<SysDatabase> iterator = null;
        return iterator;
    }

    @Override
    public Object visit(ShutdownXDB shutdownXDB, Object object) {
        this.force = shutdownXDB.f1.present();
        return null;
    }
}

