/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.MultinodeExecutor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.NodeToken;
import com.edb.gridsql.parser.core.syntaxtree.SetProperty;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlSetProperty
extends ObjectDepthFirst
implements IXDBSql,
IExecutable {
    private String propertyToSet = null;
    private String propertyValue = null;
    private XDBSessionContext client;
    private List<DBNode> nodeList;

    public SqlSetProperty(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.nodeList = new ArrayList<DBNode>(xDBSessionContext.getSysDatabase().getDBNodeList());
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return this.nodeList;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public Object visit(SetProperty setProperty, Object object) {
        IdentifierHandler identifierHandler = new IdentifierHandler();
        this.propertyToSet = (String)setProperty.f1.accept(identifierHandler, object);
        switch (setProperty.f3.which) {
            case 0: {
                this.propertyValue = ((NodeToken)setProperty.f3.choice).tokenImage;
                break;
            }
            case 1: {
                this.propertyValue = (String)setProperty.f3.accept(identifierHandler, object);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.propertyValue = setProperty.f3.choice.toString();
            }
        }
        return null;
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        this.client.setUsedSet();
        try {
            String string = "SET " + this.propertyToSet + " TO '" + this.propertyValue + "';";
            MultinodeExecutor multinodeExecutor = this.client.getMultinodeExecutor(this.getNodeList());
            multinodeExecutor.executeCommand(string, this.getNodeList(), true);
            Connection connection = this.client.getAndSetCoordinatorConnection();
            Statement statement = connection.createStatement();
            statement.execute(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ExecutionResult.createSuccessResult(27);
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

