/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncRevoke;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Identifier;
import com.edb.gridsql.parser.core.syntaxtree.Privilege;
import com.edb.gridsql.parser.core.syntaxtree.PrivilegeList;
import com.edb.gridsql.parser.core.syntaxtree.Revoke;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlRevoke
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlRevoke.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private boolean hasSelect = false;
    private boolean hasInsert = false;
    private boolean hasUpdate = false;
    private boolean hasDelete = false;
    private boolean hasReferences = false;
    private boolean hasIndex = false;
    private boolean hasAlter = false;
    private Collection<String> tableList = new HashSet<String>();
    private Collection<String> granteeList = new HashSet<String>();
    private Collection<SysTable> iTableList = new HashSet<SysTable>();
    private Collection<SysUser> iGranteeList = new HashSet<SysUser>();
    private final IdentifierHandler ih = new IdentifierHandler();
    private boolean prepared = false;

    public SqlRevoke(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
    }

    @Override
    public Object visit(Revoke revoke, Object object) {
        Object var3_3 = null;
        revoke.f1.accept(this, object);
        revoke.f4.accept(this, this.tableList);
        revoke.f6.accept(this, this.granteeList);
        return var3_3;
    }

    @Override
    public Object visit(PrivilegeList privilegeList, Object object) {
        Object var3_3 = null;
        if (privilegeList.f0.which == 0) {
            this.hasSelect = true;
            this.hasInsert = true;
            this.hasUpdate = true;
            this.hasDelete = true;
            this.hasReferences = true;
            this.hasIndex = true;
            this.hasAlter = true;
        } else {
            privilegeList.f0.accept(this, object);
        }
        return var3_3;
    }

    @Override
    public Object visit(Privilege privilege, Object object) {
        Object var3_3 = null;
        switch (privilege.f0.which) {
            case 0: {
                this.hasSelect = true;
                break;
            }
            case 1: {
                this.hasInsert = true;
                break;
            }
            case 2: {
                this.hasUpdate = true;
                break;
            }
            case 3: {
                this.hasDelete = true;
                break;
            }
            case 4: {
                this.hasReferences = true;
                break;
            }
            case 5: {
                this.hasIndex = true;
                break;
            }
            case 6: {
                this.hasAlter = true;
            }
        }
        return var3_3;
    }

    @Override
    public Object visit(Identifier identifier, Object object) {
        ((Collection)object).add(identifier.accept(this.ih, object));
        return null;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, this.iTableList);
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    public boolean hasAlter() {
        return this.hasAlter;
    }

    public boolean hasDelete() {
        return this.hasDelete;
    }

    public boolean hasIndex() {
        return this.hasIndex;
    }

    public boolean hasInsert() {
        return this.hasInsert;
    }

    public boolean hasReferences() {
        return this.hasReferences;
    }

    public boolean hasSelect() {
        return this.hasSelect;
    }

    public boolean hasUpdate() {
        return this.hasUpdate;
    }

    public Collection<SysUser> getGranteeList() {
        return this.iGranteeList;
    }

    public Collection<SysTable> getTableList() {
        return this.iTableList;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() throws Exception {
        if (!this.prepared) {
            SysTable sysTable;
            if (this.client.getCurrentUser().getUserClass() != 0) {
                for (SysTable object2 : this.iTableList) {
                    sysTable = object2;
                    if (sysTable.getOwner() == null || sysTable.getOwner() == this.client.getCurrentUser()) continue;
                    XDBSecurityException xDBSecurityException = new XDBSecurityException("You do not have privilege to change permissions on " + sysTable);
                    logger.throwing(xDBSecurityException);
                    throw xDBSecurityException;
                }
            }
            if (this.tableList.isEmpty()) {
                for (SysTable sysTable2 : this.database.getSysTables()) {
                    if (sysTable2.isTemporary() || sysTable2.getParentTable() != null || this.client.getCurrentUser().getUserClass() != 0 && sysTable2.getOwner() != this.client.getCurrentUser()) continue;
                    this.iTableList.add(sysTable2);
                }
            } else {
                for (String string : this.tableList) {
                    sysTable = this.database.getSysTable(string);
                    if (sysTable.getParentTable() != null) {
                        throw new XDBServerException("Permissions on child table \"" + sysTable.getTableName() + "\" can not be changed");
                    }
                    if (this.client.getCurrentUser().getUserClass() == 0 || sysTable.getOwner() == null || sysTable.getOwner() == this.client.getCurrentUser()) continue;
                    XDBSecurityException xDBSecurityException = new XDBSecurityException("You do not have privilege to change permissions on " + sysTable);
                    logger.throwing(xDBSecurityException);
                    throw xDBSecurityException;
                }
            }
            if (this.granteeList.isEmpty()) {
                this.iGranteeList.add(null);
            } else {
                for (String string : this.granteeList) {
                    this.iGranteeList.add(this.database.getSysUser(string));
                }
            }
        }
        this.prepared = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncRevoke syncRevoke = new SyncRevoke(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncRevoke.execute(this.client);
            metaData.commitTransaction(syncRevoke);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        ExecutionResult executionResult = ExecutionResult.createSuccessResult(25);
        return executionResult;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

