/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutableRequest;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysUser;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.Kill;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlKill
extends ObjectDepthFirst
implements IXDBSql,
IExecutable,
IPreparable {
    private XDBSessionContext client;
    private int requestID;
    private XDBSessionContext targetSession;
    private ExecutableRequest targetRequest;
    private boolean prepared;

    public SqlKill(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        return Collections.emptyList();
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        List list = Collections.emptyList();
        return new LockSpecification<SysTable>(list, list);
    }

    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (this.targetSession != null) {
            if (this.targetRequest == null) {
                this.targetSession.kill();
            } else {
                this.targetSession.kill(this.targetRequest);
            }
        }
        return ExecutionResult.createSuccessResult(39);
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    @Override
    public void prepare() throws Exception {
        this.prepared = true;
        SysUser sysUser = this.client.getCurrentUser();
        XDBSessionContext xDBSessionContext = null;
        if (this.requestID > 0) {
            Map<ExecutableRequest, XDBSessionContext> map = this.client.getRequests();
            for (Map.Entry<ExecutableRequest, XDBSessionContext> entry : map.entrySet()) {
                if (entry.getKey().getRequestID() != this.requestID) continue;
                xDBSessionContext = entry.getValue();
                this.targetRequest = entry.getKey();
                break;
            }
        }
        if (xDBSessionContext != null) {
            if (sysUser.getUserClass() == 0 || xDBSessionContext.getCurrentUser() == sysUser) {
                this.targetSession = xDBSessionContext;
            } else {
                throw new XDBSecurityException("Permission denied");
            }
        }
    }

    @Override
    public Object visit(Kill kill, Object object) {
        try {
            this.requestID = Integer.parseInt(kill.f1.tokenImage);
        }
        catch (NumberFormatException numberFormatException) {
            this.requestID = -1;
        }
        return null;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

