/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.DeleteForeignReferenceChecker;
import com.edb.gridsql.constraintchecker.IConstraintChecker;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.misc.RSHelper;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.Lexer;
import com.edb.gridsql.parser.ParserHelper;
import com.edb.gridsql.parser.SqlModifyTable;
import com.edb.gridsql.parser.core.syntaxtree.Delete;
import com.edb.gridsql.parser.core.syntaxtree.WhereClause;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import com.edb.gridsql.queryproc.QueryProcessor;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlDeleteTable
extends SqlModifyTable {
    private static final XLogger logger = XLogger.getLogger(SqlDeleteTable.class);
    private QueryCondition whereCondition;
    private Collection<SysColumn> columnsInvolved;
    private boolean constrained = false;
    private QueryTree aQueryTree = null;

    public SqlDeleteTable(XDBSessionContext xDBSessionContext) {
        super(xDBSessionContext);
        this.commandToExecute = new Command(5, this, new QueryTreeTracker(), xDBSessionContext);
        this.aQueryTree = new QueryTree();
    }

    @Override
    public Object visit(Delete delete, Object object) {
        Object var3_3 = null;
        QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
        queryTreeTracker.registerTree(this.aQueryTree);
        RelationNode relationNode = this.aQueryTree.newRelationNode();
        relationNode.setNodeType(2);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        delete.f2.accept(tableNameHandler, object);
        this.tableName = tableNameHandler.getTableName();
        relationNode.setTableName(tableNameHandler.getTableName());
        relationNode.setTemporaryTable(tableNameHandler.isTemporary());
        relationNode.setClient(this.commandToExecute.getClientContext());
        relationNode.setAlias(tableNameHandler.getReferenceName());
        delete.f3.accept(this, this.aQueryTree);
        return var3_3;
    }

    @Override
    public Object visit(WhereClause whereClause, Object object) {
        QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
        whereClause.f1.accept(queryConditionHandler, this.aQueryTree);
        this.whereCondition = queryConditionHandler.aRootCondition;
        if (this.whereCondition != null) {
            QueryTreeHandler.ProcessWhereCondition(this.whereCondition, this.aQueryTree, this.commandToExecute.getaQueryTreeTracker(), this.database);
        }
        return object;
    }

    @Override
    public Collection<SysTable> getReadTables() {
        Collection<SysTable> collection = super.getReadTables();
        collection.add(this.getTargetTable());
        return collection;
    }

    @Override
    protected Collection<SysColumn> getColumnsInvolved() {
        if (this.columnsInvolved == null) {
            this.columnsInvolved = new HashSet<SysColumn>(this.getTargetTable().getRowID());
        }
        return this.columnsInvolved;
    }

    protected IConstraintChecker getPKChecker(SysTable sysTable, Collection collection) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConstraintChecker getFKChecker(SysTable sysTable, Collection collection) {
        IConstraintChecker iConstraintChecker = null;
        return iConstraintChecker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IConstraintChecker getFRChecker(SysTable sysTable, Collection collection) {
        DeleteForeignReferenceChecker deleteForeignReferenceChecker = new DeleteForeignReferenceChecker(this.getTargetTable(), this.client);
        Collection<SysColumn> collection2 = deleteForeignReferenceChecker.scanConstraints(this.getColumnsInvolved());
        if (!collection2.isEmpty()) {
            this.constrained = true;
            collection.addAll(collection2);
        }
        DeleteForeignReferenceChecker deleteForeignReferenceChecker2 = deleteForeignReferenceChecker;
        return deleteForeignReferenceChecker2;
    }

    @Override
    protected SysTable createTempTableMetadata(SysTable sysTable, Collection<SysColumn> collection) throws Exception {
        if (!this.constrained && (this.whereCondition == null || this.whereCondition.isSimple())) {
            return null;
        }
        return super.createTempTableMetadata(sysTable, collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareDataSource(SysTable sysTable, SysTable sysTable2) throws Exception {
        Object object = null;
        if (sysTable2 != null) {
            for (SysColumn sysColumn : this.getColumnsInvolved()) {
                SqlExpression sqlExpression = new SqlExpression();
                sqlExpression.setExprString(sysColumn.getColName());
                sqlExpression.setExprType(4);
                sqlExpression.setColumn(new AttributeColumn());
                sqlExpression.getColumn().columnName = sysColumn.getColName();
                sqlExpression.setAlias(sysColumn.getColName());
                sqlExpression.setOuterAlias(sysColumn.getColName());
                this.aQueryTree.getProjectionList().add(sqlExpression);
            }
            QueryTreeHandler.checkAndExpand(this.aQueryTree.getProjectionList(), this.aQueryTree.getRelationNodeList(), this.database, this.commandToExecute);
            QueryTreeHandler.FillAllExprDataTypes(this.aQueryTree, this.database);
            QueryTreeHandler.setOwnerShipColumns(this.aQueryTree);
            object = new QueryProcessor(this.client, this.aQueryTree);
            ((QueryProcessor)object).setSkipPermissionCheck(Collections.singleton(this.tableName));
            ((QueryProcessor)object).prepare();
        }
        Iterator<SysColumn> iterator = object;
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object prepareFinalStatements(SysTable sysTable, SysTable sysTable2) throws Exception {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM ");
        stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName()));
        if (sysTable2 == null) {
            if (this.whereCondition != null) {
                stringBuffer.append(" WHERE ").append(this.whereCondition.rebuildString());
            }
        } else {
            stringBuffer.append(" WHERE EXISTS (SELECT 1 FROM ");
            stringBuffer.append(IdentifierHandler.quote(sysTable2.getTableName())).append(" WHERE ");
            for (SysColumn sysColumn : sysTable.getRowID()) {
                if (sysColumn.isNullable()) {
                    stringBuffer.append("(");
                    stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(".");
                    stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append("=");
                    stringBuffer.append(IdentifierHandler.quote(sysTable2.getTableName())).append(".");
                    stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append(" or ");
                    stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(".");
                    stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append(" IS NULL AND ");
                    stringBuffer.append(IdentifierHandler.quote(sysTable2.getTableName())).append(".");
                    stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append(" IS NULL) AND ");
                    continue;
                }
                stringBuffer.append("(");
                stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(".");
                stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append("=");
                stringBuffer.append(IdentifierHandler.quote(sysTable2.getTableName())).append(".");
                stringBuffer.append(IdentifierHandler.quote(sysColumn.getColName())).append(") AND ");
            }
            stringBuffer.setLength(stringBuffer.length() - 5);
            stringBuffer.append(")");
        }
        String string = stringBuffer.toString();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillTempTable(Object object, SysTable sysTable, Engine engine) throws Exception {
        block11: {
            if (!(object instanceof IExecutable)) break block11;
            ResultSet resultSet = ((IExecutable)object).execute(engine).getResultSet();
            try {
                CharSequence charSequence;
                StringBuffer stringBuffer = new StringBuffer("INSERT INTO ");
                stringBuffer.append(IdentifierHandler.quote(sysTable.getTableName())).append(" (");
                for (SysColumn sysColumn : sysTable.getColumns()) {
                    charSequence = sysColumn.getColName();
                    stringBuffer.append(IdentifierHandler.quote((String)charSequence)).append(", ");
                }
                stringBuffer.setLength(stringBuffer.length() - 2);
                stringBuffer.append(") VALUES (");
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n = resultSetMetaData.getColumnCount();
                while (resultSet.next()) {
                    charSequence = new StringBuffer();
                    int n2 = 1;
                    for (SysColumn sysColumn : sysTable.getColumns()) {
                        if (n2 <= n) {
                            String string = resultSet.getString(n2);
                            if (string != null && RSHelper.getQuoteInfo(sysColumn)) {
                                ((StringBuffer)charSequence).append("'").append(string.replaceAll("'", "''")).append("'");
                            } else {
                                ((StringBuffer)charSequence).append(string);
                            }
                        }
                        ((StringBuffer)charSequence).append(", ");
                        ++n2;
                    }
                    ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 2);
                    ((StringBuffer)charSequence).append(")");
                    String string = stringBuffer.toString() + ((StringBuffer)charSequence).toString();
                    if (engine.addToBatchOnNodes(string, sysTable.getNodeList(), this.client)) continue;
                    this.executeCurrentBatch(engine);
                }
            }
            finally {
                resultSet.close();
            }
            this.executeCurrentBatch(engine);
        }
    }

    @Override
    protected int internalExecute(Object object, Engine engine) throws Exception {
        Collection<DBNode> collection;
        if (this.getTempTable() == null && this.getTargetTable().getPartitionedColumn() != null && this.whereCondition != null && (collection = this.whereCondition.getPartitionedNode(this.client)) != null) {
            this.nodeList = collection;
        }
        return super.internalExecute(object, engine);
    }

    @Override
    protected short getPrivilege() {
        return 3;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }

    public boolean manualParse(String string) {
        Lexer lexer = new Lexer(string);
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("DELETE")) {
            return false;
        }
        if (!lexer.hasMoreTokens() || !lexer.nextToken().equalsIgnoreCase("FROM")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        this.tableName = lexer.nextToken();
        if (!lexer.hasMoreTokens()) {
            return true;
        }
        QueryTreeTracker queryTreeTracker = this.commandToExecute.getaQueryTreeTracker();
        queryTreeTracker.registerTree(this.aQueryTree);
        RelationNode relationNode = this.aQueryTree.newRelationNode();
        relationNode.setNodeType(2);
        relationNode.setTableName(this.tableName);
        relationNode.setTemporaryTable(this.client.getTempTableName(this.tableName) != null);
        relationNode.setClient(this.commandToExecute.getClientContext());
        relationNode.setAlias("");
        String string2 = lexer.nextToken();
        if (!string2.equalsIgnoreCase("WHERE")) {
            return false;
        }
        if (!lexer.hasMoreTokens()) {
            return false;
        }
        do {
            QueryCondition queryCondition;
            if ((queryCondition = ParserHelper.getSimpleCondition(lexer, this.getTargetTable(), this.aQueryTree, this.client)) == null) {
                return false;
            }
            this.whereCondition = this.whereCondition == null ? queryCondition : ParserHelper.chainQueryConditions(this.whereCondition, "AND", queryCondition);
        } while (lexer.hasMoreTokens() && lexer.nextToken().equalsIgnoreCase("AND"));
        if (this.whereCondition != null) {
            QueryTreeHandler.ProcessWhereCondition(this.whereCondition, this.aQueryTree, queryTreeTracker, this.database);
        }
        if (lexer.hasMoreTokens()) {
            string2 = lexer.nextToken();
            if (!string2.equals(";")) {
                return false;
            }
            if (lexer.hasMoreTokens()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public int getResultType() {
        return 15;
    }
}

