/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncCreateView;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.core.syntaxtree.createView;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.QueryTreeHandler;
import com.edb.gridsql.parser.handler.QueryTreeTracker;
import com.edb.gridsql.parser.handler.TableNameHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlCreateView
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlCreateView.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private Command commandToExecute;
    private QueryTree aQueryTree = null;
    private String selectString;
    private boolean isReplace = false;
    private Vector colList = new Vector();
    private Vector colDef = new Vector();
    private Vector DependedSysCol = new Vector();
    private String viewName;
    private static int genCount = 0;
    private boolean prepared = false;

    public SqlCreateView(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.commandToExecute = new Command(3, this, new QueryTreeTracker(), xDBSessionContext);
        this.commandToExecute.setCmdForCreateView();
    }

    public LockSpecification getLockSpecs() {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        LockSpecification lockSpecification = new LockSpecification(vector, vector2);
        return lockSpecification;
    }

    public Collection getNodeList() {
        HashSet hashSet = new HashSet();
        return hashSet;
    }

    @Override
    public long getCost() {
        return 10000000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        if (this.client.getCurrentUser().getUserClass() == 2) {
            XDBSecurityException xDBSecurityException = new XDBSecurityException("You are not allowed to create tables");
            logger.throwing(xDBSecurityException);
            throw xDBSecurityException;
        }
        if (this.database.isViewExists(this.viewName) && !this.isReplace) {
            throw new XDBServerException("Duplicate View Name :(" + this.viewName + ")");
        }
        this.prepared = true;
    }

    @Override
    public boolean isPrepared() {
        return this.prepared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        if (!this.isPrepared()) {
            this.prepare();
        }
        SyncCreateView syncCreateView = new SyncCreateView(this);
        MetaData metaData = MetaData.getMetaData();
        metaData.beginTransaction();
        try {
            syncCreateView.execute(this.database);
            metaData.commitTransaction(syncCreateView);
        }
        catch (Exception exception) {
            logger.catching(exception);
            metaData.rollbackTransaction();
            throw exception;
        }
        ExecutionResult executionResult = ExecutionResult.createSuccessResult(14);
        return executionResult;
    }

    @Override
    public Object visit(createView createView2, Object object) {
        int n;
        Object var3_3 = null;
        switch (createView2.f0.which) {
            case 0: {
                this.isReplace = false;
                break;
            }
            case 1: {
                this.isReplace = true;
            }
        }
        createView2.f1.accept(this, object);
        TableNameHandler tableNameHandler = new TableNameHandler(this.client);
        createView2.f2.accept(tableNameHandler, object);
        this.viewName = tableNameHandler.getTableName();
        QueryTreeHandler queryTreeHandler = new QueryTreeHandler(this.commandToExecute);
        this.aQueryTree = new QueryTree();
        createView2.f5.accept(queryTreeHandler, this.aQueryTree);
        for (int i = 0; i < this.aQueryTree.getProjectionList().size(); ++i) {
            if (this.aQueryTree.getProjectionList().get(i).getAlias() == null || this.aQueryTree.getProjectionList().get(i).getAlias().equals("")) {
                if (this.aQueryTree.getProjectionList().get(i).getExprType() != 4) {
                    this.aQueryTree.getProjectionList().get(i).setAlias("VIEW_EXPRESSION" + ++genCount);
                } else {
                    this.aQueryTree.getProjectionList().get(i).setAlias(this.aQueryTree.getProjectionList().get((int)i).getColumn().columnName);
                }
            }
            this.colList.add(this.aQueryTree.getProjectionList().get(i).getAlias());
            this.colDef.add(this.aQueryTree.getProjectionList().get(i).getExprDataType());
        }
        if (createView2.f3.present()) {
            ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
            createView2.f3.accept(columnNameListHandler, null);
            if (this.aQueryTree.getProjectionList().size() < this.colList.size()) {
                throw new XDBServerException("CREATE VIEW specifies more column names than columns");
            }
            for (n = 0; n < columnNameListHandler.getColumnNameList().size(); ++n) {
                this.aQueryTree.getProjectionList().get(n).setAlias((String)this.colList.get(n));
                this.colList.set(n, columnNameListHandler.getColumnNameList().get(n));
            }
        }
        String string = ((String)object).trim();
        string = string.substring(0, string.length() - 1);
        string = string.trim();
        string = string.replaceAll("\t", " ");
        string = string.replaceAll("\n", " ");
        string = string.replaceAll("\r", " ");
        while (string.contains("  ")) {
            string = string.replaceAll("  ", " ");
        }
        n = string.toUpperCase().indexOf(" AS SELECT ");
        if (n != -1) {
            this.selectString = string.substring(n + 4);
        } else {
            string = string.replaceAll("\\(SELECT ", " ( SELECT ");
            n = (string = string.replaceAll("  ", " ")).toUpperCase().indexOf(" AS ( SELECT ");
            this.selectString = n != -1 ? string.substring(n + 6, string.length() - 1) : this.aQueryTree.rebuildString();
        }
        this.DependedSysCol = this.getDependedColumns(this.aQueryTree);
        for (QueryTree queryTree : this.aQueryTree.getUnionQueryTreeList()) {
            this.DependedSysCol.addAll(this.getDependedColumns(queryTree));
        }
        this.DependedSysCol = new Vector(new HashSet(this.DependedSysCol));
        return var3_3;
    }

    private Vector getDependedColumns(QueryTree queryTree) {
        IRebuildString iRebuildString;
        Vector<SysColumn> vector = new Vector<SysColumn>();
        if (queryTree.getRelationSubqueryList() != null && queryTree.getRelationSubqueryList().size() > 0) {
            for (RelationNode object22 : queryTree.getRelationSubqueryList()) {
                this.getDependedColumns(object22.getSubqueryTree());
            }
        }
        vector.addAll(this.getAllSysColumns(queryTree.getProjectionList()));
        Vector<QueryCondition> vector2 = new Vector();
        Vector<SqlExpression> vector3 = new Vector<SqlExpression>();
        if (queryTree.getWhereRootCondition() != null) {
            vector2 = QueryCondition.getNodes(queryTree.getWhereRootCondition(), 4);
            for (QueryCondition queryCondition : vector2) {
                vector3.add(queryCondition.getExpr());
            }
            vector.addAll(this.getAllSysColumns(vector3));
        }
        Vector<QueryCondition> vector4 = new Vector();
        Vector<SqlExpression> vector5 = new Vector<SqlExpression>();
        for (QueryCondition queryCondition : queryTree.getConditionList()) {
            iRebuildString = queryCondition;
            vector4 = QueryCondition.getNodes((QueryCondition)iRebuildString, 4);
            for (QueryCondition queryCondition2 : vector4) {
                vector5.add(queryCondition2.getExpr());
            }
            vector.addAll(this.getAllSysColumns(vector5));
        }
        for (RelationNode relationNode : queryTree.getRelationNodeList()) {
            iRebuildString = relationNode;
            if (((RelationNode)iRebuildString).getNodeType() != 2) continue;
            vector.addAll(this.client.getSysDatabase().getSysTable(((RelationNode)iRebuildString).getTableName()).getRowID());
        }
        return vector;
    }

    private List<SysColumn> getAllSysColumns(List<SqlExpression> list) {
        ArrayList<SysColumn> arrayList = new ArrayList<SysColumn>();
        for (SqlExpression sqlExpression : list) {
            for (SqlExpression sqlExpression2 : sqlExpression.getNodes(sqlExpression, 4)) {
                while (sqlExpression2.getMappedExpression() != null) {
                    sqlExpression2 = sqlExpression2.getMappedExpression();
                }
                SysColumn sysColumn = this.client.getSysDatabase().getSysTable(sqlExpression2.getColumn().getTableName()).getSysColumn(sqlExpression2.getColumn().columnName);
                arrayList.add(sysColumn);
            }
        }
        return arrayList;
    }

    public String getSelectString() {
        return this.selectString;
    }

    public void setSelectString(String string) {
        this.selectString = string;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String string) {
        this.viewName = string;
    }

    public Vector getColList() {
        return this.colList;
    }

    public Vector getColDef() {
        return this.colDef;
    }

    public void setColDef(Vector vector) {
        this.colDef = vector;
    }

    public Vector getDependedSysCol() {
        return this.DependedSysCol;
    }

    public void setDependedSysCol(Vector vector) {
        this.DependedSysCol = vector;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return true;
    }
}

