/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.optimizer.QueryCondition;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import com.edb.gridsql.parser.ExpressionType;
import com.edb.gridsql.parser.core.syntaxtree.ColumnDeclare;
import com.edb.gridsql.parser.core.syntaxtree.DefaultSpec;
import com.edb.gridsql.parser.core.syntaxtree.Node;
import com.edb.gridsql.parser.core.syntaxtree.NodeChoice;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.DataTypeHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.parser.handler.QueryConditionHandler;
import com.edb.gridsql.parser.handler.RawImageHandler;

public class SqlCreateTableColumn
extends ObjectDepthFirst {
    public static String IDX_SERIAL_NAME = "IDX_SERIAL";
    public static final String XROWID_NAME = "xrowid";
    public static final SqlCreateTableColumn ROW_ID_COLUMN = new SqlCreateTableColumn("xrowid", new DataTypeHandler(Property.getInt("xdb.xrowid.SQLtype", 3), Property.getInt("xdb.xrowid.length", 0), Property.getInt("xdb.xrowid.precision", 31), Property.getInt("xdb.xrowid.scale", 0)), false, null);
    private Command commandToExecute;
    public String columnName;
    private DataTypeHandler typeHandler;
    public int isnullable = 1;
    protected boolean isPrimaryKey;
    protected SqlForeignReference aSqlForeignReference = null;
    protected QueryCondition checkCondition;
    String defaultValue;
    private String columnDef;

    SqlCreateTableColumn(String string, DataTypeHandler dataTypeHandler, boolean bl, String string2) {
        this.columnName = string;
        this.typeHandler = dataTypeHandler;
        this.isnullable = bl ? 1 : 0;
        this.defaultValue = string2;
    }

    public SqlCreateTableColumn(SqlExpression sqlExpression) {
        this.columnName = sqlExpression.getAlias();
        ExpressionType expressionType = sqlExpression.getExprDataType();
        this.typeHandler = new DataTypeHandler(expressionType.type, expressionType.length, expressionType.precision, expressionType.scale);
    }

    public SqlCreateTableColumn(Command command) {
        this.commandToExecute = command;
    }

    public Object visit(ColumnDeclare columnDeclare, Object object) {
        Node node;
        Object var3_3 = null;
        this.columnName = (String)columnDeclare.f0.accept(new IdentifierHandler(), object);
        this.typeHandler = new DataTypeHandler();
        columnDeclare.f1.accept(this.typeHandler, object);
        if (columnDeclare.f2.present()) {
            node = (NodeChoice)columnDeclare.f2.node;
            switch (((NodeChoice)node).which) {
                case 0: {
                    this.isnullable = 0;
                    break;
                }
                case 1: {
                    this.isnullable = 1;
                }
            }
        }
        columnDeclare.f3.accept(this, object);
        if (columnDeclare.f4.present()) {
            this.isPrimaryKey = true;
        }
        if (columnDeclare.f5.present()) {
            node = (NodeSequence)columnDeclare.f5.node;
            Node node2 = ((NodeSequence)node).elementAt(2);
            QueryConditionHandler queryConditionHandler = new QueryConditionHandler(this.commandToExecute);
            node2.accept(queryConditionHandler, object);
            this.checkCondition = queryConditionHandler.aRootCondition;
        }
        return var3_3;
    }

    public String getTypeHandlerString() {
        return this.typeHandler.getTypeString();
    }

    public DataTypeHandler getTypeHandler() {
        return this.typeHandler;
    }

    public void setTypeHandler(DataTypeHandler dataTypeHandler) {
        this.typeHandler = dataTypeHandler;
    }

    public String getColumnAttrString() {
        String string = "";
        if (this.isnullable != 1) {
            string = string + " NOT NULL";
        }
        if (this.defaultValue != null) {
            string = string + " DEFAULT " + this.defaultValue;
        }
        if (this.aSqlForeignReference != null) {
            string = string + "  REFERENCES " + this.aSqlForeignReference.getTableName() + " ( " + this.aSqlForeignReference.getColumnName() + " ) ";
        }
        if (this.checkCondition != null) {
            string = string + "  CHECK  ( " + this.checkCondition.rebuildString() + " ) ";
        }
        return string;
    }

    public String rebuildString() {
        if (this.columnDef == null) {
            this.columnDef = IdentifierHandler.quote(this.columnName) + " " + this.typeHandler.getTypeString();
            if (this.isnullable != 1) {
                this.columnDef = this.columnDef + " NOT NULL";
            }
            if (this.defaultValue != null) {
                this.columnDef = this.columnDef + " DEFAULT " + this.defaultValue;
            }
            if (this.aSqlForeignReference != null) {
                this.columnDef = this.columnDef + "  REFERENCES " + IdentifierHandler.quote(this.aSqlForeignReference.getTableName()) + " ( " + IdentifierHandler.quote(this.aSqlForeignReference.getColumnName()) + " ) ";
            }
            if (this.checkCondition != null) {
                this.columnDef = this.columnDef + "  CHECK  ( " + this.checkCondition.rebuildString() + " ) ";
            }
        }
        return this.columnDef;
    }

    public Object visit(DefaultSpec defaultSpec, Object object) {
        Object var3_3 = null;
        RawImageHandler rawImageHandler = new RawImageHandler();
        defaultSpec.f1.accept(rawImageHandler, object);
        this.defaultValue = rawImageHandler.getImage();
        return var3_3;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getcheckConditionString() {
        return this.checkCondition != null ? this.checkCondition.rebuildString() : null;
    }

    public boolean canBePartitioningKey() {
        return this.typeHandler.canBePartitioningKey();
    }

    public boolean isSerial() {
        return this.typeHandler.isSerial();
    }

    public int getColumnType() {
        return this.typeHandler.getSqlType();
    }

    public int getColumnLength() {
        return this.typeHandler.getLength();
    }

    public int getColumnPrecision() {
        return this.typeHandler.getPrecision();
    }

    public int getColumnScale() {
        return this.typeHandler.getScale();
    }

    class SqlForeignReference {
        String tableName;
        String columnName;

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public SqlForeignReference(String string, String string2) {
            this.tableName = string;
            this.columnName = string2;
        }
    }
}

