/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.SyncAlterTableDropConstraint;
import com.edb.gridsql.metadata.SysConstraint;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlAlterAddColumn;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterDropConstraint
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddColumn.class);
    private XDBSessionContext client;
    private SysDatabase database;
    private SqlAlterTable parent;
    private String constraintName;
    private String[] commands = null;
    private SysIndex indexToDrop;
    private int refId;
    private String refTableName = null;

    public SqlAlterDropConstraint(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.database = xDBSessionContext.getSysDatabase();
        this.parent = sqlAlterTable;
    }

    @Override
    public Object visit(Constraint constraint, Object object) {
        Object var3_3 = null;
        this.constraintName = (String)constraint.f1.accept(new IdentifierHandler(), object);
        return var3_3;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public int getRefId() {
        return this.refId;
    }

    public String getRefTableName() {
        return this.refTableName;
    }

    public int getIndexIdToDrop() {
        return this.indexToDrop == null ? -1 : this.indexToDrop.idxid;
    }

    @Override
    public LockSpecification<SysTable> getLockSpecs() {
        SysTable sysTable = null;
        if (this.refTableName != null) {
            sysTable = this.database.getSysTable(this.refTableName);
        }
        Set set = Collections.emptySet();
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(sysTable == null ? set : Collections.singleton(sysTable), set);
        return lockSpecification;
    }

    @Override
    public Collection<DBNode> getNodeList() {
        SysTable sysTable = null;
        if (this.refTableName != null) {
            sysTable = this.database.getSysTable(this.refTableName);
        }
        Collection<DBNode> collection = sysTable == null ? Collections.emptySet() : new ArrayList<DBNode>(sysTable.getNodeList());
        return collection;
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        String string;
        Object object;
        LinkedList<String> linkedList = new LinkedList<String>();
        SysTable sysTable = this.parent.getTable();
        sysTable.checkPermission(this.client.getCurrentUser(), (short)6);
        SysConstraint sysConstraint = sysTable.getConstraint(this.constraintName);
        if (sysConstraint == null) {
            throw new XDBServerException("Constraint " + this.constraintName + " is not found in table " + sysTable.getTableName());
        }
        if (sysConstraint.getSysTable() != sysTable) {
            throw new XDBServerException("Can not drop inherited constraint " + this.constraintName);
        }
        this.indexToDrop = sysTable.getSysIndex(sysConstraint.getIdxID());
        if (this.indexToDrop != null && this.indexToDrop.issyscreated == 0) {
            this.indexToDrop = null;
        }
        try {
            object = MetaData.getMetaData().executeQuery("SELECT refid, tablename from xsysreferences, xsystables WHERE  xsysreferences.constid=" + sysConstraint.getConstID() + " AND xsysreferences.Reftableid = xsystables.tableid ");
            if (object.next()) {
                this.refId = object.getInt(1);
                this.refTableName = object.getString(2).trim();
            }
        }
        catch (SQLException sQLException) {
            throw new XDBServerException(ErrorMessageRepository.SQL_EXEC_FAILURE, sQLException, ErrorMessageRepository.SQL_EXEC_FAILURE_CODE);
        }
        object = new HashMap();
        ((HashMap)object).put("table", IdentifierHandler.quote(sysTable.getTableName()));
        ((HashMap)object).put("constr_name", IdentifierHandler.quote(this.constraintName));
        if (sysConstraint.getIsSoft() == 0) {
            boolean bl;
            switch (sysConstraint.getConstType()) {
                case 'P': {
                    string = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_PRIMARY;
                    bl = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_PRIMARY_TO_PARENT;
                    break;
                }
                case 'U': {
                    string = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_UNIQUE;
                    bl = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_UNIQUE_TO_PARENT;
                    break;
                }
                case 'R': {
                    string = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_REFERENCE;
                    bl = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_REFERENCE_TO_PARENT;
                    break;
                }
                case 'C': {
                    string = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_CHECK;
                    bl = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_CHECK_TO_PARENT;
                    break;
                }
                default: {
                    string = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT;
                    bl = Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCONSTRAINT_TO_PARENT;
                }
            }
            string = ParseCmdLine.substitute(string, (Map<String, String>)object);
            if (string.length() > 0) {
                if (bl) {
                    this.parent.addCommonCommand(string);
                } else {
                    linkedList.add(string);
                }
            }
        }
        if (this.indexToDrop != null && Props.XDB_SQLCOMMAND_ALTERTABLE_DROP_INDEX_AFTER_DROP_CONSTRAINT) {
            ((HashMap)object).put("index_list", IdentifierHandler.quote(this.indexToDrop.idxname));
            string = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_DROP_INDEX, (Map<String, String>)object);
            linkedList.add(string);
        }
        this.commands = linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableDropConstraint(this), this.client);
        ExecutionResult executionResult = null;
        return executionResult;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

