/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBSecurityException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterDropColumn;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.SysView;
import com.edb.gridsql.parser.SqlAlterAddColumn;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.NodeSequence;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;

public class SqlAlterDropColumn
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddColumn.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String columnName;
    private String[] commands = null;

    public SqlAlterDropColumn(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    public Object visit(NodeSequence nodeSequence, Object object) {
        Object var3_3 = null;
        this.columnName = (String)nodeSequence.elementAt(1).accept(new IdentifierHandler(), object);
        return var3_3;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws Exception {
        Enumeration<Integer> enumeration;
        LinkedList<String> linkedList = new LinkedList<String>();
        SysTable sysTable = this.parent.getTable();
        sysTable.checkPermission(this.client.getCurrentUser(), (short)6);
        SysColumn sysColumn = sysTable.getSysColumn(this.columnName);
        if (sysColumn == null) {
            throw new XDBServerException(ErrorMessageRepository.COLUMN_NOT_IN_TABLE + " ( " + this.columnName + " , " + sysTable.getTableName() + " ) ", 0, ErrorMessageRepository.COLUMN_NOT_IN_TABLE_CODE);
        }
        Enumeration enumeration2 = this.parent.getDatabase().getAllViews();
        while (enumeration2.hasMoreElements()) {
            enumeration = (SysView)enumeration2.nextElement();
            if (!((SysView)((Object)enumeration)).hasDependedColumn(sysColumn.getColID())) continue;
            XDBSecurityException xDBSecurityException = new XDBSecurityException("cannot drop table " + sysTable.getTableName() + " column " + sysColumn.getColName() + " because other objects depend on it");
            throw xDBSecurityException;
        }
        if (sysTable.getPartitionedColumn() == sysColumn) {
            throw new XDBServerException(ErrorMessageRepository.PARTITIONING_COLUMN_OF_TABLE + " ( " + this.columnName + " , " + sysTable.getTableName() + " ) ", 0, ErrorMessageRepository.PARTITIONING_COLUMN_OF_TABLE_CODE);
        }
        if (sysColumn.getIndexType() == 1) {
            throw new XDBServerException(ErrorMessageRepository.PRIMARYKEY_COLUMN_OF_TABLE + " ( " + this.columnName + " , " + sysTable.getTableName() + " ) ", 0, ErrorMessageRepository.PRIMARYKEY_COLUMN_OF_TABLE_CODE);
        }
        enumeration = sysColumn.getChildColumns();
        if (enumeration.hasMoreElements()) {
            throw new XDBServerException(ErrorMessageRepository.COLUMN_REFFERENCES_EXIST + " ( " + this.columnName + " , " + sysTable.getTableName() + " ) ", 0, ErrorMessageRepository.COLUMN_REFFERENCES_EXIST_CODE);
        }
        if (sysTable != sysColumn.getSysTable()) {
            throw new XDBServerException("Can not drop inherited column");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
        hashMap.put("column", IdentifierHandler.quote(this.columnName));
        String string = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCOLUMN, hashMap);
        if (Props.XDB_SQLCOMMAND_ALTERTABLE_DROPCOLUMN_TO_PARENT) {
            this.parent.addCommonCommand(string);
        } else {
            linkedList.add(string);
        }
        this.commands = linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterDropColumn(this), this.client);
        ExecutionResult executionResult = null;
        return executionResult;
    }
}

