/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTablePrimaryKey;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.ColumnNameList;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.syntaxtree.PrimaryKeyDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ColumnNameListHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterAddPrimary
extends ObjectDepthFirst
implements IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddPrimary.class);
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String constraintName = null;
    private List<String> columnNameList = null;
    private int indexIdToUse = -1;
    private String[] commands;

    public SqlAlterAddPrimary(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    @Override
    public Object visit(Constraint constraint, Object object) {
        this.constraintName = (String)constraint.f1.accept(this, object);
        return null;
    }

    @Override
    public Object visit(ColumnNameList columnNameList, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        columnNameList.accept(columnNameListHandler, null);
        this.columnNameList = columnNameListHandler.getColumnNameList();
        return null;
    }

    @Override
    public Object visit(PrimaryKeyDef primaryKeyDef, Object object) {
        ColumnNameListHandler columnNameListHandler = new ColumnNameListHandler();
        primaryKeyDef.f2.accept(columnNameListHandler, null);
        if (this.columnNameList != null) {
            throw new XDBServerException("multiple primary keys for table " + this.parent.getTableName() + " are not allowed");
        }
        this.columnNameList = columnNameListHandler.getColumnNameList();
        return null;
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public int getIndexIDUsed() {
        return this.indexIdToUse;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public List<String> getColumnNames() {
        return this.columnNameList;
    }

    @Override
    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        Object object;
        CharSequence charSequence;
        LinkedList<String> linkedList = new LinkedList<String>();
        SysTable sysTable = this.parent.getTable();
        sysTable.checkPermission(this.client.getCurrentUser(), (short)6);
        for (String object32 : this.columnNameList) {
            charSequence = object32;
            object = sysTable.getSysColumn((String)charSequence);
            if (object != null) continue;
            throw new XDBServerException(ErrorMessageRepository.COLUMN_NOT_IN_TABLE + " (" + (String)charSequence + ", " + sysTable.getTableName() + ")", 0, ErrorMessageRepository.COLUMN_NOT_IN_TABLE_CODE);
        }
        List<SysColumn> list = sysTable.getPrimaryKey();
        if (list != null && list.size() > 0) {
            throw new XDBServerException(ErrorMessageRepository.PRIMARY_INDEX_ALREADY_PRESENT + " (" + sysTable.getTableName() + " )", 0, ErrorMessageRepository.PRIMARY_INDEX_ALREADY_PRESENT_CODE);
        }
        SysIndex sysIndex = sysTable.getPrimaryOrUniqueIndex(this.columnNameList);
        this.indexIdToUse = sysIndex == null ? -1 : sysIndex.idxid;
        charSequence = new StringBuffer();
        for (String string : this.columnNameList) {
            ((StringBuffer)charSequence).append(IdentifierHandler.quote(string)).append(", ");
        }
        ((StringBuffer)charSequence).setLength(((StringBuffer)charSequence).length() - 2);
        object = new HashMap<String, String>();
        ((HashMap)object).put("table", IdentifierHandler.quote(sysTable.getTableName()));
        ((HashMap)object).put("col_list", ((StringBuffer)charSequence).toString());
        if (this.constraintName == null) {
            this.constraintName = "PK_IDX_" + sysTable.getTableName();
        }
        ((HashMap)object).put("constr_name", IdentifierHandler.quote(this.constraintName));
        String string = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_ALTERTABLE_ADDPRIMARY, object);
        if (Props.XDB_SQLCOMMAND_ALTERTABLE_ADDPRIMARY_TO_PARENT) {
            this.parent.addCommonCommand(string);
        } else {
            linkedList.add(string);
        }
        this.commands = linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTablePrimaryKey(this), this.client);
        ExecutionResult executionResult = null;
        return executionResult;
    }
}

