/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.Engine;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IPreparable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.IMetaDataUpdate;
import com.edb.gridsql.metadata.SyncAlterTableForeignKey;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.core.syntaxtree.Constraint;
import com.edb.gridsql.parser.core.syntaxtree.ForeignKeyDef;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import com.edb.gridsql.parser.handler.ForeignKeyHandler;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlAlterAddForeignKey
extends ObjectDepthFirst
implements IXDBSql,
IPreparable {
    private static final XLogger logger = XLogger.getLogger(SqlAlterAddForeignKey.class);
    private static final int MAX_IDENTIFIER_LENGTH = 32;
    private XDBSessionContext client;
    private SqlAlterTable parent;
    private String indexName = null;
    private ForeignKeyHandler fkHandler;
    int indexIdToUse;
    int referingIndexId;
    private String[] commands;

    public SqlAlterAddForeignKey(SqlAlterTable sqlAlterTable, XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
        this.parent = sqlAlterTable;
    }

    @Override
    public Object visit(ForeignKeyDef foreignKeyDef, Object object) {
        if (this.fkHandler == null) {
            this.fkHandler = new ForeignKeyHandler(this.client);
        }
        return foreignKeyDef.accept(this.fkHandler, object);
    }

    @Override
    public Object visit(Constraint constraint, Object object) {
        if (this.fkHandler == null) {
            this.fkHandler = new ForeignKeyHandler(this.client);
        }
        return constraint.accept(this.fkHandler, object);
    }

    public SqlAlterTable getParent() {
        return this.parent;
    }

    public List<String> getColumnNames() {
        return this.fkHandler.getLocalColumnNames();
    }

    public String getReferedTableName() {
        return this.fkHandler.getForeignTableName();
    }

    public List<String> getReferedColumnNames() {
        return this.fkHandler.getForeignColumnNames();
    }

    public String getConstraintName() {
        String string = this.fkHandler.getConstraintName();
        return string.length() > 32 ? string.substring(0, 32) : string;
    }

    public int getIndexIDUsed() {
        return this.indexIdToUse;
    }

    public int getReferingIndexID() {
        return this.referingIndexId;
    }

    public String getIndexName() {
        if (this.indexName == null) {
            String string = "";
            for (String charSequence : this.fkHandler.getForeignColumnNames()) {
                string = string + "_" + charSequence;
            }
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    byte[] byArray;
                    StringBuffer stringBuffer = new StringBuffer();
                    messageDigest.update(string.getBytes());
                    for (byte by : byArray = messageDigest.digest()) {
                        int n = by & 0xF;
                        if (n < 10) {
                            stringBuffer.append(n);
                            continue;
                        }
                        stringBuffer.append((char)(n - 10 + 65));
                    }
                    string = stringBuffer.toString();
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            this.indexName = "FK_" + this.parent.getTableName() + "_" + this.fkHandler.getForeignTableName();
            if (this.indexName.length() > 32 - string.length()) {
                this.indexName = this.indexName.substring(0, 32 - string.length());
            }
            this.indexName = this.indexName + string;
        }
        return this.indexName;
    }

    public boolean isSoftConstraint() {
        return this.fkHandler.isSoft(this.parent.getTable().getPartitionColumn(), this.parent.getTable().getPartitionMap());
    }

    public LockSpecification getLockSpecs() {
        LockSpecification<SysTable> lockSpecification = new LockSpecification<SysTable>(Collections.singleton(this.fkHandler.getForeignTable()), Collections.EMPTY_LIST);
        return lockSpecification;
    }

    public Collection getNodeList() {
        return new ArrayList<DBNode>(this.fkHandler.getForeignTable().getNodeList());
    }

    @Override
    public long getCost() {
        return 1L;
    }

    @Override
    public boolean isPrepared() {
        return this.commands != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void prepare() throws Exception {
        void var5_8;
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        SysTable sysTable = this.parent.getTable();
        sysTable.checkPermission(this.client.getCurrentUser(), (short)6);
        for (String object32 : this.fkHandler.getLocalColumnNames()) {
            object = sysTable.getSysColumn(object32);
            if (object != null) continue;
            throw new XDBServerException(ErrorMessageRepository.COLUMN_NOT_IN_TABLE + " ( " + object32 + " , " + sysTable.getTableName() + " ) ", 0, ErrorMessageRepository.COLUMN_NOT_IN_TABLE_CODE);
        }
        for (String string : this.fkHandler.getForeignColumnNames()) {
            object = this.fkHandler.getForeignTable().getSysColumn(string);
            if (object != null) continue;
            throw new XDBServerException(ErrorMessageRepository.COLUMN_NOT_IN_TABLE + " ( " + string + " , " + this.fkHandler.getForeignTableName() + " ) ", 0, ErrorMessageRepository.COLUMN_NOT_IN_TABLE_CODE);
        }
        SysIndex sysIndex = this.fkHandler.getForeignTable().getPrimaryOrUniqueIndex(this.fkHandler.getForeignColumnNames());
        if (sysIndex == null || (this.indexIdToUse = sysIndex.idxid) == -1) {
            throw new XDBServerException(ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX + "( " + this.fkHandler.getForeignTableName() + " ) ", 0, ErrorMessageRepository.NO_PRIMARY_UNQIUE_INDEX_CODE);
        }
        Object var5_7 = null;
        for (SysIndex sysIndex2 : sysTable.getSysIndexes(this.fkHandler.getLocalColumnNames())) {
            if (var5_8 != null && sysIndex2.getIndexLength() >= var5_8.getIndexLength()) continue;
            SysIndex sysIndex3 = sysIndex2;
        }
        int n = this.referingIndexId = var5_8 == null ? -1 : var5_8.idxid;
        if (this.referingIndexId < 0) {
            void var7_13;
            object = "CREATE  INDEX " + IdentifierHandler.quote(this.getIndexName()) + " ON " + this.parent.getTableName() + " ( ";
            Object var7_12 = null;
            for (String string : this.fkHandler.getLocalColumnNames()) {
                String string2 = var7_13 == null ? IdentifierHandler.quote(string) : (String)var7_13 + ", " + IdentifierHandler.quote(string);
            }
            object = (String)object + (String)var7_13 + ")";
            linkedList.add(object);
        }
        if (!this.isSoftConstraint()) {
            object = new StringBuffer();
            for (String string : this.fkHandler.getLocalColumnNames()) {
                ((StringBuffer)object).append(IdentifierHandler.quote(string)).append(", ");
            }
            ((StringBuffer)object).setLength(((StringBuffer)object).length() - 2);
            StringBuffer stringBuffer = new StringBuffer();
            for (String string : this.fkHandler.getForeignColumnNames()) {
                stringBuffer.append(IdentifierHandler.quote(string)).append(", ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("table", IdentifierHandler.quote(sysTable.getTableName()));
            hashMap.put("col_map_list", stringBuffer.toString());
            hashMap.put("col_list", ((StringBuffer)object).toString());
            hashMap.put("constr_name", IdentifierHandler.quote(this.getConstraintName()));
            hashMap.put("reftable", IdentifierHandler.quote(this.fkHandler.getForeignTableName()));
            String string = ParseCmdLine.substitute(Props.XDB_SQLCOMMAND_ALTERTABLE_ADDFOREIGNKEY, hashMap);
            if (Props.XDB_SQLCOMMAND_ALTERTABLE_ADDFOREIGNKEY_TO_PARENT) {
                this.parent.addCommonCommand(string);
            } else {
                linkedList.add(string);
            }
        }
        if (this.isSoftConstraint()) {
            // empty if block
        }
        this.commands = linkedList.toArray(new String[linkedList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResult execute(Engine engine) throws Exception {
        engine.executeDDLOnMultipleNodes(this.commands, this.parent.getNodeList(), (IMetaDataUpdate)new SyncAlterTableForeignKey(this), this.client);
        ExecutionResult executionResult = null;
        return executionResult;
    }

    @Override
    public boolean needCoordinatorConnection() {
        return false;
    }
}

