/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.parser.IXDBSql;
import com.edb.gridsql.parser.SqlAddNodesToDB;
import com.edb.gridsql.parser.SqlAlterTable;
import com.edb.gridsql.parser.SqlAlterTableSpace;
import com.edb.gridsql.parser.SqlAlterUser;
import com.edb.gridsql.parser.SqlAnalyzeDatabase;
import com.edb.gridsql.parser.SqlBeginTransaction;
import com.edb.gridsql.parser.SqlBulkInsert;
import com.edb.gridsql.parser.SqlBulkInsertNext;
import com.edb.gridsql.parser.SqlCluster;
import com.edb.gridsql.parser.SqlCommitTransaction;
import com.edb.gridsql.parser.SqlCopyData;
import com.edb.gridsql.parser.SqlCreateDatabase;
import com.edb.gridsql.parser.SqlCreateIndex;
import com.edb.gridsql.parser.SqlCreateTable;
import com.edb.gridsql.parser.SqlCreateTableSpace;
import com.edb.gridsql.parser.SqlCreateUser;
import com.edb.gridsql.parser.SqlCreateView;
import com.edb.gridsql.parser.SqlDeallocate;
import com.edb.gridsql.parser.SqlDeleteTable;
import com.edb.gridsql.parser.SqlDescribeTable;
import com.edb.gridsql.parser.SqlDropDatabase;
import com.edb.gridsql.parser.SqlDropIndex;
import com.edb.gridsql.parser.SqlDropNodesFromDB;
import com.edb.gridsql.parser.SqlDropTable;
import com.edb.gridsql.parser.SqlDropTableSpace;
import com.edb.gridsql.parser.SqlDropTempTables;
import com.edb.gridsql.parser.SqlDropUser;
import com.edb.gridsql.parser.SqlDropView;
import com.edb.gridsql.parser.SqlExecDirect;
import com.edb.gridsql.parser.SqlGrant;
import com.edb.gridsql.parser.SqlInsertTable;
import com.edb.gridsql.parser.SqlIsolationLevel;
import com.edb.gridsql.parser.SqlKill;
import com.edb.gridsql.parser.SqlRenameTable;
import com.edb.gridsql.parser.SqlRevoke;
import com.edb.gridsql.parser.SqlRollbackTransaction;
import com.edb.gridsql.parser.SqlSelect;
import com.edb.gridsql.parser.SqlSetProperty;
import com.edb.gridsql.parser.SqlShowConstraints;
import com.edb.gridsql.parser.SqlShowDatabases;
import com.edb.gridsql.parser.SqlShowIndexes;
import com.edb.gridsql.parser.SqlShowProperty;
import com.edb.gridsql.parser.SqlShowStatements;
import com.edb.gridsql.parser.SqlShowTables;
import com.edb.gridsql.parser.SqlShowTranIsolation;
import com.edb.gridsql.parser.SqlShowUsers;
import com.edb.gridsql.parser.SqlShowViews;
import com.edb.gridsql.parser.SqlShutdownServer;
import com.edb.gridsql.parser.SqlStartDatabase;
import com.edb.gridsql.parser.SqlStopDatabase;
import com.edb.gridsql.parser.SqlTruncate;
import com.edb.gridsql.parser.SqlUpdateTable;
import com.edb.gridsql.parser.core.CSQLParser;
import com.edb.gridsql.parser.core.ParseException;
import com.edb.gridsql.parser.core.syntaxtree.AddNodeToDB;
import com.edb.gridsql.parser.core.syntaxtree.AlterTable;
import com.edb.gridsql.parser.core.syntaxtree.AlterTableSpace;
import com.edb.gridsql.parser.core.syntaxtree.AlterUser;
import com.edb.gridsql.parser.core.syntaxtree.AnalyzeDatabase;
import com.edb.gridsql.parser.core.syntaxtree.BeginTransaction;
import com.edb.gridsql.parser.core.syntaxtree.Cluster;
import com.edb.gridsql.parser.core.syntaxtree.CommitTransaction;
import com.edb.gridsql.parser.core.syntaxtree.CopyData;
import com.edb.gridsql.parser.core.syntaxtree.CreateDatabase;
import com.edb.gridsql.parser.core.syntaxtree.CreateTablespace;
import com.edb.gridsql.parser.core.syntaxtree.CreateUser;
import com.edb.gridsql.parser.core.syntaxtree.Deallocate;
import com.edb.gridsql.parser.core.syntaxtree.Delete;
import com.edb.gridsql.parser.core.syntaxtree.DescribeTable;
import com.edb.gridsql.parser.core.syntaxtree.DropDatabase;
import com.edb.gridsql.parser.core.syntaxtree.DropIndex;
import com.edb.gridsql.parser.core.syntaxtree.DropNodeFromDB;
import com.edb.gridsql.parser.core.syntaxtree.DropTablespace;
import com.edb.gridsql.parser.core.syntaxtree.DropUser;
import com.edb.gridsql.parser.core.syntaxtree.DropView;
import com.edb.gridsql.parser.core.syntaxtree.ExecDirect;
import com.edb.gridsql.parser.core.syntaxtree.Grant;
import com.edb.gridsql.parser.core.syntaxtree.InsertTable;
import com.edb.gridsql.parser.core.syntaxtree.Kill;
import com.edb.gridsql.parser.core.syntaxtree.RenameTable;
import com.edb.gridsql.parser.core.syntaxtree.Revoke;
import com.edb.gridsql.parser.core.syntaxtree.RollbackTransaction;
import com.edb.gridsql.parser.core.syntaxtree.Select;
import com.edb.gridsql.parser.core.syntaxtree.SetProperty;
import com.edb.gridsql.parser.core.syntaxtree.ShowConstraints;
import com.edb.gridsql.parser.core.syntaxtree.ShowDatabases;
import com.edb.gridsql.parser.core.syntaxtree.ShowIndexes;
import com.edb.gridsql.parser.core.syntaxtree.ShowProperty;
import com.edb.gridsql.parser.core.syntaxtree.ShowStatements;
import com.edb.gridsql.parser.core.syntaxtree.ShowTables;
import com.edb.gridsql.parser.core.syntaxtree.ShowTranIsolation;
import com.edb.gridsql.parser.core.syntaxtree.ShowUsers;
import com.edb.gridsql.parser.core.syntaxtree.ShowViews;
import com.edb.gridsql.parser.core.syntaxtree.ShutdownXDB;
import com.edb.gridsql.parser.core.syntaxtree.StartDatabase;
import com.edb.gridsql.parser.core.syntaxtree.StopDatabase;
import com.edb.gridsql.parser.core.syntaxtree.Truncate;
import com.edb.gridsql.parser.core.syntaxtree.UpdateStats;
import com.edb.gridsql.parser.core.syntaxtree.UpdateTable;
import com.edb.gridsql.parser.core.syntaxtree.VacuumDatabase;
import com.edb.gridsql.parser.core.syntaxtree.createIndex;
import com.edb.gridsql.parser.core.syntaxtree.createTable;
import com.edb.gridsql.parser.core.syntaxtree.createView;
import com.edb.gridsql.parser.core.syntaxtree.dropTable;
import com.edb.gridsql.parser.core.syntaxtree.process;
import com.edb.gridsql.parser.core.visitor.ObjectDepthFirst;
import java.io.Reader;
import java.io.StringReader;

public class Parser
extends ObjectDepthFirst {
    private IXDBSql sqlObject;
    private XDBSessionContext client;

    public Parser(XDBSessionContext xDBSessionContext) {
        this.client = xDBSessionContext;
    }

    public void parseStatement(String string) throws ParseException {
        if (string.length() > 0) {
            int n;
            int n2 = string.length() - 1;
            for (n = 0; Character.isWhitespace(string.charAt(n)) && n < n2; ++n) {
            }
            while ((Character.isWhitespace(string.charAt(n2)) || Character.isISOControl(string.charAt(n2))) && n < n2) {
                --n2;
            }
            string = string.substring(n, n2 + 1);
        }
        this.parse(string);
    }

    public void parseBulkInsert(String string) {
        this.sqlObject = new SqlBulkInsert(string, this.client);
    }

    public void parseBulkInsertNext(String string) {
        this.sqlObject = new SqlBulkInsertNext(string, this.client);
    }

    public void parseAddDropNode(String string) {
        String[] stringArray = ParseCmdLine.splitCmdLine(string);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
        if (stringArray[0].equals("AddNodesToDB")) {
            this.sqlObject = new SqlAddNodesToDB(stringArray2, this.client);
        } else if (stringArray[0].equals("DropNodesFromDB")) {
            this.sqlObject = new SqlDropNodesFromDB(stringArray2, this.client);
        }
    }

    public void parseCloseResultSet(String string) {
        this.sqlObject = new SqlDropTempTables(string, this.client);
    }

    public void parseSetIsolation(String string) {
        this.sqlObject = new SqlIsolationLevel(string, this.client);
    }

    public Object visit(DropIndex dropIndex, Object object) {
        SqlDropIndex sqlDropIndex = new SqlDropIndex(this.client);
        dropIndex.accept(sqlDropIndex, object);
        this.sqlObject = sqlDropIndex;
        return null;
    }

    public Object visit(RenameTable renameTable, Object object) {
        SqlRenameTable sqlRenameTable = new SqlRenameTable(this.client);
        renameTable.accept(sqlRenameTable, object);
        this.sqlObject = sqlRenameTable;
        return null;
    }

    public Object visit(UpdateStats updateStats, Object object) {
        SqlAnalyzeDatabase sqlAnalyzeDatabase = new SqlAnalyzeDatabase(this.client);
        updateStats.accept(sqlAnalyzeDatabase, object);
        this.sqlObject = sqlAnalyzeDatabase;
        return null;
    }

    public Object visit(UpdateTable updateTable, Object object) {
        SqlUpdateTable sqlUpdateTable = new SqlUpdateTable(this.client);
        updateTable.accept(sqlUpdateTable, object);
        this.sqlObject = sqlUpdateTable;
        return null;
    }

    public Object visit(InsertTable insertTable, Object object) {
        SqlInsertTable sqlInsertTable = new SqlInsertTable(this.client);
        insertTable.accept(sqlInsertTable, object);
        this.sqlObject = sqlInsertTable;
        return null;
    }

    public Object visit(dropTable dropTable2, Object object) {
        SqlDropTable sqlDropTable = new SqlDropTable(this.client);
        dropTable2.accept(sqlDropTable, object);
        this.sqlObject = sqlDropTable;
        return null;
    }

    public Object visit(DropTablespace dropTablespace, Object object) {
        SqlDropTableSpace sqlDropTableSpace = new SqlDropTableSpace(this.client);
        dropTablespace.accept(sqlDropTableSpace, object);
        this.sqlObject = sqlDropTableSpace;
        return null;
    }

    public Object visit(AlterTable alterTable, Object object) {
        SqlAlterTable sqlAlterTable = new SqlAlterTable(this.client);
        alterTable.accept(sqlAlterTable, object);
        this.sqlObject = sqlAlterTable;
        return null;
    }

    public Object visit(AlterTableSpace alterTableSpace, Object object) {
        SqlAlterTableSpace sqlAlterTableSpace = new SqlAlterTableSpace(this.client);
        alterTableSpace.accept(sqlAlterTableSpace, object);
        this.sqlObject = sqlAlterTableSpace;
        return null;
    }

    public Object visit(ShowDatabases showDatabases, Object object) {
        SqlShowDatabases sqlShowDatabases = new SqlShowDatabases(this.client);
        showDatabases.accept(sqlShowDatabases, object);
        this.sqlObject = sqlShowDatabases;
        return null;
    }

    public Object visit(ShowStatements showStatements, Object object) {
        SqlShowStatements sqlShowStatements = new SqlShowStatements(this.client);
        showStatements.accept(sqlShowStatements, object);
        this.sqlObject = sqlShowStatements;
        return null;
    }

    public Object visit(ShowTables showTables, Object object) {
        SqlShowTables sqlShowTables = new SqlShowTables(this.client);
        showTables.accept(sqlShowTables, object);
        this.sqlObject = sqlShowTables;
        return null;
    }

    public Object visit(BeginTransaction beginTransaction, Object object) {
        SqlBeginTransaction sqlBeginTransaction = new SqlBeginTransaction(this.client);
        beginTransaction.accept(sqlBeginTransaction, object);
        this.sqlObject = sqlBeginTransaction;
        return null;
    }

    public Object visit(CommitTransaction commitTransaction, Object object) {
        SqlCommitTransaction sqlCommitTransaction = new SqlCommitTransaction(this.client);
        commitTransaction.accept(sqlCommitTransaction, object);
        this.sqlObject = sqlCommitTransaction;
        return null;
    }

    public Object visit(RollbackTransaction rollbackTransaction, Object object) {
        SqlRollbackTransaction sqlRollbackTransaction = new SqlRollbackTransaction(this.client);
        rollbackTransaction.accept(sqlRollbackTransaction, object);
        this.sqlObject = sqlRollbackTransaction;
        return null;
    }

    public Object visit(DescribeTable describeTable, Object object) {
        SqlDescribeTable sqlDescribeTable = new SqlDescribeTable(this.client);
        describeTable.accept(sqlDescribeTable, object);
        this.sqlObject = sqlDescribeTable;
        return null;
    }

    public Object visit(ShowConstraints showConstraints, Object object) {
        SqlShowConstraints sqlShowConstraints = new SqlShowConstraints(this.client);
        showConstraints.accept(sqlShowConstraints, object);
        this.sqlObject = sqlShowConstraints;
        return null;
    }

    public Object visit(ShowIndexes showIndexes, Object object) {
        SqlShowIndexes sqlShowIndexes = new SqlShowIndexes(this.client);
        showIndexes.accept(sqlShowIndexes, object);
        this.sqlObject = sqlShowIndexes;
        return null;
    }

    public Object visit(createIndex createIndex2, Object object) {
        SqlCreateIndex sqlCreateIndex = new SqlCreateIndex(this.client);
        createIndex2.accept(sqlCreateIndex, object);
        this.sqlObject = sqlCreateIndex;
        return null;
    }

    public Object visit(createTable createTable2, Object object) {
        SqlCreateTable sqlCreateTable = new SqlCreateTable(this.client);
        createTable2.accept(sqlCreateTable, object);
        this.sqlObject = sqlCreateTable;
        return null;
    }

    public Object visit(CreateTablespace createTablespace, Object object) {
        SqlCreateTableSpace sqlCreateTableSpace = new SqlCreateTableSpace(this.client);
        createTablespace.accept(sqlCreateTableSpace, object);
        this.sqlObject = sqlCreateTableSpace;
        return null;
    }

    public Object visit(createView createView2, Object object) {
        SqlCreateView sqlCreateView = new SqlCreateView(this.client);
        createView2.accept(sqlCreateView, object);
        this.sqlObject = sqlCreateView;
        return null;
    }

    public Object visit(CreateUser createUser, Object object) {
        SqlCreateUser sqlCreateUser = new SqlCreateUser(this.client);
        createUser.accept(sqlCreateUser, object);
        this.sqlObject = sqlCreateUser;
        return null;
    }

    public Object visit(AlterUser alterUser, Object object) {
        SqlAlterUser sqlAlterUser = new SqlAlterUser(this.client);
        alterUser.accept(sqlAlterUser, object);
        this.sqlObject = sqlAlterUser;
        return null;
    }

    public Object visit(DropUser dropUser, Object object) {
        SqlDropUser sqlDropUser = new SqlDropUser(this.client);
        dropUser.accept(sqlDropUser, object);
        this.sqlObject = sqlDropUser;
        return null;
    }

    public Object visit(DropView dropView, Object object) {
        SqlDropView sqlDropView = new SqlDropView(this.client);
        dropView.accept(sqlDropView, object);
        this.sqlObject = sqlDropView;
        return null;
    }

    public Object visit(Deallocate deallocate, Object object) {
        SqlDeallocate sqlDeallocate = new SqlDeallocate(this.client);
        deallocate.accept(sqlDeallocate, object);
        this.sqlObject = sqlDeallocate;
        return null;
    }

    public Object visit(AddNodeToDB addNodeToDB, Object object) {
        SqlAddNodesToDB sqlAddNodesToDB = new SqlAddNodesToDB(this.client);
        addNodeToDB.accept(sqlAddNodesToDB, object);
        this.sqlObject = sqlAddNodesToDB;
        return null;
    }

    public Object visit(DropNodeFromDB dropNodeFromDB, Object object) {
        SqlDropNodesFromDB sqlDropNodesFromDB = new SqlDropNodesFromDB(this.client);
        dropNodeFromDB.accept(sqlDropNodesFromDB, object);
        this.sqlObject = sqlDropNodesFromDB;
        return null;
    }

    public Object visit(StartDatabase startDatabase, Object object) {
        SqlStartDatabase sqlStartDatabase = new SqlStartDatabase(this.client);
        startDatabase.accept(sqlStartDatabase, object);
        this.sqlObject = sqlStartDatabase;
        return null;
    }

    public Object visit(StopDatabase stopDatabase, Object object) {
        SqlStopDatabase sqlStopDatabase = new SqlStopDatabase(this.client);
        stopDatabase.accept(sqlStopDatabase, object);
        this.sqlObject = sqlStopDatabase;
        return null;
    }

    public Object visit(CreateDatabase createDatabase, Object object) {
        SqlCreateDatabase sqlCreateDatabase = new SqlCreateDatabase(this.client);
        createDatabase.accept(sqlCreateDatabase, object);
        this.sqlObject = sqlCreateDatabase;
        return null;
    }

    public Object visit(DropDatabase dropDatabase, Object object) {
        SqlDropDatabase sqlDropDatabase = new SqlDropDatabase(this.client);
        dropDatabase.accept(sqlDropDatabase, object);
        this.sqlObject = sqlDropDatabase;
        return null;
    }

    public Object visit(ShutdownXDB shutdownXDB, Object object) {
        SqlShutdownServer sqlShutdownServer = new SqlShutdownServer(this.client);
        shutdownXDB.accept(sqlShutdownServer, object);
        this.sqlObject = sqlShutdownServer;
        return null;
    }

    public Object visit(Grant grant, Object object) {
        SqlGrant sqlGrant = new SqlGrant(this.client);
        grant.accept(sqlGrant, object);
        this.sqlObject = sqlGrant;
        return null;
    }

    public Object visit(Revoke revoke, Object object) {
        SqlRevoke sqlRevoke = new SqlRevoke(this.client);
        revoke.accept(sqlRevoke, object);
        this.sqlObject = sqlRevoke;
        return null;
    }

    public Object visit(ShowViews showViews, Object object) {
        SqlShowViews sqlShowViews = new SqlShowViews(this.client);
        showViews.accept(sqlShowViews, object);
        this.sqlObject = sqlShowViews;
        return null;
    }

    public Object visit(ShowProperty showProperty, Object object) {
        SqlShowProperty sqlShowProperty = new SqlShowProperty(this.client);
        showProperty.accept(sqlShowProperty, object);
        this.sqlObject = sqlShowProperty;
        return null;
    }

    public Object visit(ShowTranIsolation showTranIsolation, Object object) {
        SqlShowTranIsolation sqlShowTranIsolation = new SqlShowTranIsolation(this.client);
        showTranIsolation.accept(sqlShowTranIsolation, object);
        this.sqlObject = sqlShowTranIsolation;
        return null;
    }

    public Object visit(SetProperty setProperty, Object object) {
        SqlSetProperty sqlSetProperty = new SqlSetProperty(this.client);
        setProperty.accept(sqlSetProperty, object);
        this.sqlObject = sqlSetProperty;
        return null;
    }

    public Object visit(ShowUsers showUsers, Object object) {
        SqlShowUsers sqlShowUsers = new SqlShowUsers(this.client);
        showUsers.accept(sqlShowUsers, object);
        this.sqlObject = sqlShowUsers;
        return null;
    }

    public Object visit(Delete delete, Object object) {
        SqlDeleteTable sqlDeleteTable = new SqlDeleteTable(this.client);
        delete.accept(sqlDeleteTable, object);
        this.sqlObject = sqlDeleteTable;
        return null;
    }

    public Object visit(VacuumDatabase vacuumDatabase, Object object) {
        SqlAnalyzeDatabase sqlAnalyzeDatabase = new SqlAnalyzeDatabase(this.client);
        vacuumDatabase.accept(sqlAnalyzeDatabase, object);
        this.sqlObject = sqlAnalyzeDatabase;
        return null;
    }

    public Object visit(AnalyzeDatabase analyzeDatabase, Object object) {
        SqlAnalyzeDatabase sqlAnalyzeDatabase = new SqlAnalyzeDatabase(this.client);
        analyzeDatabase.accept(sqlAnalyzeDatabase, object);
        this.sqlObject = sqlAnalyzeDatabase;
        return null;
    }

    public Object visit(Cluster cluster, Object object) {
        SqlCluster sqlCluster = new SqlCluster(this.client);
        cluster.accept(sqlCluster, object);
        this.sqlObject = sqlCluster;
        return null;
    }

    public Object visit(Truncate truncate, Object object) {
        SqlTruncate sqlTruncate = new SqlTruncate(this.client);
        truncate.accept(sqlTruncate, object);
        this.sqlObject = sqlTruncate;
        return null;
    }

    public Object visit(ExecDirect execDirect, Object object) {
        SqlExecDirect sqlExecDirect = new SqlExecDirect(this.client);
        execDirect.accept(sqlExecDirect, object);
        this.sqlObject = sqlExecDirect;
        return null;
    }

    public Object visit(Select select, Object object) {
        SqlSelect sqlSelect = new SqlSelect(this.client);
        select.accept(sqlSelect, object);
        this.sqlObject = sqlSelect;
        return null;
    }

    public Object visit(CopyData copyData, Object object) {
        SqlCopyData sqlCopyData = new SqlCopyData(this.client);
        copyData.accept(sqlCopyData, object);
        this.sqlObject = sqlCopyData;
        return null;
    }

    public Object visit(Kill kill, Object object) {
        SqlKill sqlKill = new SqlKill(this.client);
        kill.accept(sqlKill, object);
        this.sqlObject = sqlKill;
        return null;
    }

    private void parse(String string) throws ParseException {
        Object object;
        Object object2;
        int n = (string = string.trim()).indexOf(32);
        if (n > 0) {
            object2 = string.substring(0, string.indexOf(32));
            if (Props.XDB_FASTPARSE_INSERT && ((String)object2).equalsIgnoreCase("INSERT")) {
                try {
                    object = new SqlInsertTable(this.client);
                    if (((SqlInsertTable)object).manualParse(string)) {
                        this.sqlObject = object;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Props.XDB_FASTPARSE_SELECT && ((String)object2).equalsIgnoreCase("SELECT")) {
                try {
                    object = new SqlSelect(this.client);
                    if (((SqlSelect)object).manualParse(string)) {
                        this.sqlObject = object;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Props.XDB_FASTPARSE_UPDATE && ((String)object2).equalsIgnoreCase("UPDATE")) {
                try {
                    object = new SqlUpdateTable(this.client);
                    if (((SqlUpdateTable)object).manualParse(string)) {
                        this.sqlObject = object;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (Props.XDB_FASTPARSE_DELETE && ((String)object2).equalsIgnoreCase("DELETE")) {
                try {
                    object = new SqlDeleteTable(this.client);
                    if (((SqlDeleteTable)object).manualParse(string)) {
                        this.sqlObject = object;
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        object2 = new StringReader(string);
        object = new CSQLParser((Reader)object2);
        try {
            process process2 = ((CSQLParser)object).process(System.out);
            process2.accept(this, string);
        }
        catch (ParseException parseException) {
            throw parseException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new ParseException(throwable.getMessage());
        }
        if (Props.XDB_ENABLE_ACTIVITY_LOG && this.sqlObject instanceof SqlSelect) {
            ((SqlSelect)this.sqlObject).setSelectString(string);
        }
    }

    public IXDBSql getSqlObject() {
        return this.sqlObject;
    }
}

