/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.parser;

import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import java.util.LinkedList;

public class Lexer {
    String lexString;
    int offset = 0;
    int length = 0;
    private LinkedList<String> peekedTokens = new LinkedList();

    public Lexer(String string) {
        this.lexString = string.trim();
        this.length = this.lexString != null ? this.lexString.length() : 0;
    }

    public boolean hasMoreTokens() {
        return !this.peekedTokens.isEmpty() || this.offset < this.length;
    }

    public String nextToken() throws XDBServerException {
        return this.peekedTokens.isEmpty() ? this.parseToken() : this.peekedTokens.remove();
    }

    public String peekToken(int n) throws XDBServerException {
        String string = null;
        while (n >= this.peekedTokens.size()) {
            string = this.parseToken();
            this.peekedTokens.add(string);
        }
        return string == null ? this.peekedTokens.get(n) : string;
    }

    private String parseToken() throws XDBServerException {
        String string = null;
        if (this.lexString == null || this.offset >= this.length) {
            throw new XDBServerException("No more tokens found.");
        }
        int n = 0;
        while (this.offset < this.length && this.lexString.charAt(this.offset) == ' ') {
            ++this.offset;
        }
        if (this.lexString.charAt(this.offset) == '\"') {
            ++n;
            while (this.offset + n < this.length) {
                if (this.lexString.charAt(this.offset + n) == '\"') {
                    if (this.offset + n + 1 >= this.length || this.lexString.charAt(this.offset + n + 1) != '\"') break;
                    n += 2;
                    continue;
                }
                ++n;
            }
            if (this.offset == this.length || this.offset + n >= this.length) {
                throw new XDBServerException("Syntax Error near character " + this.offset);
            }
            string = IdentifierHandler.stripQuotes(this.lexString.substring(this.offset, this.offset + n + 1));
            this.offset += n + 1;
            return string;
        }
        if (this.lexString.charAt(this.offset) == '\'') {
            ++n;
            while (true) {
                if (this.offset + n < this.length && this.lexString.charAt(this.offset + n) != '\'') {
                    ++n;
                    continue;
                }
                if (this.offset + n + 1 >= this.length || this.lexString.charAt(this.offset + n + 1) != '\'') break;
                n += 2;
            }
            if (this.offset == this.length || this.offset + n >= this.length) {
                throw new XDBServerException("Syntax Error near character " + this.offset);
            }
            string = this.lexString.substring(this.offset, this.offset + n + 1);
            this.offset = this.offset + n + 1;
            return string;
        }
        while (this.offset + n < this.length) {
            char c = this.lexString.charAt(this.offset + n);
            if (c == ' ') {
                string = this.lexString.substring(this.offset, this.offset + n);
                this.offset += n;
                break;
            }
            if (c == '.') {
                string = n == 0 ? this.lexString.substring(this.offset, this.offset + 1) : this.lexString.substring(this.offset, this.offset + n);
                try {
                    Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.offset = n == 0 ? ++this.offset : (this.offset += n);
                    return string;
                }
                int n2 = n + 1;
                while (this.offset + n2 < this.length) {
                    char c2 = this.lexString.charAt(this.offset + n2);
                    if (c2 < '0' || c2 > '9') {
                        if (n2 == n + 1) {
                            string = this.lexString.substring(this.offset, this.offset + n);
                            this.offset += n;
                            return string;
                        }
                        string = this.lexString.substring(this.offset, this.offset + n2);
                        this.offset += n2;
                        return string;
                    }
                    ++n2;
                }
                if (n2 == n + 1) {
                    string = this.lexString.substring(this.offset, this.offset + n);
                    this.offset += n;
                } else {
                    string = this.lexString.substring(this.offset, this.offset + n2);
                    this.offset += n2;
                }
                return string;
            }
            if (c == ',' || c == '(' || c == ')' || c == ';' || c == '+' || c == '-' || c == '*' || c == '/' || c == '%') {
                if (n == 0) {
                    string = this.lexString.substring(this.offset, this.offset + 1);
                    ++this.offset;
                    break;
                }
                string = this.lexString.substring(this.offset, this.offset + n);
                this.offset += n;
                break;
            }
            if (c == '=' || c == '<' || c == '>' || c == '!') {
                if (n > 0) {
                    string = this.lexString.substring(this.offset, this.offset + n);
                    this.offset += n;
                    break;
                }
                if (c == '=') {
                    ++this.offset;
                    return "=";
                }
                char c3 = this.lexString.charAt(this.offset);
                if (c == '<') {
                    if (c3 == '>') {
                        this.offset += 2;
                        return "<>";
                    }
                    if (c3 == '=') {
                        this.offset += 2;
                        return "<=";
                    }
                    ++this.offset;
                    return "<";
                }
                if (c == '>') {
                    if (c3 == '=') {
                        this.offset += 2;
                        return ">=";
                    }
                    ++this.offset;
                    return ">";
                }
                if (c == '!' && c3 == '=') {
                    this.offset += 2;
                    return "!=";
                }
                throw new XDBServerException("Syntax Error near character " + this.offset);
            }
            if (c == ':') {
                if (n > 0) {
                    string = this.lexString.substring(this.offset, this.offset + n);
                    this.offset += n;
                    break;
                }
                char c4 = this.lexString.charAt(this.offset);
                if (c4 == ':') {
                    this.offset += 2;
                    return "::";
                }
                throw new XDBServerException("Syntax Error near character " + this.offset);
            }
            ++n;
        }
        if (string == null) {
            string = this.lexString.substring(this.offset);
            this.offset = this.length;
        }
        return IdentifierHandler.normalizeCase(string);
    }

    public boolean isOperator(String string) throws XDBServerException {
        if (string.equals("=")) {
            return true;
        }
        if (string.equals("<")) {
            return true;
        }
        if (string.equals(">")) {
            return true;
        }
        if (string.equals("<=")) {
            return true;
        }
        if (string.equals(">=")) {
            return true;
        }
        if (string.equals("<>")) {
            return true;
        }
        return string.equals("!=");
    }

    public void checkTokens() throws XDBServerException {
        if (!this.hasMoreTokens()) {
            throw new XDBServerException("Token expected at end of string.");
        }
    }
}

