/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.optimizer;

import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ColumnNotFoundException;
import com.edb.gridsql.metadata.DBNode;
import com.edb.gridsql.metadata.SysDatabase;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.optimizer.AttributeColumn;
import com.edb.gridsql.optimizer.IRebuildString;
import com.edb.gridsql.optimizer.QuerySubTreeHelper;
import com.edb.gridsql.optimizer.QueryTree;
import com.edb.gridsql.optimizer.RelationNode;
import com.edb.gridsql.optimizer.SqlExpression;
import com.edb.gridsql.parser.Command;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryCondition
implements IRebuildString {
    public static final int QC_COMPOSITE = 2;
    public static final int QC_CONDITION = 8;
    public static final int QC_SQLEXPR = 4;
    public static final int QC_RELOP = 16;
    public static final int QC_COND_COMPOSITE = 10;
    public static final int QC_RELOP_COMPOSITE = 18;
    public static final int QC_ALL = 30;
    private int condType;
    private QueryCondition leftCond;
    private QueryCondition rightCond;
    private String operator;
    private SqlExpression expr;
    private boolean isJoin = false;
    private boolean isAtomic = false;
    private boolean isInPlan = false;
    private String condString = "";
    private List<RelationNode> relationNodeList;
    private List<Integer> nodeIdList;
    private List<AttributeColumn> columnList;
    private CompositeCondition aCompositeClause;
    private boolean anyAllFlag = false;
    private String anyAllString = null;
    private List<SqlExpression> projectedColumns = new ArrayList<SqlExpression>();
    private List<AttributeColumn> correlatedColumns;
    private boolean isPositive = true;
    private QueryCondition parentQueryCondition;
    private QueryTree parentQueryTree;

    public QueryCondition() {
        this.relationNodeList = new ArrayList<RelationNode>();
        this.columnList = new ArrayList<AttributeColumn>();
        this.nodeIdList = new ArrayList<Integer>();
    }

    public void rebuildCondString() {
        this.condString = this.rebuildCondition(this);
    }

    private String rebuildCondition(QueryCondition queryCondition) {
        String string = "";
        String string2 = "";
        String string3 = "";
        if (!queryCondition.isPositive) {
            string3 = " NOT ";
        }
        if (queryCondition.anyAllFlag) {
            string3 = " " + queryCondition.anyAllString;
        }
        if (queryCondition.condType == 2) {
            string3 = string3 + queryCondition.aCompositeClause.rebuildString();
            return string3;
        }
        if (queryCondition.condType == 4) {
            queryCondition.expr.rebuildExpression();
            string3 = queryCondition.expr.getExprType() == 64 ? string3 + "(" + queryCondition.expr.getExprString() + " ) " : string3 + queryCondition.expr.getExprString();
        } else {
            if (queryCondition.getLeftCond() != null) {
                string2 = this.rebuildCondition(queryCondition.getLeftCond());
            }
            if (queryCondition.rightCond != null) {
                string = this.rebuildCondition(queryCondition.rightCond);
                queryCondition.condString = string3 = "(" + string2 + " " + queryCondition.operator + " " + string + ")";
            }
        }
        return string3;
    }

    public static Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
        Vector<QueryCondition> vector = new Vector<QueryCondition>();
        QueryCondition queryCondition2 = queryCondition.rightCond;
        QueryCondition queryCondition3 = queryCondition.getLeftCond();
        if ((queryCondition.condType & n) > 0) {
            vector.add(queryCondition);
        }
        if ((queryCondition.condType & 2) > 0) {
            vector.addAll(queryCondition.aCompositeClause.getNodes(queryCondition, n));
            return vector;
        }
        if (queryCondition2 != null) {
            vector.addAll(QueryCondition.getNodes(queryCondition2, n));
        }
        if (queryCondition3 != null) {
            vector.addAll(QueryCondition.getNodes(queryCondition3, n));
        }
        return vector;
    }

    @Override
    public String rebuildString() {
        this.rebuildCondString();
        return this.condString;
    }

    public void setParent(QueryCondition queryCondition) {
        this.parentQueryCondition = queryCondition;
        if (this.condType == 2) {
            this.aCompositeClause.setParent(this);
        }
        if (this.rightCond != null) {
            this.rightCond.setParent(this);
        }
        if (this.getLeftCond() != null) {
            this.getLeftCond().setParent(this);
        }
    }

    public RelationNode getPseudoRelationNode(AttributeColumn attributeColumn) throws ColumnNotFoundException {
        QueryCondition queryCondition = this.findCondition(attributeColumn);
        if (queryCondition == null) {
            throw new ColumnNotFoundException(attributeColumn.columnAlias, attributeColumn.getTableAlias());
        }
        return queryCondition.parentQueryTree.getPseudoRelationNode();
    }

    private QueryCondition findCondition(AttributeColumn attributeColumn) {
        Object object;
        if (this.rightCond != null && (object = this.rightCond.findCondition(attributeColumn)) != null) {
            return object;
        }
        if (this.getLeftCond() != null && (object = this.getLeftCond().findCondition(attributeColumn)) != null) {
            return object;
        }
        for (QueryCondition queryCondition : QueryCondition.getNodes(this, 4)) {
            Object object2;
            SqlExpression sqlExpression = queryCondition.expr;
            if (sqlExpression.getExprType() == 64 && (object2 = sqlExpression.getSubqueryTree().getWhereRootCondition().findCondition(attributeColumn)) != null) {
                return object2;
            }
            if (sqlExpression.getExprType() == 4 && attributeColumn == sqlExpression.getColumn()) {
                return this;
            }
            if (sqlExpression.getExprType() == 32) {
                object2 = sqlExpression.getFunctionParams().iterator();
                while (object2.hasNext()) {
                    SqlExpression sqlExpression2 = (SqlExpression)object2.next();
                    if (sqlExpression2.getColumn() != attributeColumn) continue;
                    return this;
                }
                if (attributeColumn == sqlExpression.getColumn()) {
                    return this;
                }
            }
            if (sqlExpression.getLeftExpr() != null && sqlExpression.getLeftExpr().containsColumn(attributeColumn)) {
                return this;
            }
            if (sqlExpression.getRightExpr() == null || !sqlExpression.getRightExpr().containsColumn(attributeColumn)) continue;
            return this;
        }
        return null;
    }

    public QueryCondition(SqlExpression sqlExpression, SqlExpression sqlExpression2, String string) {
        QueryCondition queryCondition = this.buildQCFromExpression(sqlExpression);
        QueryCondition queryCondition2 = this.buildQCFromExpression(sqlExpression2);
        this.operator = string;
        this.rightCond = queryCondition;
        this.setLeftCond(queryCondition2);
        this.condType = 8;
    }

    public void setPositive(boolean bl) {
        if (this.getLeftCond() == null) {
            this.isPositive = bl;
        } else {
            this.leftCond.setPositive(bl);
        }
    }

    protected QueryCondition buildQCFromExpression(SqlExpression sqlExpression) {
        QueryCondition queryCondition = new QueryCondition();
        queryCondition.condType = 4;
        sqlExpression.rebuildExpression();
        queryCondition.condString = sqlExpression.getExprString();
        queryCondition.expr = sqlExpression;
        return queryCondition;
    }

    public String toString() {
        return this.condString;
    }

    public boolean containsSqlExpression(SqlExpression sqlExpression) {
        boolean bl = false;
        if (this.condType == 4) {
            return this.expr.contains(sqlExpression);
        }
        if (this.getLeftCond() != null) {
            bl = this.getLeftCond().containsSqlExpression(sqlExpression);
        }
        if (!bl && this.rightCond != null) {
            return this.rightCond.containsSqlExpression(sqlExpression);
        }
        return bl;
    }

    public SqlExpression getSqlExpressionExclusiveFromTable(String string) {
        if (this.condType != 4) {
            return null;
        }
        if (this.expr.containsColumnsExclusiveFromTable(string)) {
            return this.expr;
        }
        return null;
    }

    public boolean isSimple() {
        if (this.condType == 8) {
            return !(this.getLeftCond() != null && !this.getLeftCond().isSimple() || this.rightCond != null && !this.rightCond.isSimple());
        }
        if (this.condType == 16) {
            if (this.getLeftCond() != null && this.getLeftCond().expr != null && this.getLeftCond().expr.hasSubQuery()) {
                return false;
            }
            if (this.rightCond != null && this.rightCond.expr != null && this.rightCond.expr.hasSubQuery()) {
                return false;
            }
        } else {
            if (this.condType == 4) {
                return !this.expr.hasSubQuery();
            }
            if (this.condType == 2) {
                Object object;
                if (this.aCompositeClause.compareExpressionQueryCondition != null && !this.aCompositeClause.compareExpressionQueryCondition.isSimple()) {
                    return false;
                }
                if (this.aCompositeClause.expressionConditionList != null) {
                    for (QueryCondition queryCondition : this.aCompositeClause.expressionConditionList) {
                        if (queryCondition.isSimple()) continue;
                        return false;
                    }
                }
                if (this.aCompositeClause instanceof CompositeTreeCondition) {
                    object = (CompositeTreeCondition)this.aCompositeClause;
                    if (((CompositeTreeCondition)object).subTreeExpressionCondition != null && !((CompositeTreeCondition)object).subTreeExpressionCondition.isSimple()) {
                        return false;
                    }
                } else if (this.aCompositeClause instanceof BetweenClause) {
                    object = (BetweenClause)this.aCompositeClause;
                    if (((BetweenClause)object).startValueQueryCondition != null && !((BetweenClause)object).startValueQueryCondition.isSimple()) {
                        return false;
                    }
                    if (((BetweenClause)object).endValueQueryCondition != null && !((BetweenClause)object).endValueQueryCondition.isSimple()) {
                        return false;
                    }
                } else if (this.aCompositeClause instanceof CLikeClause) {
                    object = (CLikeClause)this.aCompositeClause;
                    if (((CLikeClause)object).compToExpression != null && !((CLikeClause)object).compToExpression.isSimple()) {
                        return false;
                    }
                    if (((CLikeClause)object).escapeExpression != null && ((CLikeClause)object).escapeExpression.hasSubQuery()) {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isSimpleTableJoin() {
        return this.getLeftCond() != null && this.getLeftCond().condType == 4 && this.getLeftCond().expr.getExprType() == 4 && this.rightCond != null && this.rightCond.condType == 4 && this.rightCond.expr.getExprType() == 4;
    }

    public boolean isTwoRelationJoin() {
        return this.isJoin() && this.getRelationNodeList().size() == 2 && this.getCondType() == 16;
    }

    public static void equateConditionsWithColumns(List<QueryCondition> list, List<AttributeColumn> list2) {
        for (QueryCondition queryCondition : list) {
            for (QueryCondition queryCondition2 : QueryCondition.getNodes(queryCondition, 4)) {
                queryCondition2.expr.replaceColumnInExpression(list2);
            }
        }
    }

    public Collection<QueryCondition> getAndedConditions() {
        Vector<QueryCondition> vector = new Vector<QueryCondition>();
        if (this.condType != 8) {
            vector.add(this);
        } else if (this.operator == "AND") {
            vector.addAll(this.getLeftCond().getAndedConditions());
            this.getLeftCond().setRelationNodes();
            this.getLeftCond().isJoin = true;
            vector.addAll(this.rightCond.getAndedConditions());
            this.rightCond.setRelationNodes();
            this.rightCond.isJoin = true;
        } else {
            vector.add(this);
        }
        return vector;
    }

    private void setRelationNodes() {
        for (QueryCondition queryCondition : QueryCondition.getNodes(this, 4)) {
            for (SqlExpression sqlExpression : queryCondition.expr.getNodes(queryCondition.expr, 4)) {
                AttributeColumn attributeColumn = sqlExpression.getColumn();
                if (this.relationNodeList.contains(attributeColumn.relationNode)) continue;
                this.relationNodeList.add(attributeColumn.relationNode);
            }
        }
    }

    public Collection<DBNode> getPartitionedNode(XDBSessionContext xDBSessionContext) {
        QueryCondition queryCondition;
        QueryCondition queryCondition2;
        if (this.isJoin) {
            return null;
        }
        if (this.condType == 8 && this.operator == "AND") {
            Collection<DBNode> collection;
            if (this.getLeftCond() != null && (collection = this.getLeftCond().getPartitionedNode(xDBSessionContext)) != null) {
                return collection;
            }
            if (this.rightCond != null && (collection = this.rightCond.getPartitionedNode(xDBSessionContext)) != null) {
                return collection;
            }
            return null;
        }
        if (this.relationNodeList.size() != 1 || this.condType != 16 || this.operator != "=") {
            return null;
        }
        if (this.getLeftCond() != null && this.getLeftCond().condType == 4 && this.getLeftCond().expr.getExprType() == 4 && this.getLeftCond().expr.getMappedExpression() == null) {
            queryCondition2 = this.getLeftCond();
            queryCondition = this.rightCond;
        } else if (this.rightCond != null && this.rightCond.condType == 4 && this.rightCond.expr.getExprType() == 4 && this.rightCond.expr.getMappedExpression() == null) {
            queryCondition2 = this.rightCond;
            queryCondition = this.getLeftCond();
        } else {
            return null;
        }
        AttributeColumn attributeColumn = queryCondition2.expr.getColumn();
        SysTable sysTable = attributeColumn.getSysTable(xDBSessionContext.getSysDatabase());
        if (attributeColumn.columnName.equalsIgnoreCase(sysTable.getPartitionColumn()) && queryCondition.condType == 4 && queryCondition.expr.getExprType() == 2) {
            if (queryCondition2.expr.getExprDataType() == null) {
                queryCondition2.expr.setExprDataType(queryCondition2.expr.getColumn().getColumnType(xDBSessionContext.getSysDatabase()));
            }
            queryCondition.expr.setExprDataType(queryCondition2.expr.getExprDataType());
            Collection<DBNode> collection = sysTable.getNode(queryCondition.expr.getNormalizedValue());
            return collection == null || collection.size() == 0 ? null : collection;
        }
        return null;
    }

    public SqlExpression getPartitionParameterExpression(SysDatabase sysDatabase) {
        QueryCondition queryCondition;
        QueryCondition queryCondition2;
        if (this.isJoin) {
            return null;
        }
        if (this.condType == 8 && this.operator == "AND") {
            SqlExpression sqlExpression;
            if (this.getLeftCond() != null && (sqlExpression = this.getLeftCond().getPartitionParameterExpression(sysDatabase)) != null) {
                return sqlExpression;
            }
            if (this.rightCond != null && (sqlExpression = this.rightCond.getPartitionParameterExpression(sysDatabase)) != null) {
                return sqlExpression;
            }
            return null;
        }
        if (this.relationNodeList.size() != 1 || this.condType != 16 || this.operator != "=") {
            return null;
        }
        if (this.getLeftCond() != null && this.getLeftCond().condType == 4 && this.getLeftCond().expr.getExprType() == 4 && this.getLeftCond().expr.getMappedExpression() == null) {
            queryCondition2 = this.getLeftCond();
            queryCondition = this.rightCond;
        } else if (this.rightCond != null && this.rightCond.condType == 4 && this.rightCond.expr.getExprType() == 4 && this.rightCond.expr.getMappedExpression() == null) {
            queryCondition2 = this.rightCond;
            queryCondition = this.getLeftCond();
        } else {
            return null;
        }
        if (queryCondition.condType == 4 && queryCondition.expr.getExprType() != 1024) {
            return null;
        }
        AttributeColumn attributeColumn = queryCondition2.expr.getColumn();
        SysTable sysTable = attributeColumn.getSysTable(sysDatabase);
        if (attributeColumn.columnName.equalsIgnoreCase(sysTable.getPartitionColumn())) {
            queryCondition2.expr.setParamNumber(queryCondition.expr.getParamNumber());
            return queryCondition2.expr;
        }
        return null;
    }

    public void setACompositeClause(CompositeCondition compositeCondition) {
        this.aCompositeClause = compositeCondition;
    }

    public CompositeCondition getACompositeClause() {
        return this.aCompositeClause;
    }

    public void setAnyAllFlag(boolean bl) {
        this.anyAllFlag = bl;
    }

    public boolean isAnyAllFlag() {
        return this.anyAllFlag;
    }

    public void setAnyAllString(String string) {
        this.anyAllString = string;
    }

    public String getAnyAllString() {
        return this.anyAllString;
    }

    public void setColumnList(List<AttributeColumn> list) {
        this.columnList = list;
    }

    public List<AttributeColumn> getColumnList() {
        return this.columnList;
    }

    public void setCondString(String string) {
        this.condString = string;
    }

    public String getCondString() {
        return this.condString;
    }

    public void setCondType(int n) {
        this.condType = n;
    }

    public int getCondType() {
        return this.condType;
    }

    public void setCorrelatedColumns(List<AttributeColumn> list) {
        this.correlatedColumns = list;
    }

    public List<AttributeColumn> getCorrelatedColumns() {
        if (this.correlatedColumns == null) {
            this.correlatedColumns = new ArrayList<AttributeColumn>();
        }
        return this.correlatedColumns;
    }

    public void setExpr(SqlExpression sqlExpression) {
        this.expr = sqlExpression;
    }

    public SqlExpression getExpr() {
        return this.expr;
    }

    public void setAtomic(boolean bl) {
        this.isAtomic = bl;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public void setInPlan(boolean bl) {
        this.isInPlan = bl;
    }

    public boolean isInPlan() {
        return this.isInPlan;
    }

    public void setJoin(boolean bl) {
        this.isJoin = bl;
    }

    public boolean isJoin() {
        return this.isJoin;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public void setLeftCond(QueryCondition queryCondition) {
        this.leftCond = queryCondition;
    }

    public QueryCondition getLeftCond() {
        return this.leftCond;
    }

    public void setRightCond(QueryCondition queryCondition) {
        this.rightCond = queryCondition;
    }

    public QueryCondition getRightCond() {
        return this.rightCond;
    }

    public void setNodeIdList(List<Integer> list) {
        this.nodeIdList = list;
    }

    public List<Integer> getNodeIdList() {
        return this.nodeIdList;
    }

    public void setOperator(String string) {
        this.operator = string;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setParentQueryCondition(QueryCondition queryCondition) {
        this.parentQueryCondition = queryCondition;
    }

    public QueryCondition getParentQueryCondition() {
        return this.parentQueryCondition;
    }

    public void setParentQueryTree(QueryTree queryTree) {
        this.parentQueryTree = queryTree;
    }

    public QueryTree getParentQueryTree() {
        return this.parentQueryTree;
    }

    public void setProjectedColumns(List<SqlExpression> list) {
        this.projectedColumns = list;
    }

    public List<SqlExpression> getProjectedColumns() {
        return this.projectedColumns;
    }

    public void setRelationNodeList(List<RelationNode> list) {
        this.relationNodeList = list;
    }

    public List<RelationNode> getRelationNodeList() {
        return this.relationNodeList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CLikeClause
    extends CompositeCondition {
        private String likeString;
        public QueryCondition compToExpression;
        public SqlExpression escapeExpression;

        public CLikeClause(SqlExpression sqlExpression, SqlExpression sqlExpression2, boolean bl, String string, Command command, SqlExpression sqlExpression3) {
            super(command);
            this.escapeExpression = sqlExpression3;
            this.isPositive = bl;
            this.likeString = string;
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            this.compToExpression = QueryCondition.this.buildQCFromExpression(sqlExpression2);
            if (this.compToExpression.getExpr().getExprType() == 64) {
                if (this.compToExpression.getExpr().getSubqueryTree().getOrphanCount() == 0) {
                    this.compToExpression.getExpr().getSubqueryTree().setQueryType(4);
                } else {
                    this.compToExpression.getExpr().getSubqueryTree().setQueryType(2);
                }
                if (command.getCommandToExecute() == 1 && sqlExpression2.getSubqueryTree() != null) {
                    QuerySubTreeHelper querySubTreeHelper = sqlExpression2.getSubqueryTree().processSubTree(sqlExpression2, command.getaQueryTreeTracker());
                    if (querySubTreeHelper.createdRelationNode != null) {
                        QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                    }
                    if (querySubTreeHelper.projectedSqlExpression != null) {
                        QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
                    }
                    if (querySubTreeHelper.correlatedColumnExprList != null) {
                        QueryCondition.this.setCorrelatedColumns(querySubTreeHelper.getCorrelatedColumnAttributed());
                    }
                }
            }
        }

        @Override
        public String rebuildString() {
            this.compareExpressionQueryCondition.rebuildCondString();
            String string = " (";
            string = string + this.compareExpressionQueryCondition.getCondString() + " ";
            if (!this.isPositive) {
                string = string + " NOT";
            }
            string = string + " " + this.likeString + " ";
            this.compToExpression.getExpr().rebuildExpression();
            string = string + this.compToExpression.getExpr().getExprString();
            if (this.escapeExpression != null) {
                string = string + " ESCAPE ";
                string = string + this.escapeExpression.rebuildString();
            }
            string = string + " )";
            return string;
        }

        public void transformToTraditionalTree() {
            QueryCondition.this.setRightCond(this.compareExpressionQueryCondition);
            QueryCondition.this.setLeftCond(this.compToExpression);
            QueryCondition.this.setOperator("LIKE");
        }

        @Override
        public void setParent(QueryCondition queryCondition) {
            this.compareExpressionQueryCondition.setParentQueryCondition(queryCondition);
            this.compToExpression.setParentQueryCondition(queryCondition);
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            vector.addAll(QueryCondition.getNodes(this.compareExpressionQueryCondition, n));
            vector.addAll(QueryCondition.getNodes(this.compToExpression, n));
            return vector;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            SqlExpression sqlExpression3 = this.compareExpressionQueryCondition.getExpr();
            SqlExpression sqlExpression4 = this.compToExpression.getExpr();
            if (this.compareExpressionQueryCondition.getExpr() == sqlExpression) {
                sqlExpression3 = sqlExpression2;
            }
            if (this.compToExpression.getExpr() == sqlExpression) {
                sqlExpression4 = sqlExpression2;
            }
            CLikeClause cLikeClause = new CLikeClause(sqlExpression3, sqlExpression4, this.isPositive, "LIKE", this.commandToExecute, this.escapeExpression);
            return cLikeClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CheckBooleanClause
    extends CompositeCondition {
        boolean value;

        public CheckBooleanClause(SqlExpression sqlExpression, boolean bl, boolean bl2, Command command) {
            super(command);
            this.value = true;
            this.isPositive = bl;
            this.value = bl2;
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            if (this.compareExpressionQueryCondition.getExpr().getExprType() == 64 && command.getCommandToExecute() == 1) {
                QuerySubTreeHelper querySubTreeHelper = this.compareExpressionQueryCondition.getExpr().getSubqueryTree().processSubTree(this.compareExpressionQueryCondition.expr, command.getaQueryTreeTracker());
                if (querySubTreeHelper.createdRelationNode != null) {
                    QueryCondition.this.relationNodeList.add(querySubTreeHelper.createdRelationNode);
                }
                if (querySubTreeHelper.projectedSqlExpression != null) {
                    QueryCondition.this.projectedColumns.addAll(querySubTreeHelper.projectedSqlExpression);
                }
                if (querySubTreeHelper.correlatedColumnExprList != null) {
                    QueryCondition.this.correlatedColumns = querySubTreeHelper.getCorrelatedColumnAttributed();
                }
            }
        }

        @Override
        public void setParent(QueryCondition queryCondition) {
            this.compareExpressionQueryCondition.parentQueryCondition = queryCondition;
        }

        @Override
        public String rebuildString() {
            String string = " (";
            this.compareExpressionQueryCondition.expr.rebuildExpression();
            string = string + this.compareExpressionQueryCondition.getExpr().getExprString();
            string = string + " IS";
            if (!this.isPositive) {
                string = string + " NOT";
            }
            string = string + " " + (this.value ? "TRUE" : "FALSE");
            string = string + " )";
            return string;
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            vector.addAll(QueryCondition.getNodes(this.compareExpressionQueryCondition, n));
            return vector;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            Vector<SqlExpression> vector = new Vector<SqlExpression>();
            SqlExpression sqlExpression3 = this.compareExpressionQueryCondition.expr;
            for (QueryCondition queryCondition : this.expressionConditionList) {
                QueryCondition queryCondition2 = queryCondition;
                if (queryCondition2.expr == sqlExpression) {
                    vector.add(sqlExpression2);
                    continue;
                }
                vector.add(queryCondition2.expr);
            }
            if (this.compareExpressionQueryCondition.expr == sqlExpression) {
                sqlExpression3 = sqlExpression2;
            }
            CheckBooleanClause checkBooleanClause = new CheckBooleanClause(sqlExpression3, this.isPositive, this.value, this.commandToExecute);
            return checkBooleanClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CheckNullClause
    extends CompositeCondition {
        public CheckNullClause(SqlExpression sqlExpression, boolean bl, Command command) {
            super(command);
            this.isPositive = bl;
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            if (this.compareExpressionQueryCondition.getExpr().getExprType() == 64 && command.getCommandToExecute() == 1) {
                QuerySubTreeHelper querySubTreeHelper = this.compareExpressionQueryCondition.getExpr().getSubqueryTree().processSubTree(this.compareExpressionQueryCondition.getExpr(), command.getaQueryTreeTracker());
                if (querySubTreeHelper.createdRelationNode != null) {
                    QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                }
                if (querySubTreeHelper.projectedSqlExpression != null) {
                    QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
                }
                if (querySubTreeHelper.correlatedColumnExprList != null) {
                    QueryCondition.this.setCorrelatedColumns(querySubTreeHelper.getCorrelatedColumnAttributed());
                }
            }
        }

        @Override
        public void setParent(QueryCondition queryCondition) {
            this.compareExpressionQueryCondition.setParentQueryCondition(queryCondition);
        }

        @Override
        public String rebuildString() {
            String string = " (";
            this.compareExpressionQueryCondition.getExpr().rebuildExpression();
            string = string + this.compareExpressionQueryCondition.getExpr().getExprString();
            string = string + " IS";
            if (!this.isPositive) {
                string = string + " NOT";
            }
            string = string + "  NULL";
            string = string + " )";
            return string;
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            vector.addAll(QueryCondition.getNodes(this.compareExpressionQueryCondition, n));
            return vector;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            Vector<SqlExpression> vector = new Vector<SqlExpression>();
            SqlExpression sqlExpression3 = this.compareExpressionQueryCondition.getExpr();
            for (QueryCondition queryCondition : this.expressionConditionList) {
                QueryCondition queryCondition2 = queryCondition;
                if (queryCondition2.getExpr() == sqlExpression) {
                    vector.add(sqlExpression2);
                    continue;
                }
                vector.add(queryCondition2.getExpr());
            }
            if (this.compareExpressionQueryCondition.getExpr() == sqlExpression) {
                sqlExpression3 = sqlExpression2;
            }
            CheckNullClause checkNullClause = new CheckNullClause(sqlExpression3, this.isPositive, this.commandToExecute);
            return checkNullClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BetweenClause
    extends CompositeCondition {
        QueryCondition startValueQueryCondition;
        QueryCondition endValueQueryCondition;
        public static final String BETWEEN_KEYWORD = "BETWEEN";
        public static final String AND_KEYWORD = "AND";
        public static final String NOT_KEYWORD = "NOT";

        @Override
        public void setParent(QueryCondition queryCondition) {
            this.startValueQueryCondition.setParentQueryCondition(queryCondition);
            this.endValueQueryCondition.setParentQueryCondition(queryCondition);
            this.compareExpressionQueryCondition.setParentQueryCondition(queryCondition);
        }

        public BetweenClause(SqlExpression sqlExpression, SqlExpression sqlExpression2, SqlExpression sqlExpression3, boolean bl, Command command) {
            QuerySubTreeHelper querySubTreeHelper;
            super(command);
            this.startValueQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            if (this.startValueQueryCondition.getExpr() != null && this.startValueQueryCondition.getExpr().getExprType() == 64) {
                if (this.startValueQueryCondition.getExpr().getSubqueryTree().getOrphanCount() > 0) {
                    this.startValueQueryCondition.getExpr().getSubqueryTree().setQueryType(2);
                } else {
                    this.startValueQueryCondition.getExpr().getSubqueryTree().setQueryType(4);
                }
                if (command.getCommandToExecute() == 1) {
                    querySubTreeHelper = sqlExpression.getSubqueryTree().processSubTree(sqlExpression, command.getaQueryTreeTracker());
                    if (querySubTreeHelper.createdRelationNode != null) {
                        QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                    }
                    if (querySubTreeHelper.projectedSqlExpression != null) {
                        QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
                    }
                }
            }
            this.endValueQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression2);
            if (this.endValueQueryCondition.getExpr() != null && this.endValueQueryCondition.getExpr().getExprType() == 64) {
                if (this.endValueQueryCondition.getExpr().getSubqueryTree().getOrphanCount() > 0) {
                    this.endValueQueryCondition.getExpr().getSubqueryTree().setQueryType(2);
                } else {
                    this.endValueQueryCondition.getExpr().getSubqueryTree().setQueryType(4);
                }
                if (command.getCommandToExecute() == 1) {
                    querySubTreeHelper = sqlExpression2.getSubqueryTree().processSubTree(sqlExpression2, command.getaQueryTreeTracker());
                    if (querySubTreeHelper.createdRelationNode != null) {
                        QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                    }
                    if (querySubTreeHelper.projectedSqlExpression != null) {
                        QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
                    }
                }
            }
            this.isPositive = bl;
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression3);
            if (this.compareExpressionQueryCondition.getExpr() != null && this.compareExpressionQueryCondition.getExpr().getExprType() == 64) {
                if (this.compareExpressionQueryCondition.getExpr().getSubqueryTree().getOrphanCount() > 0) {
                    this.compareExpressionQueryCondition.getExpr().getSubqueryTree().setQueryType(2);
                } else {
                    this.compareExpressionQueryCondition.getExpr().getSubqueryTree().setQueryType(4);
                }
                querySubTreeHelper = sqlExpression3.getSubqueryTree().processSubTree(sqlExpression, command.getaQueryTreeTracker());
                if (querySubTreeHelper.createdRelationNode != null) {
                    QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
                }
                if (querySubTreeHelper.projectedSqlExpression != null) {
                    QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
                }
            }
            this.condString = this.rebuildString();
            this.transformToTraditionalTree();
        }

        @Override
        public String rebuildString() {
            this.condString = "";
            this.compareExpressionQueryCondition.getExpr().rebuildExpression();
            this.condString = this.condString + this.condString + this.compareExpressionQueryCondition.getExpr().getExprString();
            if (!this.isPositive) {
                this.condString = this.condString + " NOT  ";
            }
            this.condString = this.condString + " BETWEEN ";
            this.startValueQueryCondition.getExpr().rebuildExpression();
            this.condString = this.condString + this.startValueQueryCondition.getExpr().getExprString() + " ";
            this.condString = this.condString + "AND ";
            this.endValueQueryCondition.getExpr().rebuildExpression();
            this.condString = this.condString + this.endValueQueryCondition.getExpr().getExprString();
            return this.condString;
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            Vector<QueryCondition> vector2 = QueryCondition.getNodes(this.compareExpressionQueryCondition, n);
            vector.addAll(vector2);
            vector2 = QueryCondition.getNodes(this.startValueQueryCondition, n);
            vector.addAll(vector2);
            vector2 = QueryCondition.getNodes(this.endValueQueryCondition, n);
            vector.addAll(vector2);
            return vector;
        }

        private void transformToTraditionalTree() {
            QueryCondition.this.setOperator(BETWEEN_KEYWORD);
            QueryCondition.this.setLeftCond(this.compareExpressionQueryCondition);
            QueryCondition.this.setRightCond(this.endValueQueryCondition);
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            SqlExpression sqlExpression3 = this.startValueQueryCondition.getExpr();
            SqlExpression sqlExpression4 = this.endValueQueryCondition.getExpr();
            SqlExpression sqlExpression5 = this.compareExpressionQueryCondition.getExpr();
            if (this.startValueQueryCondition.getExpr() == sqlExpression) {
                sqlExpression3 = sqlExpression2;
            }
            if (this.endValueQueryCondition.getExpr() == sqlExpression) {
                sqlExpression4 = sqlExpression2;
            }
            if (this.compareExpressionQueryCondition.getExpr() == sqlExpression) {
                sqlExpression5 = sqlExpression2;
            }
            BetweenClause betweenClause = new BetweenClause(sqlExpression3, sqlExpression4, sqlExpression5, this.isPositive, this.commandToExecute);
            return betweenClause;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExistClause
    extends CompositeTreeCondition {
        public ExistClause(QueryTree queryTree, boolean bl, Command command) {
            super(command);
            SqlExpression sqlExpression = new SqlExpression(queryTree);
            this.subTreeExpressionCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            this.isPositive = bl;
            queryTree.setQueryType(24);
            this.processSubtree(queryTree, bl);
            this.transformToTraditionalTree();
        }

        private void transformToTraditionalTree() {
            QueryCondition.this.setRightCond(this.subTreeExpressionCondition);
            QueryCondition.this.setOperator("EXISTS");
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            vector.addAll(QueryCondition.getNodes(this.subTreeExpressionCondition, n));
            return vector;
        }

        @Override
        public String rebuildString() {
            this.condString = "";
            if (!this.isPositive) {
                this.condString = this.condString + " NOT";
            }
            this.condString = this.condString + " EXISTS ";
            this.subTreeExpressionCondition.getExpr().rebuildString();
            String string = this.subTreeExpressionCondition.getExpr().getExprString();
            this.condString = string.trim().startsWith("(") ? this.condString + string + " " : this.condString + "(" + string + ") ";
            return this.condString;
        }

        @Override
        public void setParent(QueryCondition queryCondition) {
            this.subTreeExpressionCondition.setParentQueryCondition(queryCondition);
        }

        @Override
        public boolean leadsToJoinCondition() {
            return this.subTreeExpressionCondition.getExpr().getSubqueryTree().getOrphanCount() > 0;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InClauseTree
    extends CompositeTreeCondition {
        public InClauseTree(QueryTree queryTree, SqlExpression sqlExpression, boolean bl, Command command) {
            super(command);
            this.processSubtree(queryTree, sqlExpression, bl);
            this.transformToTraditionalTree();
        }

        private void transformToTraditionalTree() {
            QueryCondition.this.setOperator("IN");
            QueryCondition.this.setLeftCond(this.compareExpressionQueryCondition);
            QueryCondition.this.setRightCond(this.subTreeExpressionCondition);
        }

        @Override
        public String rebuildString() {
            String string = "";
            this.compareExpressionQueryCondition.rebuildCondString();
            if (!this.isPositive) {
                string = string + " NOT ";
            }
            string = string + this.compareExpressionQueryCondition.getCondString() + " IN ";
            this.subTreeExpressionCondition.getExpr().rebuildString();
            String string2 = this.subTreeExpressionCondition.getExpr().getExprString();
            string = string2.trim().startsWith("(") ? string + string2 + " " : string + "(" + string2 + ") ";
            return string;
        }

        public Vector<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            vector.addAll(QueryCondition.getNodes(this.compareExpressionQueryCondition, n));
            vector.addAll(QueryCondition.getNodes(this.subTreeExpressionCondition, n));
            return vector;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            return this;
        }
    }

    abstract class CompositeTreeCondition
    extends CompositeCondition {
        QueryCondition subTreeExpressionCondition;

        public CompositeTreeCondition(Command command) {
            super(command);
        }

        protected void processSubtree(QueryTree queryTree, SqlExpression sqlExpression, boolean bl) {
            this.processSubtree(queryTree, bl);
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
        }

        public void processSubtree(QueryTree queryTree, boolean bl) {
            SqlExpression sqlExpression = new SqlExpression(queryTree);
            this.subTreeExpressionCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            this.isPositive = bl;
            queryTree.setQueryType(24);
            QuerySubTreeHelper querySubTreeHelper = queryTree.processSubTree(sqlExpression, this.commandToExecute.getaQueryTreeTracker());
            if (querySubTreeHelper.projectedSqlExpression != null) {
                QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
            }
            if (querySubTreeHelper.correlatedColumnExprList != null) {
                QueryCondition.this.setCorrelatedColumns(querySubTreeHelper.getCorrelatedColumnAttributed());
            }
        }

        public boolean leadsToJoinCondition() {
            return this.subTreeExpressionCondition.getExpr().getSubqueryTree() != null;
        }

        public void extractQueryTreeInformation(QuerySubTreeHelper querySubTreeHelper) {
            if (querySubTreeHelper.createdRelationNode != null) {
                QueryCondition.this.getRelationNodeList().add(querySubTreeHelper.createdRelationNode);
            }
            if (querySubTreeHelper.projectedSqlExpression != null) {
                QueryCondition.this.getProjectedColumns().addAll(querySubTreeHelper.projectedSqlExpression);
            }
            if (querySubTreeHelper.correlatedColumnExprList != null) {
                QueryCondition.this.setCorrelatedColumns(querySubTreeHelper.getCorrelatedColumnAttributed());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class InClauseList
    extends CompositeCondition {
        public InClauseList(List<SqlExpression> list, SqlExpression sqlExpression, boolean bl, Command command) {
            super(command);
            this.isPositive = bl;
            sqlExpression.rebuildExpression();
            this.compareExpressionQueryCondition = QueryCondition.this.buildQCFromExpression(sqlExpression);
            for (SqlExpression sqlExpression2 : list) {
                QueryCondition queryCondition2 = QueryCondition.this.buildQCFromExpression(sqlExpression2);
                this.expressionConditionList.add(queryCondition2);
            }
        }

        @Override
        public String rebuildString() {
            this.compareExpressionQueryCondition.getExpr().rebuildString();
            String string = this.compareExpressionQueryCondition.getExpr().getExprString() + " IN  ( ";
            boolean bl = true;
            for (QueryCondition queryCondition : this.expressionConditionList) {
                queryCondition.rebuildCondString();
                if (bl) {
                    string = string + queryCondition.getCondString();
                    bl = false;
                    continue;
                }
                string = string + " , " + queryCondition.getCondString() + " ";
            }
            return string + " )";
        }

        @Override
        public List<QueryCondition> getNodes(QueryCondition queryCondition, int n) {
            Vector<QueryCondition> vector = new Vector<QueryCondition>();
            for (QueryCondition queryCondition2 : this.expressionConditionList) {
                vector.addAll(QueryCondition.getNodes(queryCondition2, n));
            }
            vector.addAll(QueryCondition.getNodes(this.compareExpressionQueryCondition, n));
            return vector;
        }

        @Override
        public CompositeCondition changeExpression(SqlExpression sqlExpression, SqlExpression sqlExpression2) {
            Vector<SqlExpression> vector = new Vector<SqlExpression>();
            SqlExpression sqlExpression3 = this.compareExpressionQueryCondition.getExpr();
            for (QueryCondition queryCondition : this.expressionConditionList) {
                if (queryCondition.getExpr() == sqlExpression) {
                    vector.add(sqlExpression2);
                    continue;
                }
                vector.add(queryCondition.getExpr());
            }
            if (this.compareExpressionQueryCondition.getExpr() == sqlExpression) {
                sqlExpression3 = sqlExpression2;
            }
            InClauseList inClauseList = new InClauseList(vector, sqlExpression3, this.isPositive, this.commandToExecute);
            return inClauseList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CompositeCondition
    implements IRebuildString {
        Command commandToExecute;
        boolean isPositive = true;
        String condString;
        QueryCondition compareExpressionQueryCondition;
        List<QueryCondition> expressionConditionList = new Vector<QueryCondition>();

        public CompositeCondition(Command command) {
            this.commandToExecute = command;
            QueryCondition.this.setCondType(2);
        }

        public void setParent(QueryCondition queryCondition) {
        }

        @Override
        public abstract String rebuildString();

        public abstract List<QueryCondition> getNodes(QueryCondition var1, int var2);

        public List<QueryCondition> getExpressionConditionList() {
            return this.expressionConditionList;
        }

        public QueryCondition getCompareExpressionQueryCondition() {
            return this.compareExpressionQueryCondition;
        }

        public boolean leadsToJoinCondition() {
            return false;
        }

        public abstract CompositeCondition changeExpression(SqlExpression var1, SqlExpression var2);
    }
}

