/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.metadata.scheduler.ILockCost;

public class RequestCost
implements Comparable {
    private static final XLogger logger = XLogger.getLogger(RequestCost.class);
    private static long ORDER_NUMBER = 0L;
    private long orderNumber;
    private long static_cost = 0L;
    private long timeInMilliSeconds = 0L;
    private ILockCost sqlObject;

    public RequestCost(ILockCost iLockCost) {
        this.sqlObject = iLockCost;
        if (iLockCost != null) {
            this.static_cost = iLockCost.getCost();
        }
        this.timeInMilliSeconds = System.currentTimeMillis();
        this.orderNumber = ORDER_NUMBER++;
    }

    public ILockCost getSqlObject() {
        return this.sqlObject;
    }

    public long getDynamicCost() {
        return 0L;
    }

    public long getTimeInQueue() {
        long l = System.currentTimeMillis() - this.timeInMilliSeconds;
        return l;
    }

    public long setTotalCost() {
        return this.sqlObject == null ? 0L : this.static_cost + this.getDynamicCost() - this.getTimeInQueue();
    }

    public boolean isLarge() {
        return this.static_cost > Props.XDB_LARGE_QUERY_COST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int compareTo(Object object) {
        RequestCost requestCost;
        block7: {
            long l;
            block6: {
                block5: {
                    if (object != this) break block5;
                    int n = 0;
                    return n;
                }
                requestCost = (RequestCost)object;
                l = this.static_cost + this.timeInMilliSeconds - requestCost.static_cost - requestCost.timeInMilliSeconds;
                if (l <= 0L) break block6;
                int n = 1;
                return n;
            }
            if (l >= 0L) break block7;
            int n = -1;
            return n;
        }
        int n = this.orderNumber < requestCost.orderNumber ? 1 : -1;
        return n;
    }
}

