/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata.scheduler;

import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.metadata.scheduler.ITransaction;
import com.edb.gridsql.metadata.scheduler.Lock;
import com.edb.gridsql.metadata.scheduler.LockSpecification;
import com.edb.gridsql.metadata.scheduler.LockTable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockManager {
    private LockTable<ITransaction, SysTable> transactionLocks = new LockTable();
    private LockTable<ITransaction, SysTable> lockCandidates = new LockTable();
    private HashSet<ITransaction> workingTrans = new HashSet();
    private HashMap<ITransaction, CommitSynchronizer> committingInserts = new HashMap();

    public boolean add(Object object, Object object2) {
        return true;
    }

    public boolean remove(Object object, Object object2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getLock(LockSpecification<SysTable> lockSpecification, ITransaction iTransaction) throws XDBServerException {
        boolean bl;
        LockTable<ITransaction, SysTable> lockTable = this.transactionLocks;
        synchronized (lockTable) {
            this.lockCandidates.removeLocks(iTransaction);
            bl = this.transactionLocks.checkLocks(iTransaction, lockSpecification.getCombinedVector());
            if (bl) {
                for (CommitSynchronizer commitSynchronizer : this.committingInserts.values()) {
                    for (Lock<SysTable> lock : lockSpecification.getCombinedVector()) {
                        if (!lock.forRead() || !commitSynchronizer.hasTable(lock.getManagedObject())) continue;
                        return false;
                    }
                }
                this.workingTrans.add(iTransaction);
                this.transactionLocks.addLocks(iTransaction, lockSpecification.getCombinedVector());
            } else {
                this.lockCandidates.addLocks(iTransaction, lockSpecification.getCombinedVector());
                Collection<ITransaction> collection = this.findDeadLocks();
                if (!collection.isEmpty()) {
                    this.notifyTransactionEnd(iTransaction);
                    throw new XDBServerException("Can not complete request due to concurrent problem");
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(ITransaction iTransaction) {
        LockTable<ITransaction, SysTable> lockTable = this.transactionLocks;
        synchronized (lockTable) {
            this.workingTrans.remove(iTransaction);
            for (CommitSynchronizer commitSynchronizer : this.committingInserts.values()) {
                if (!commitSynchronizer.hasTransaction(iTransaction)) continue;
                commitSynchronizer.countDown();
            }
            if (!iTransaction.isInTransaction() && !iTransaction.isInSubTransaction()) {
                this.transactionLocks.removeLocks(iTransaction);
            }
        }
        return true;
    }

    public void notifyRefusedRequest(ITransaction iTransaction) {
        this.lockCandidates.removeLocks(iTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeCommit(ITransaction iTransaction) {
        this.releaseLock(iTransaction);
        CommitSynchronizer commitSynchronizer = null;
        HashSet<SysTable> hashSet = new HashSet<SysTable>();
        HashSet<ITransaction> hashSet2 = new HashSet<ITransaction>();
        LockTable<ITransaction, SysTable> lockTable = this.transactionLocks;
        synchronized (lockTable) {
            HashMap<SysTable, Lock<SysTable>> hashMap = this.transactionLocks.getLocksByTransaction(iTransaction);
            if (hashMap == null) {
                return;
            }
            for (Map.Entry<SysTable, Lock<SysTable>> entry : hashMap.entrySet()) {
                if (!entry.getValue().forWrite()) continue;
                HashMap<ITransaction, Lock<SysTable>> hashMap2 = this.transactionLocks.getLocksByManagedObject(entry.getKey());
                for (Map.Entry<ITransaction, Lock<SysTable>> entry2 : hashMap2.entrySet()) {
                    if (entry2.getKey() == iTransaction || !this.workingTrans.contains(entry2.getKey()) || !entry2.getValue().forRead()) continue;
                    hashSet.add(entry.getKey());
                    hashSet2.add(entry2.getKey());
                }
            }
            if (!hashSet2.isEmpty()) {
                commitSynchronizer = new CommitSynchronizer(hashSet2, hashSet);
                this.committingInserts.put(iTransaction, commitSynchronizer);
            }
        }
        if (commitSynchronizer != null) {
            commitSynchronizer.await();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyTransactionEnd(ITransaction iTransaction) {
        LockTable<ITransaction, SysTable> lockTable = this.transactionLocks;
        synchronized (lockTable) {
            this.committingInserts.remove(iTransaction);
            this.transactionLocks.removeLocks(iTransaction);
            this.lockCandidates.removeLocks(iTransaction);
            this.transactionLocks.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<ITransaction> findDeadLocks() {
        boolean bl;
        LockTable lockTable;
        LockTable lockTable2;
        Iterator iterator = this.transactionLocks;
        synchronized (iterator) {
            Object object = this.lockCandidates;
            synchronized (object) {
                lockTable2 = (LockTable)this.transactionLocks.clone();
                lockTable = (LockTable)this.lockCandidates.clone();
            }
        }
        do {
            bl = false;
            for (Object object : lockTable2.getTransactions()) {
                if (lockTable.getLocksByTransaction(object) != null) continue;
                lockTable2.removeLocks(object);
                bl = true;
            }
            if (!bl) continue;
            for (Object object : lockTable.getTransactions()) {
                if (!lockTable2.checkLocks(object, lockTable.getLocksByTransaction(object).values())) continue;
                lockTable.removeLocks(object);
                bl = true;
            }
        } while (bl);
        return lockTable2.getTransactions();
    }

    public String dumpLockManager() {
        return "Current locks: " + this.transactionLocks + "\n" + "Lock candidates: " + this.lockCandidates + "\n" + "Wait for commit: " + this.committingInserts.keySet() + "\n" + "Busy: " + this.workingTrans + "\n";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommitSynchronizer {
        CountDownLatch aLatch;
        HashSet<SysTable> tables;
        HashSet<ITransaction> transactions;

        CommitSynchronizer(HashSet<ITransaction> hashSet, HashSet<SysTable> hashSet2) {
            this.transactions = hashSet;
            this.tables = hashSet2;
            this.aLatch = new CountDownLatch(hashSet.size());
        }

        boolean hasTable(SysTable sysTable) {
            return this.tables.contains(sysTable);
        }

        boolean hasTransaction(ITransaction iTransaction) {
            return this.transactions.contains(iTransaction);
        }

        void countDown() {
            this.aLatch.countDown();
        }

        void await() {
            try {
                this.aLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

