/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.metadata;

import com.edb.gridsql.exception.XDBGeneratorException;

public abstract class SysSerialGenerator {
    private boolean valid = false;
    private long nextValue;
    private long maxValue = Long.MAX_VALUE;

    public SysSerialGenerator() {
    }

    public SysSerialGenerator(long l) {
        this.setMaxValue(l);
    }

    protected void setMaxValue(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Max value must be positive");
        }
        this.maxValue = l;
    }

    protected long getMaxValue() {
        return this.maxValue;
    }

    public long allocateValue() throws XDBGeneratorException {
        return this.allocateRange(1L);
    }

    public synchronized long allocateRange(long l) throws XDBGeneratorException {
        long l2;
        if (l < 0L) {
            throw new IllegalArgumentException("Range length must not be negative");
        }
        if (!this.valid) {
            this.update();
        }
        if (this.maxValue - l < (l2 = this.nextValue)) {
            throw new XDBGeneratorException(this.getOverflowMessage());
        }
        this.nextValue += l;
        return l2;
    }

    public synchronized void update(long l) {
        if (this.valid) {
            if (l > this.nextValue) {
                this.nextValue = l;
            }
        } else {
            this.valid = true;
            this.nextValue = l;
        }
    }

    public synchronized void invalidate() {
        this.valid = false;
    }

    protected abstract void update() throws XDBGeneratorException;

    protected String getOverflowMessage() {
        return "Generator overflow";
    }
}

