/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.loader;

import com.edb.gridsql.common.util.ParseCmdLine;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.StreamGobbler;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.loader.INodeWriter;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWriter
implements INodeWriter {
    private static final XLogger logger = XLogger.getLogger(DefaultWriter.class);
    private String writerID;
    private String command;
    private OutputStream writer;
    private Process loader;
    private long rowCount = 0L;
    private volatile boolean terminated = false;
    private String header;
    private String footer;
    private int totalChunks = 0;
    private long totalRows = 0L;

    public DefaultWriter(NodeDBConnectionInfo nodeDBConnectionInfo, String string, Map<String, String> map) {
        this.writerID = nodeDBConnectionInfo.getDbName() + "@" + nodeDBConnectionInfo.getDbHost();
        map.put("dbhost", nodeDBConnectionInfo.getDbHost());
        if (nodeDBConnectionInfo.getDbPort() > 0) {
            map.put("dbport", "" + nodeDBConnectionInfo.getDbPort());
        }
        map.put("database", nodeDBConnectionInfo.getDbName());
        map.put("dbusername", nodeDBConnectionInfo.getDbUser());
        map.put("dbpassword", nodeDBConnectionInfo.getDbPassword());
        map.put("psql-util-name", Props.XDB_PSQL_UTIL_NAME);
        this.command = ParseCmdLine.substitute(string, map);
        this.header = map.get("outHeader");
        this.footer = map.get("outFooter");
    }

    @Override
    public void start() throws IOException {
        this.rowCount = 0L;
        this.loader = Runtime.getRuntime().exec(this.parseCommand(this.command));
        this.writer = new BufferedOutputStream(this.loader.getOutputStream(), 65536);
        StreamGobbler streamGobbler = new StreamGobbler(this.loader.getInputStream(), logger, Level.DEBUG);
        StreamGobbler streamGobbler2 = new StreamGobbler(this.loader.getErrorStream(), logger, Level.ERROR);
        streamGobbler.start();
        streamGobbler2.start();
        this.terminated = false;
        if (this.header != null) {
            this.writeRow(this.header.getBytes());
        }
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public synchronized void finish(boolean bl) throws IOException {
        if (this.writer == null) {
            throw new IOException(this.writerID + ": loader is not initialized");
        }
        try {
            if (bl) {
                if (this.footer != null) {
                    this.writeRow(this.footer.getBytes());
                }
                this.writer.flush();
            }
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.terminated = true;
        try {
            ForceKill forceKill = new ForceKill(this.loader, Props.XDB_STEP_ENDWAITTIME);
            int n = this.loader.waitFor();
            if (forceKill.wasRunning()) {
                throw new IOException(this.writerID + ": loader was terminated due to network error");
            }
            if (bl && n != 0) {
                throw new IOException(this.writerID + ": loader error occurred, exit code " + n);
            }
            if (n == 0 && this.rowCount > 0L) {
                ++this.totalChunks;
                this.totalRows += this.rowCount;
                logger.log(Level.DEBUG, "%0%: chunk completed, %1% rows are output", new Object[]{this.writerID, this.rowCount});
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private String[] parseCommand(String string) {
        int n;
        LinkedList<String> linkedList = new LinkedList<String>();
        int n2 = 0;
        int n3 = string.indexOf("\"");
        while (n3 >= 0 && (n = string.indexOf("\"", n3 + 1)) >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2, n3), " ");
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
            linkedList.add(string.substring(n3 + 1, n));
            n2 = n + 1;
            n3 = string.indexOf("\"", n2);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(n2), " ");
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(stringTokenizer.nextToken());
        }
        return linkedList.toArray(new String[linkedList.size()]);
    }

    @Override
    public synchronized void writeRow(byte[] byArray, int n, int n2) throws IOException {
        if (this.writer == null) {
            throw new XDBServerException(this.writerID + ": loader is not initialized");
        }
        if (this.terminated) {
            throw new IOException("Process terminated");
        }
        this.writer.write(byArray, n, n2);
        this.writer.write(10);
    }

    @Override
    public synchronized void writeRow(byte[] byArray) throws IOException {
        this.writeRow(byArray, 0, byArray.length);
    }

    @Override
    public String getStatistics() {
        return "Node Writer " + this.writerID + " has output " + this.totalRows + " rows in " + this.totalChunks + " chunks";
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    private class ForceKill
    implements Runnable {
        private Process process;
        private long waittime;
        private volatile boolean wasRunning = false;

        ForceKill(Process process2, long l) {
            this.process = process2;
            this.waittime = l;
            if (l > 0L) {
                Thread thread = new Thread(this);
                thread.setDaemon(true);
                thread.start();
            }
        }

        public void run() {
            long l = System.currentTimeMillis() + this.waittime;
            while (true) {
                try {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.process.exitValue();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    if (System.currentTimeMillis() <= l) continue;
                    this.wasRunning = true;
                    this.process.destroy();
                    return;
                }
                break;
            }
        }

        public boolean wasRunning() {
            return this.wasRunning;
        }
    }
}

