/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine.datatypes;

import com.edb.gridsql.engine.datatypes.XData;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class FloatType
implements XData {
    private int javaType = 6;
    private BigDecimal mantissa = null;
    private Integer exponent = null;
    private static final BigInteger TEN = new BigInteger(new byte[]{10});

    public FloatType(String string) {
        if (string != null) {
            int n = string.indexOf("E");
            if (n < 0) {
                n = string.indexOf("e");
            }
            try {
                if (n < 0) {
                    this.mantissa = new BigDecimal(string);
                    this.exponent = null;
                } else {
                    this.mantissa = new BigDecimal(string.substring(0, n));
                    String string2 = string.substring(n + 1);
                    if (string2.charAt(0) == '+') {
                        string2 = string2.substring(1);
                    }
                    this.exponent = new Integer(string2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.mantissa = null;
                this.exponent = null;
            }
        }
    }

    public int getJavaType() {
        return this.javaType;
    }

    public String toString() {
        Object object = null;
        try {
            object = this.getObject();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return object == null ? null : object.toString();
    }

    public boolean isValueNull() {
        return this.mantissa == null;
    }

    public void setNull(boolean bl) {
        if (bl) {
            this.mantissa = null;
            this.exponent = null;
        }
    }

    public void setJavaType(int n) {
        this.javaType = n;
    }

    public Object getObject() throws SQLException {
        if (this.mantissa == null) {
            return null;
        }
        if (this.exponent == null) {
            return this.mantissa;
        }
        BigInteger bigInteger = this.mantissa.unscaledValue();
        int n = this.mantissa.scale() - this.exponent;
        if (n < 0) {
            bigInteger = bigInteger.multiply(TEN.pow(-n));
            n = 0;
        }
        return new BigDecimal(bigInteger, n);
    }

    public void setObject(Object object) throws SQLException {
    }

    public String toString(String string) throws UnsupportedEncodingException {
        if (this.isValueNull()) {
            return null;
        }
        return new String(this.toString().getBytes(string));
    }
}

