/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.ColumnMetaData;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.ExecutableRequest;
import com.edb.gridsql.engine.ExecutionResult;
import com.edb.gridsql.engine.IParametrizedSql;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.engine.io.CopyResponse;
import com.edb.gridsql.engine.io.ResponseMessage;
import com.edb.gridsql.engine.io.ResultSetResponse;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.scheduler.ILockCost;
import com.edb.gridsql.parser.SqlCopyData;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ServerStatement {
    private static final XLogger logger = XLogger.getLogger(ServerStatement.class);
    private String statementID = null;
    private String cursorID = null;
    private ExecutableRequest request;
    private XDBSessionContext client;
    private ResponseMessage description;
    private ExecutionResult result;
    private int fetchSize = 200;
    private boolean wasInternallyExecuted = false;

    ServerStatement(String string, ExecutableRequest executableRequest, XDBSessionContext xDBSessionContext) {
        this.statementID = string;
        this.cursorID = null;
        this.request = executableRequest;
        this.client = xDBSessionContext;
        this.description = null;
        this.result = null;
    }

    ServerStatement(String string, ExecutionResult executionResult, XDBSessionContext xDBSessionContext) {
        this.statementID = null;
        this.cursorID = string;
        this.request = null;
        this.client = xDBSessionContext;
        this.description = null;
        this.result = executionResult;
    }

    public void setParameterTypes(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            ILockCost iLockCost = this.request.getCost().getSqlObject();
            if (iLockCost instanceof IParametrizedSql) {
                ((IParametrizedSql)((Object)iLockCost)).setParamDataTypes(nArray);
            } else {
                throw new XDBServerException("SQL object does not support parameters");
            }
        }
    }

    public int[] getParameterTypes() {
        ILockCost iLockCost = this.request.getCost().getSqlObject();
        if (iLockCost instanceof IParametrizedSql) {
            return ((IParametrizedSql)((Object)iLockCost)).getParamDataTypes();
        }
        return null;
    }

    public void bind(String string, String[] stringArray) {
        this.cursorID = string;
        if (stringArray != null && stringArray.length > 0) {
            ILockCost iLockCost = this.request.getCost().getSqlObject();
            if (iLockCost instanceof IParametrizedSql) {
                ((IParametrizedSql)((Object)iLockCost)).setParamValues(stringArray);
            } else {
                throw new XDBServerException("SQL object does not support parameters");
            }
        }
    }

    public ResponseMessage describe() {
        if (this.description == null) {
            if (this.request.getCost().getSqlObject() instanceof SqlCopyData) {
                SqlCopyData sqlCopyData = (SqlCopyData)this.request.getCost().getSqlObject();
                if (sqlCopyData.isConsole()) {
                    this.description = new CopyResponse(sqlCopyData);
                }
            } else {
                if (this.result == null) {
                    this.execute(true);
                }
                if (this.result.getContentType() == 2) {
                    this.description = new ResultSetResponse(0, this.cursorID, this.result.getResultSet());
                } else if (this.result.getContentType() == 4) {
                    ResultSet resultSet = this.result.getSubResults().values().iterator().next().getResultSet();
                    if (resultSet == null) {
                        ColumnMetaData[] columnMetaDataArray = new ColumnMetaData[]{new ColumnMetaData("", "Result", 10, 4, 0, 0, "", 0, false), new ColumnMetaData("", "Node", 0, 4, 0, 0, "", 0, false)};
                        ResultSetResponse resultSetResponse = new ResultSetResponse(0, this.cursorID, null);
                        resultSetResponse.setColumnMetaData(columnMetaDataArray);
                        this.description = resultSetResponse;
                    } else {
                        ResultSetResponse resultSetResponse = new ResultSetResponse(0, this.cursorID, resultSet);
                        ColumnMetaData[] columnMetaDataArray = resultSetResponse.getColumnMetaData();
                        ColumnMetaData[] columnMetaDataArray2 = new ColumnMetaData[columnMetaDataArray.length + 1];
                        System.arraycopy(columnMetaDataArray, 0, columnMetaDataArray2, 0, columnMetaDataArray.length);
                        columnMetaDataArray2[columnMetaDataArray.length] = new ColumnMetaData("", "Node", 0, 4, 0, 0, "", 0, false);
                        resultSetResponse.setColumnMetaData(columnMetaDataArray2);
                        this.description = resultSetResponse;
                    }
                }
            }
        }
        return this.description;
    }

    public ExecutionResult execute() {
        return this.execute(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutionResult execute(boolean bl) {
        if (bl) {
            if (this.result != null) return this.result;
            this.wasInternallyExecuted = true;
        } else if (this.result != null && this.wasInternallyExecuted) {
            this.wasInternallyExecuted = false;
            return this.result;
        }
        this.result = this.client.executeRequest(this.request);
        if (!(this.description instanceof ResultSetResponse)) return this.result;
        ((ResultSetResponse)this.description).setResultSet(this.result.getResultSet());
        return this.result;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public ResultSet getResultSet() {
        if (this.result == null) {
            this.execute();
        }
        return this.result.getResultSet();
    }

    public boolean hasResultSet() {
        return this.result != null && this.result.hasResultSet();
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    public void close() {
        if (this.result != null) {
            if (this.result.getContentType() == 2 && this.result.getResultSet() != null) {
                try {
                    this.result.getResultSet().close();
                }
                catch (SQLException sQLException) {
                    logger.catching(sQLException);
                }
            } else if (this.result.getContentType() == 4) {
                for (ExecutionResult executionResult : this.result.getSubResults().values()) {
                    if (executionResult.getContentType() != 2 || executionResult.getResultSet() == null) continue;
                    try {
                        executionResult.getResultSet().close();
                    }
                    catch (SQLException sQLException) {
                        logger.catching(sQLException);
                    }
                }
            }
        }
    }

    String getStatementID() {
        return this.statementID;
    }

    String getCursorID() {
        return this.cursorID;
    }
}

