/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.exception.XDBServerException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectPool<T> {
    private static final XLogger logger = XLogger.getLogger(ObjectPool.class);
    public static final long DEFAULT_RELEASE_TIMEOUT = 600000L;
    public static final long DEFAULT_GET_TIMEOUT = 60000L;
    private int minSize;
    private int maxSize;
    private boolean destroyed;
    private long releaseTimeout = 600000L;
    private long getTimeout = 60000L;
    private LinkedList<PoolEntry<T>> buffer;
    private HashSet<T> out;
    private Runnable cleanupAgent = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectPool(int n, int n2) {
        this.minSize = n;
        this.maxSize = n2;
        this.destroyed = false;
        this.buffer = new LinkedList();
        this.out = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBuffer() throws XDBServerException {
        for (int i = this.buffer.size() + this.out.size(); i < this.minSize; ++i) {
            try {
                PoolEntry poolEntry = new PoolEntry();
                poolEntry.timestamp = System.currentTimeMillis();
                poolEntry.entry = this.createEntry();
                this.buffer.addLast(poolEntry);
                continue;
            }
            catch (XDBServerException xDBServerException) {
                logger.catching(xDBServerException);
                XDBServerException xDBServerException2 = new XDBServerException("Failed to initialize pool", xDBServerException);
                logger.throwing(xDBServerException2);
                throw xDBServerException2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T getObject() throws XDBServerException {
        block7: {
            block6: {
                if (this.destroyed) {
                    XDBServerException xDBServerException = new XDBServerException("Can not serve object - pool is destroyed");
                    logger.throwing(xDBServerException);
                    throw xDBServerException;
                }
                if (this.buffer.isEmpty()) break block6;
                PoolEntry<T> poolEntry = this.buffer.removeFirst();
                this.out.add(poolEntry.entry);
                this.packBuffer();
                Object e = poolEntry.entry;
                return (T)e;
            }
            if (this.out.size() >= this.maxSize) break block7;
            T t = this.createEntry();
            this.out.add(t);
            T t2 = t;
            return t2;
        }
        if (this.cleanupAgent != null) {
            new Thread(this.cleanupAgent).start();
        }
        T t = this.createEntry();
        this.out.add(t);
        T t3 = t;
        return t3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isOut(Object object) throws XDBServerException {
        boolean bl = this.out.contains(object);
        this.notifyAll();
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseObject(T t) throws XDBServerException {
        if (!this.out.remove(t)) {
            XDBServerException xDBServerException = new XDBServerException("Attempt to release unknown object");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        if (this.destroyed) {
            this.destroyEntry(t);
        } else if (this.buffer.size() + this.out.size() <= this.maxSize) {
            PoolEntry poolEntry = new PoolEntry();
            poolEntry.timestamp = System.currentTimeMillis();
            poolEntry.entry = t;
            this.buffer.addLast(poolEntry);
            this.packBuffer();
        } else {
            this.destroyEntry(t);
        }
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroyObject(T t, boolean bl) throws XDBServerException {
        if (!this.out.remove(t)) {
            XDBServerException xDBServerException = new XDBServerException("Attempt to release unknown object");
            logger.throwing(xDBServerException);
            throw xDBServerException;
        }
        if (bl) {
            this.destroyEntry(t);
        }
        if (this.buffer.size() + this.out.size() < this.minSize) {
            this.initBuffer();
        }
        this.notifyAll();
    }

    public synchronized void destroy() {
        this.destroyed = true;
        while (!this.buffer.isEmpty()) {
            this.destroyEntry(this.buffer.removeFirst().entry);
        }
        for (T t : this.out) {
            this.destroyEntry(t);
        }
        this.out.clear();
        this.notifyAll();
    }

    protected abstract T createEntry() throws XDBServerException;

    protected void destroyEntry(T t) {
    }

    protected synchronized void packBuffer() {
        while (this.buffer.size() > 0 && this.buffer.size() + this.out.size() > this.minSize) {
            PoolEntry<T> poolEntry = this.buffer.getFirst();
            if (poolEntry.timestamp + this.releaseTimeout < System.currentTimeMillis()) {
                this.destroyEntry(this.buffer.removeFirst().entry);
                continue;
            }
            return;
        }
    }

    public synchronized long getGetTimeout() {
        return this.getTimeout;
    }

    public synchronized int getMaxSize() {
        return this.maxSize;
    }

    public synchronized int getMinSize() {
        return this.minSize;
    }

    public synchronized Collection<T> getObjectsInUse() {
        return new ArrayList<T>(this.out);
    }

    public synchronized long getReleaseTimeout() {
        return this.releaseTimeout;
    }

    public synchronized void setGetTimeout(long l) {
        this.getTimeout = l;
    }

    public synchronized void setMaxSize(int n) {
        this.maxSize = n;
    }

    public synchronized void setMinSize(int n) {
        this.minSize = n;
    }

    public synchronized void setReleaseTimeout(long l) {
        this.releaseTimeout = l;
    }

    public synchronized Runnable setCleanupAgent(Runnable runnable) {
        Runnable runnable2 = this.cleanupAgent;
        this.cleanupAgent = runnable;
        return runnable2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PoolEntry<E> {
        public long timestamp;
        public E entry;

        protected PoolEntry() {
        }
    }
}

