/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLevel;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.NodeThread;
import com.edb.gridsql.engine.ProducerSender;
import com.edb.gridsql.engine.io.DataTypes;
import com.edb.gridsql.engine.io.ResponseMessage;
import com.edb.gridsql.engine.io.ResultSetResponse;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.exception.XDBUnexpectedMessageException;
import com.edb.gridsql.exception.XDBUnexpectedStateException;
import com.edb.gridsql.exception.XDBWrappedException;
import com.edb.gridsql.exception.XDBWrappedSQLException;
import com.edb.gridsql.misc.Timer;
import com.edb.gridsql.parser.handler.IdentifierHandler;
import com.edb.gridsql.planner.StepDetail;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeProducerThread
implements Runnable {
    private static final XLogger logger = XLogger.getLogger(NodeProducerThread.class);
    public static final XLogger CATEGORY_NODEQUERYTIME = XLogger.getLogger("nodequerytime");
    protected static final int STATEDISCONNECTED = -1;
    protected static final int STATEWAIT = 0;
    protected static final int STATEDONE = 5;
    protected static final int STATESTEP = 7;
    protected static final int STATEDATADOWN = 8;
    private int currentState;
    private volatile int requestIDtoAbort = -1;
    private Connection oConn;
    int iColumnCount;
    private NodeThread parent;
    int nodeId;
    private SendMessageHelper sendHelper;
    int procCount = 0;
    private LinkedBlockingQueue<NodeMessage> producerQueue;
    private volatile Statement aStatement = null;
    private HashMap<String, QueryResult> resultTable = new HashMap();
    private HashMap<String, PreparedStatementEx> preparedStatementTable = new HashMap();
    private ProducerSender aProducerSender = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeProducerThread(NodeThread nodeThread, LinkedBlockingQueue<NodeMessage> linkedBlockingQueue) {
        this.parent = nodeThread;
        this.nodeId = nodeThread.getNodeId();
        this.producerQueue = linkedBlockingQueue;
        this.currentState = -1;
        this.resultTable = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reset() throws XDBBaseException {
        int n;
        for (n = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != 5 && n <= 20; ++n) {
            try {
                this.wait(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                logger.catching(interruptedException);
            }
        }
        for (n = 0; this.currentState != -1 && this.currentState != 0 && this.currentState != 5 && n <= 20; ++n) {
            this.kill();
            try {
                this.wait(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                logger.catching(interruptedException);
            }
        }
        if (this.currentState == 5) {
            XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, 5, new int[]{0, -1});
            logger.throwing(xDBUnexpectedStateException);
            throw xDBUnexpectedStateException;
        }
        this.oConn = this.parent.getConnection();
        this.aStatement = null;
        this.sendHelper = this.parent.getSendHelper();
        if (this.oConn == null || this.sendHelper == null) {
            this.setState(-1);
            this.closeAllResultSets();
        } else {
            this.setState(0);
        }
        this.requestIDtoAbort = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setState(int n) {
        this.currentState = n;
        this.notify();
    }

    private synchronized int checkCurrentState(int[] nArray, int n) throws XDBUnexpectedStateException {
        for (int n2 : nArray) {
            if (this.currentState != n2) continue;
            this.setState(n);
            return n2;
        }
        XDBUnexpectedStateException xDBUnexpectedStateException = new XDBUnexpectedStateException(this.nodeId, this.currentState, nArray);
        logger.throwing(xDBUnexpectedStateException);
        throw xDBUnexpectedStateException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void run() {
        var1_1 = null;
        while (true) lbl-1000:
        // 3 sources

        {
            try {
                block44: while (true) {
                    if ((var1_1 = this.producerQueue.poll(5L, TimeUnit.SECONDS)) == null) {
                        continue;
                    }
                    NodeMessage.CATEGORY_MESSAGE.debug("NPT.run(): received message: " + var1_1);
                    switch (var1_1.getMessageType()) {
                        case 209: {
                            this.checkCurrentState(new int[]{0}, 7);
                            try {
                                var2_2 /* !! */  = this.processStep(var1_1);
                                var3_6 = null;
                                NodeProducerThread.CATEGORY_NODEQUERYTIME.debug("Node " + this.nodeId + ": Step is done, ResulSet: " + var2_2 /* !! */ );
                                if (var1_1.getStepDetail().getDestType() == 6) {
                                    var4_8 = String.valueOf(var1_1.getRequestId());
                                    var3_6 = new QueryResult(new ResultSetResponse(0, null, (ResultSet)var2_2 /* !! */ ));
                                    QueryResult.access$200((QueryResult)var3_6, 11);
                                    var3_6.nextMessage.setResultSetID((String)var4_8);
                                    if (!var3_6.nextMessage.isResultSetHasMoreRows()) {
                                        this.closeStatement();
                                    }
                                    this.sendHelper.sendReplyMessage(var1_1, var3_6.nextMessage);
                                    if (!var3_6.nextMessage.isResultSetHasMoreRows()) continue block44;
                                    this.resultTable.put((String)var4_8, (QueryResult)var3_6);
                                    QueryResult.access$200((QueryResult)var3_6, 43);
                                    continue block44;
                                }
                                this.closeStatement();
                                var4_8 = NodeMessage.getNodeMessage(11);
                                this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_8);
                                continue block44;
                            }
                            finally {
                                this.setState(0);
                                continue block44;
                            }
                        }
                        case 7: 
                        case 107: {
                            this.checkCurrentState(new int[]{0}, 7);
                            try {
                                try {
                                    this.executeCommand(var1_1);
                                    continue block44;
                                }
                                catch (SQLException var2_3) {
                                    this.parent.handleSqlException(var2_3, var1_1.getSqlCommand());
                                    try {
                                        this.executeCommand(var1_1);
                                        continue block44;
                                    }
                                    catch (SQLException var3_7) {
                                        NodeProducerThread.logger.catching(var3_7);
                                        var4_8 = new XDBWrappedSQLException(this.nodeId, var3_7);
                                        NodeProducerThread.logger.throwing((Throwable)var4_8);
                                        throw var4_8;
                                    }
                                }
                            }
                            finally {
                                this.setState(0);
                                continue block44;
                            }
                        }
                        case 26: {
                            this.checkCurrentState(new int[]{0}, 7);
                            try {
                                this.dropTempTables(var1_1.getTempTables(), var1_1.getAutocommit());
                                this.sendHelper.sendReplyMessage(var1_1, 27);
                                continue block44;
                            }
                            finally {
                                this.setState(0);
                                continue block44;
                            }
                        }
                        case 1001: {
                            this.setState(5);
                            return;
                        }
                        case 1: {
                            this.requestIDtoAbort = var1_1.getRequestId();
                            break;
                        }
                        case 42: {
                            this.checkCurrentState(new int[]{0}, 8);
                            try {
                                var2_2 /* !! */  = var1_1.getResultSetID();
                                var3_6 = this.resultTable.get(var2_2 /* !! */ );
                                if (var3_6 == null || var3_6.nextMessage == null) {
                                    var4_8 = new XDBUnexpectedMessageException(this.nodeId, "No more rows available", var1_1);
                                    this.closeStatement();
                                    if (this.sendHelper != null) {
                                        this.requestIDtoAbort = var1_1.getRequestId();
                                        var5_9 = NodeMessage.getNodeMessage(1);
                                        var5_9.setCause((XDBBaseException)var4_8);
                                        var5_9.setRequestId(this.requestIDtoAbort);
                                        this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var5_9);
                                        continue block44;
                                    }
                                    this.resultTable.remove(var2_2 /* !! */ );
                                }
                                if (!var3_6.nextMessage.isResultSetHasMoreRows()) {
                                    this.closeStatement();
                                }
                                var3_6.nextMessage.setResultSetID((String)var2_2 /* !! */ );
                                this.sendHelper.sendReplyMessage(var1_1, var3_6.nextMessage);
                                if (var3_6.nextMessage.isResultSetHasMoreRows()) {
                                    QueryResult.access$200((QueryResult)var3_6, 43);
                                    continue block44;
                                }
                                this.resultTable.remove(var2_2 /* !! */ );
                                continue block44;
                            }
                            finally {
                                this.setState(0);
                                continue block44;
                            }
                        }
                        case 142: {
                            this.checkCurrentState(new int[]{0}, 8);
                            try {
                                var2_2 /* !! */  = var1_1.getResultSetID();
                                this.resultTable.remove(var2_2 /* !! */ );
                                this.closeStatement();
                                continue block44;
                            }
                            finally {
                                this.setState(0);
                                continue block44;
                            }
                        }
                        case 71: {
                            var2_2 /* !! */  = var1_1.getRowData();
                            var3_6 = var2_2 /* !! */ [0];
                            var4_8 = var2_2 /* !! */ [1];
                            var5_9 = new int[var2_2 /* !! */ .length - 2];
                            for (var6_12 = 0; var6_12 < ((int[])var5_9).length; ++var6_12) {
                                var5_9[var6_12] = Integer.parseInt(var2_2 /* !! */ [var6_12 + 2]);
                            }
                            this.preparedStatementTable.put((String)var3_6, new PreparedStatementEx(this.oConn.prepareStatement((String)var4_8), (int[])var5_9));
                            this.sendHelper.sendReplyMessage(var1_1, 81);
                            break;
                        }
                        case 72: {
                            var2_2 /* !! */  = var1_1.getRowData();
                            var6_13 = this.preparedStatementTable.get(var2_2 /* !! */ [0]);
                            if (var6_13 == null) {
                                throw new XDBServerException("Prepared statement does not exist");
                            }
                            for (var7_15 = 1; var7_15 < var2_2 /* !! */ .length; ++var7_15) {
                                DataTypes.setParameter(var6_13.ps, var7_15, var2_2 /* !! */ [var7_15], var6_13.paramTypes[var7_15 - 1]);
                            }
                            this.handleExecutionResult(var6_13.ps.execute(), var6_13.ps, var1_1);
                            break;
                        }
                        case 73: {
                            var3_6 = var1_1.getSqlCommand();
                            var6_14 = this.preparedStatementTable.remove(var3_6);
                            var6_14.ps.close();
                            this.sendHelper.sendReplyMessage(var1_1, 83);
                        }
                    }
                }
            }
            catch (XDBBaseException var2_4) {
                var3_6 = this;
                synchronized (var3_6) {
                    NodeProducerThread.logger.catching(var2_4);
                    if (this.sendHelper != null) {
                        this.requestIDtoAbort = var1_1.getRequestId();
                        var4_8 = NodeMessage.getNodeMessage(1);
                        var4_8.setCause(var2_4);
                        this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_8);
                    }
                    continue;
                }
            }
            catch (Throwable var2_5) {
                var3_6 = this;
                synchronized (var3_6) {
                    NodeProducerThread.logger.catching(var2_5);
                    if (this.sendHelper != null) {
                        this.requestIDtoAbort = var1_1.getRequestId();
                        var4_8 = NodeMessage.getNodeMessage(1);
                        var4_8.setCause(new XDBWrappedException(this.nodeId, var2_5));
                        this.sendHelper.sendReplyMessage(var1_1, (NodeMessage)var4_8);
                    }
                    continue;
                }
            }
            break;
        }
        {
            ** while (true)
        }
    }

    private synchronized void closeAllResultSets() {
        if (this.resultTable != null) {
            for (QueryResult queryResult : this.resultTable.values()) {
                this.closeResultSet(queryResult.aResultSet);
                this.resultTable.remove(queryResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeResultSet(ResultSet resultSet) {
        try {
            if (this.currentState == -1) {
                return;
            }
            Connection connection = this.oConn;
            synchronized (connection) {
                if (resultSet != null) {
                    resultSet.getStatement().close();
                    resultSet = null;
                } else {
                    logger.log(XLevel.TRACE, "For connection: %0% current result set is Null, nothing to do", new Object[]{this.oConn});
                }
                this.oConn.notify();
            }
        }
        catch (Exception exception) {
            logger.catching(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet processStep(NodeMessage nodeMessage) throws XDBBaseException {
        try {
            ResultSet resultSet;
            StepDetail stepDetail;
            block23: {
                stepDetail = nodeMessage.getStepDetail();
                try {
                    try {
                        resultSet = this.executeQuery(stepDetail.queryString);
                    }
                    catch (SQLException sQLException) {
                        this.parent.handleSqlException(sQLException, stepDetail.queryString);
                        try {
                            resultSet = this.executeQuery(stepDetail.queryString);
                        }
                        catch (SQLException sQLException2) {
                            logger.catching(sQLException2);
                            XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException2);
                            logger.throwing(xDBWrappedSQLException);
                            throw xDBWrappedSQLException;
                        }
                    }
                    if (stepDetail.getDestType() != 6) break block23;
                    ResultSet resultSet2 = resultSet;
                    return resultSet2;
                }
                catch (Exception exception) {
                    Object object;
                    logger.catching(exception);
                    try {
                        object = this.oConn;
                        synchronized (object) {
                            if (this.aStatement != null) {
                                try {
                                    logger.log(XLevel.TRACE, "For connection: %0% closing statement: %1%", new Object[]{this.oConn, this.aStatement});
                                    this.aStatement.close();
                                }
                                catch (Exception exception2) {
                                    logger.catching(exception2);
                                }
                                this.aStatement = null;
                                resultSet = null;
                            }
                            this.oConn.notify();
                        }
                        this.dropTempTables(stepDetail.dropList, false);
                    }
                    catch (Exception exception3) {
                        logger.catching(exception3);
                    }
                    object = exception instanceof XDBBaseException ? (XDBBaseException)exception : (exception instanceof SQLException ? new XDBWrappedSQLException(this.nodeId, (SQLException)exception) : new XDBWrappedException(this.nodeId, (Throwable)exception));
                    if (stepDetail.consumerNodeList != null) {
                        this.requestIDtoAbort = nodeMessage.getRequestId();
                        NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(1);
                        nodeMessage2.setRequestId(this.requestIDtoAbort);
                        nodeMessage2.setCause((XDBBaseException)object);
                        this.sendHelper.sendMessageToList(stepDetail.consumerNodeList, nodeMessage2);
                    }
                    logger.throwing((Throwable)object);
                    throw object;
                }
            }
            this.aProducerSender = new ProducerSender(this.sendHelper, this.producerQueue);
            this.aProducerSender.sendToNodes(resultSet, stepDetail, this.oConn, this.nodeId, nodeMessage.getRequestId());
            AutoCloseable autoCloseable = this.oConn;
            synchronized (autoCloseable) {
                this.aStatement.close();
                resultSet = null;
                this.oConn.notify();
            }
            this.dropTempTables(stepDetail.dropList, false);
            autoCloseable = resultSet;
            return autoCloseable;
        }
        finally {
            this.aProducerSender = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResultSet executeQuery(String string) throws SQLException {
        ResultSet resultSet = null;
        Object object = this.oConn;
        synchronized (object) {
            this.aStatement = this.oConn.createStatement();
            this.aStatement.setFetchSize(Props.XDB_NODEFETCHSIZE);
            logger.log(XLevel.TRACE, "For connection: %0% setting fetch size of statement: %1% to 1000", new Object[]{this.oConn, this.aStatement});
            this.oConn.notify();
        }
        object = new Timer();
        Connection connection = this.oConn;
        synchronized (connection) {
            ((Timer)object).startTimer();
            resultSet = this.aStatement.executeQuery(string);
            ((Timer)object).stopTimer();
            this.oConn.notify();
        }
        CATEGORY_NODEQUERYTIME.debug("Node: " + this.nodeId + " Duration: " + object + " : " + string);
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommand(NodeMessage nodeMessage) throws SQLException {
        boolean bl;
        Object object = this.oConn;
        synchronized (object) {
            this.aStatement = this.oConn.createStatement();
            this.aStatement.setFetchSize(Props.XDB_NODEFETCHSIZE);
            logger.log(XLevel.TRACE, "For connection: %0% setting fetch size of statement: %1% to 1000", new Object[]{this.oConn, this.aStatement});
            this.oConn.notify();
        }
        object = new Timer();
        Connection connection = this.oConn;
        synchronized (connection) {
            ((Timer)object).startTimer();
            if (nodeMessage.getAutocommit()) {
                this.oConn.setAutoCommit(true);
            }
            bl = this.aStatement.execute(nodeMessage.getSqlCommand());
            if (nodeMessage.getAutocommit()) {
                this.oConn.setAutoCommit(false);
            }
            ((Timer)object).stopTimer();
            this.oConn.notify();
        }
        CATEGORY_NODEQUERYTIME.debug("Node: " + this.nodeId + " Duration: " + object + " : " + nodeMessage.getSqlCommand());
        this.handleExecutionResult(bl, this.aStatement, nodeMessage);
    }

    private void handleExecutionResult(boolean bl, Statement statement, NodeMessage nodeMessage) throws SQLException {
        if (bl) {
            ResultSet resultSet = statement.getResultSet();
            String string = String.valueOf(nodeMessage.getRequestId());
            QueryResult queryResult = new QueryResult(new ResultSetResponse(0, "", resultSet));
            queryResult.packNextResultRows(108);
            queryResult.nextMessage.setResultSetID(string);
            if (queryResult.nextMessage.isResultSetHasMoreRows()) {
                this.resultTable.put(string, queryResult);
            } else {
                resultSet.close();
            }
            this.sendHelper.sendReplyMessage(nodeMessage, queryResult.nextMessage);
            if (queryResult.nextMessage.isResultSetHasMoreRows()) {
                queryResult.packNextResultRows(43);
            }
        } else {
            NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(8);
            nodeMessage2.setNumRowsResult(statement.getUpdateCount());
            this.sendHelper.sendReplyMessage(nodeMessage, nodeMessage2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTempTables(Collection collection, boolean bl) {
        block17: {
            for (String string : collection) {
                try {
                    this.processSqlCommand("DROP TABLE " + IdentifierHandler.quote(string), false);
                    HashSet<String> hashSet = this.parent.tempTableNames;
                    synchronized (hashSet) {
                        this.parent.tempTableNames.remove(string);
                    }
                }
                catch (Exception exception) {
                    Connection connection = this.oConn;
                    synchronized (connection) {
                        try {
                            this.oConn.rollback();
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        this.oConn.notify();
                    }
                    logger.catching(exception);
                }
            }
            if (!bl) break block17;
            try {
                this.oConn.commit();
            }
            catch (SQLException sQLException) {
                try {
                    this.oConn.rollback();
                }
                catch (SQLException sQLException2) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int processSqlCommand(String string, boolean bl) throws XDBBaseException {
        int n = 0;
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                this.aStatement = this.oConn.createStatement();
                try {
                    n = this.aStatement.executeUpdate(string);
                    if (bl) {
                        this.oConn.commit();
                    }
                }
                finally {
                    this.aStatement.close();
                    this.aStatement = null;
                }
                this.oConn.notify();
            }
            int n2 = n;
            return n2;
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
            XDBWrappedSQLException xDBWrappedSQLException = new XDBWrappedSQLException(this.nodeId, sQLException);
            logger.throwing(xDBWrappedSQLException);
            throw xDBWrappedSQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStatement() {
        try {
            Connection connection = this.oConn;
            synchronized (connection) {
                if (this.aStatement != null) {
                    this.aStatement.close();
                    this.aStatement = null;
                }
                this.oConn.notifyAll();
            }
        }
        catch (SQLException sQLException) {
            logger.catching(sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        if (this.aProducerSender != null) {
            this.aProducerSender.setAbort(true);
        }
        try {
            for (QueryResult queryResult : this.resultTable.values()) {
                if (queryResult.aResultSet == null) continue;
                Statement statement = queryResult.aResultSet.getStatement();
                if (statement == null) {
                    queryResult.aResultSet.close();
                    continue;
                }
                statement.cancel();
            }
            this.resultTable.clear();
            if (this.aStatement != null) {
                this.aStatement.cancel();
            }
        }
        catch (Throwable throwable) {
            logger.catching(throwable);
        }
    }

    protected int getState() {
        return this.currentState;
    }

    private class PreparedStatementEx {
        PreparedStatement ps;
        int[] paramTypes;

        PreparedStatementEx(PreparedStatement preparedStatement, int[] nArray) {
            this.ps = preparedStatement;
            this.paramTypes = nArray;
        }
    }

    class QueryResult {
        ResultSetResponse rsResponse;
        ResultSet aResultSet;
        NodeMessage nextMessage = null;

        public QueryResult(ResultSetResponse resultSetResponse) {
            this.rsResponse = resultSetResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private NodeMessage packNextResultRows(int n) throws SQLException {
            block4: {
                if (this.rsResponse != null) break block4;
                NodeMessage nodeMessage = null;
                return nodeMessage;
            }
            ResponseMessage responseMessage = this.rsResponse.nextResults(this.rsResponse.getFetchSize());
            byte[] byArray = new byte[responseMessage.getPacketLength()];
            System.arraycopy(responseMessage.getHeaderBytes(), 0, byArray, 0, 8);
            System.arraycopy(responseMessage.getMessage(), 0, byArray, 8, responseMessage.getPacketLength() - 8);
            this.nextMessage = NodeMessage.getNodeMessage(n);
            this.nextMessage.setResultSetData(byArray);
            boolean bl = responseMessage.getMessage()[0] == 1;
            logger.log(Level.INFO, "Node %0% sends new ResultSet packet, size: %1%, last: %2%", new Object[]{new Integer(NodeProducerThread.this.nodeId), new Integer(byArray.length), new Boolean(bl)});
            if (bl) {
                NodeProducerThread.this.closeResultSet(this.aResultSet);
                this.rsResponse = null;
            }
            this.nextMessage.setResultSetHasMoreRows(!bl);
            NodeMessage nodeMessage = this.nextMessage;
            return nodeMessage;
        }
    }
}

