/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.engine.JDBCPool;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.Node;
import java.sql.Connection;
import java.util.HashMap;

public class CoordinatorPools {
    private static final XLogger logger = XLogger.getLogger(CoordinatorPools.class);
    private static final HashMap<String, JDBCPool> connections = new HashMap();
    private static int initialNode = -1;

    public static void setInitialNode(int n) {
        initialNode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initPool(String string) {
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            JDBCPool jDBCPool = connections.get(string);
            if (jDBCPool == null) {
                int n = Property.getInt("xdb.jdbc.coordinator.pool.initsize", Props.XDB_DEFAULT_THREADS_POOL_INITSIZE);
                int n2 = Property.getInt("xdb.jdbc.coordinator.pool.maxsize", Math.max((int)Math.round((double)Props.XDB_DEFAULT_THREADS_POOL_MAXSIZE * 0.8), n));
                Node node = MetaData.getMetaData().getNode(initialNode);
                jDBCPool = new JDBCPool(node.getSJdbcDriver(), node.getJdbcString(string), node.getJdbcUser(), node.getJdbcPassword(), n, n2);
                jDBCPool.setGetTimeout(-1L);
                jDBCPool.setReleaseTimeout(Property.getInt("xdb.jdbc.pool.idle", Props.XDB_DEFAULT_THREADS_POOL_IDLE));
                jDBCPool.initBuffer();
                connections.put(string, jDBCPool);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destoryPool(String string) {
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            JDBCPool jDBCPool = connections.remove(string);
            if (jDBCPool != null) {
                jDBCPool.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String string) {
        block6: {
            JDBCPool jDBCPool = null;
            Object object = connections;
            synchronized (object) {
                jDBCPool = connections.get(string);
            }
            if (jDBCPool == null) break block6;
            object = jDBCPool.getConnection();
            return object;
        }
        throw new XDBServerException("Coordinator Pool for database " + string + " is not initialized");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseConnection(String string, Connection connection) throws Exception {
        JDBCPool jDBCPool = null;
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            jDBCPool = connections.get(string);
        }
        if (jDBCPool != null) {
            jDBCPool.releaseConnection(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyConnection(String string, Connection connection) {
        JDBCPool jDBCPool = null;
        HashMap<String, JDBCPool> hashMap = connections;
        synchronized (hashMap) {
            jDBCPool = connections.get(string);
        }
        if (jDBCPool != null) {
            jDBCPool.destroyConnection(connection);
        }
    }
}

