/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.engine;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.SendMessageHelper;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.engine.MessageMonitor;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.exception.ErrorMessageRepository;
import com.edb.gridsql.exception.XDBServerException;
import com.edb.gridsql.metadata.DBNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchHandler {
    private static final XLogger logger = XLogger.getLogger(BatchHandler.class);
    SendMessageHelper sendHelper;
    LinkedBlockingQueue<NodeMessage> producerQueue;
    XDBSessionContext client;
    private HashMap<Integer, NodeMessage> nodeMsgTable;
    private HashMap<Integer, List<Integer>> mappingTables;
    private int lineNum;
    private int requestId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BatchHandler(SendMessageHelper sendMessageHelper, LinkedBlockingQueue<NodeMessage> linkedBlockingQueue, XDBSessionContext xDBSessionContext) {
        this.sendHelper = sendMessageHelper;
        this.producerQueue = linkedBlockingQueue;
        this.client = xDBSessionContext;
        this.requestId = xDBSessionContext.getRequestId();
        this.nodeMsgTable = new HashMap(32);
        this.mappingTables = new HashMap(32);
        this.lineNum = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initBatch() {
        this.lineNum = 0;
        this.nodeMsgTable.clear();
        this.nodeMsgTable = new HashMap();
        this.mappingTables = new HashMap();
        this.requestId = this.client.getRequestId();
    }

    private boolean addStatementToNode(String string, int n) {
        List<Integer> list;
        NodeMessage nodeMessage = this.nodeMsgTable.get(n);
        if (nodeMessage == null) {
            nodeMessage = NodeMessage.getNodeMessage(40);
            nodeMessage.setRequestId(this.requestId);
            this.nodeMsgTable.put(n, nodeMessage);
            list = new ArrayList<Integer>(1000);
            this.mappingTables.put(n, list);
        } else {
            list = this.mappingTables.get(n);
        }
        nodeMessage.addRowData(string);
        list.add(this.lineNum);
        return !nodeMessage.canAddRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToBatchOnNodeList(String string, Collection<DBNode> collection) {
        boolean bl = false;
        for (DBNode dBNode : collection) {
            bl |= this.addStatementToNode(string, dBNode.getNodeId());
        }
        ++this.lineNum;
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToBatchOnNodes(Map<DBNode, String> map) {
        boolean bl = false;
        for (Map.Entry<DBNode, String> entry : map.entrySet()) {
            bl |= this.addStatementToNode(entry.getValue(), entry.getKey().getNodeId());
        }
        ++this.lineNum;
        boolean bl2 = bl;
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addToBatchOnNode(String string, int n) {
        boolean bl = this.addStatementToNode(string, n);
        ++this.lineNum;
        boolean bl2 = bl;
        return bl2;
    }

    public int getRequestId() {
        return this.requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(boolean bl) {
        NodeMessage nodeMessage;
        int[] nArray = new int[this.lineNum];
        if (this.lineNum == 0) {
            return nArray;
        }
        boolean bl2 = false;
        Arrays.fill(nArray, -2);
        MessageMonitor messageMonitor = new MessageMonitor(this.client);
        messageMonitor.setMonitor(this.requestId, this.nodeMsgTable.keySet());
        for (Map.Entry<Integer, NodeMessage> object2 : this.nodeMsgTable.entrySet()) {
            Integer n = object2.getKey();
            nodeMessage = object2.getValue();
            this.sendHelper.sendMessage(n, nodeMessage);
        }
        this.nodeMsgTable.clear();
        block5: do {
            Object object;
            nodeMessage = null;
            try {
                nodeMessage = this.producerQueue.poll(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (nodeMessage == null) continue;
            NodeMessage.CATEGORY_MESSAGE.debug("BH.executeBatch(): received message: " + nodeMessage);
            if (nodeMessage.getMessageType() != 41) {
                object = new XDBServerException(ErrorMessageRepository.UNEXPECTED_MESSAGE_RECIEVED + "(" + nodeMessage.getMessageType() + " , " + 41 + " )", 0, ErrorMessageRepository.UNEXPECTED_MESSAGE_RECIEVED_CODE);
                logger.throwing((Throwable)object);
                throw object;
            }
            messageMonitor.register(nodeMessage);
            if (bl2) continue;
            object = nodeMessage.getBatchResult();
            List<Integer> list = this.mappingTables.get(nodeMessage.getSourceNodeID());
            for (int i = 0; i < ((Object)object).length; ++i) {
                Object object2 = object[i];
                if (bl && object2 == -3) {
                    bl2 = true;
                    continue block5;
                }
                int n = list.get(i);
                if (nArray[n] == -2) {
                    nArray[n] = (int)object2;
                    continue;
                }
                if (nArray[n] == -3) {
                    if (object2 == -3) continue;
                    bl2 = true;
                    continue block5;
                }
                if (object2 == -3) {
                    bl2 = true;
                    continue block5;
                }
                if (object2 == -2) continue;
                int n2 = n;
                nArray[n2] = nArray[n2] + object2;
            }
        } while (messageMonitor.checkMessages() == null);
        if (bl2) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != -2) continue;
                nArray[i] = -3;
            }
        }
        int[] nArray2 = nArray;
        return nArray2;
    }

    public void clearBatch() {
        this.initBatch();
    }
}

