/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.constraintchecker;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.constraintchecker.AbstractConstraintChecker;
import com.edb.gridsql.engine.IExecutable;
import com.edb.gridsql.engine.XDBSessionContext;
import com.edb.gridsql.metadata.SysColumn;
import com.edb.gridsql.metadata.SysIndex;
import com.edb.gridsql.metadata.SysTable;
import com.edb.gridsql.parser.Parser;
import com.edb.gridsql.parser.SqlSelect;
import com.edb.gridsql.parser.Tuple;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertPrimaryKeyChecker
extends AbstractConstraintChecker {
    private static final XLogger logger = XLogger.getLogger(InsertPrimaryKeyChecker.class);
    private static final String TABLE_ALIAS1 = "t1";
    private static final String TABLE_ALIAS2 = "t2";
    private Tuple tuple;

    public InsertPrimaryKeyChecker(SysTable sysTable, Tuple tuple, XDBSessionContext xDBSessionContext) {
        super(sysTable, xDBSessionContext);
        this.tuple = tuple;
    }

    @Override
    protected Map<IExecutable, AbstractConstraintChecker.ViolationCriteria> prepareConstraint(Object object) throws Exception {
        AbstractConstraintChecker.ViolationCriteria violationCriteria = new AbstractConstraintChecker.ViolationCriteria();
        violationCriteria.violationType = 2;
        violationCriteria.message = object.toString();
        HashMap<IExecutable, AbstractConstraintChecker.ViolationCriteria> hashMap = new HashMap<IExecutable, AbstractConstraintChecker.ViolationCriteria>();
        StringBuffer stringBuffer = new StringBuffer("select 1 from ");
        stringBuffer.append(this.targetTable.getTableName()).append(" ").append(TABLE_ALIAS1);
        if (this.tuple == null) {
            stringBuffer.append(", ").append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS2);
        }
        stringBuffer.append(" WHERE ");
        StringBuffer stringBuffer2 = new StringBuffer();
        for (SysColumn object22 : ((SysIndex)object).getKeyColumns()) {
            stringBuffer2.append(TABLE_ALIAS1).append(".").append(object22.getColName()).append("=");
            if (this.tuple == null) {
                stringBuffer2.append(TABLE_ALIAS2).append(".").append(object22.getColName());
            } else {
                stringBuffer2.append(this.tuple.getValue(object22));
            }
            stringBuffer2.append(" and ");
        }
        stringBuffer.append(stringBuffer2);
        stringBuffer.setLength(stringBuffer.length() - 5);
        Object object3 = new Parser(this.client);
        ((Parser)object3).parseStatement(stringBuffer.toString());
        SqlSelect sqlSelect = (SqlSelect)((Parser)object3).getSqlObject();
        sqlSelect.addSkipPermissionCheck(this.targetTable.getTableName());
        sqlSelect.prepare();
        hashMap.put(sqlSelect, violationCriteria);
        if (this.tuple == null) {
            StringBuffer stringBuffer3 = new StringBuffer("select 1 from ");
            stringBuffer3.append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS1);
            stringBuffer3.append(", ").append(this.tempTable.getTableName()).append(" ").append(TABLE_ALIAS2);
            stringBuffer3.append(" WHERE ").append(stringBuffer2);
            stringBuffer3.append(TABLE_ALIAS1).append(".").append("Engine.XDROWID_NAME").append("<");
            stringBuffer3.append(TABLE_ALIAS2).append(".").append("Engine.XDROWID_NAME");
            object3 = new Parser(this.client);
            ((Parser)object3).parseStatement(stringBuffer3.toString());
            SqlSelect sqlSelect2 = (SqlSelect)((Parser)object3).getSqlObject();
            sqlSelect2.prepare();
            hashMap.put(sqlSelect2, violationCriteria);
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<SysColumn> scanConstraints(Collection<SysColumn> collection, Collection collection2) {
        HashSet<SysColumn> hashSet = new HashSet<SysColumn>();
        Vector<SysIndex> vector = this.targetTable.getAllUniqueAndPrimarySysIndexes();
        for (SysIndex sysIndex : vector) {
            if (!sysIndex.isDistributed) continue;
            collection2.add(sysIndex);
            for (SysColumn sysColumn : sysIndex.getKeyColumns()) {
                if (collection.contains(sysColumn)) continue;
                hashSet.add(sysColumn);
            }
        }
        HashSet<SysColumn> hashSet2 = hashSet;
        return hashSet2;
    }
}

