/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication.message;

import com.edb.gridsql.communication.message.NodeMessage;
import java.util.Arrays;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataRowsMessage
extends NodeMessage {
    private static final long serialVersionUID = 1422470324462405896L;
    private long dataSeqNo;
    private String[] rowData = null;
    private int rowCount;
    private int rowSize;
    private boolean autocommit = false;

    public DataRowsMessage() {
    }

    protected DataRowsMessage(int n) {
        super(n);
    }

    @Override
    public int addRowData(String string) {
        if (this.rowData == null) {
            this.rowData = new String[1000];
        }
        this.rowData[this.rowCount] = string;
        this.rowSize += string == null ? 0 : string.length();
        return this.rowCount++;
    }

    @Override
    public String[] getRowData() {
        if (this.rowData == null) {
            return null;
        }
        String[] stringArray = new String[this.rowCount];
        System.arraycopy(this.rowData, 0, stringArray, 0, this.rowCount);
        return stringArray;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean canAddRows() {
        return this.rowCount < 1000 && this.rowSize < 35000;
    }

    @Override
    public void setDataSeqNo(long l) {
        this.dataSeqNo = l;
    }

    @Override
    public long getDataSeqNo() {
        return this.dataSeqNo;
    }

    @Override
    public void setTempTables(Collection<String> collection) {
        this.rowData = collection == null ? null : collection.toArray(new String[collection.size()]);
    }

    public Collection getTempTables() {
        return this.rowData == null ? null : Arrays.asList(this.rowData);
    }

    @Override
    public boolean getAutocommit() {
        return this.autocommit;
    }

    @Override
    public void setAutocommit(boolean bl) {
        this.autocommit = bl;
    }

    @Override
    public Object clone() {
        DataRowsMessage dataRowsMessage = (DataRowsMessage)super.clone();
        if (this.rowData != null) {
            dataRowsMessage.rowData = new String[this.rowData.length];
            System.arraycopy(this.rowData, 0, dataRowsMessage.rowData, 0, this.rowData.length);
        }
        return dataRowsMessage;
    }
}

