/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.AbstractConnector;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.message.NodeMessage;
import java.util.concurrent.BlockingQueue;

public abstract class ClusteredConnector
extends AbstractConnector {
    private static final XLogger logger = XLogger.getLogger(ClusteredConnector.class);
    private final AbstractConnector[] connectors;
    private int lastIndex = 0;

    public ClusteredConnector(int n, int n2) {
        this.connectors = new AbstractConnector[n2];
        for (int i = 0; i < n2; ++i) {
            this.connectors[i] = this.createConnector(n, i);
        }
    }

    protected abstract AbstractConnector createConnector(int var1, int var2);

    public void start() {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].start();
        }
    }

    public void destroy() {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].destroy();
        }
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractConnector pickConnector() {
        if (this.connectors.length == 1) {
            return this.connectors[0];
        }
        int n = Integer.MAX_VALUE;
        int n2 = this.lastIndex + 1;
        boolean bl = n2 >= this.connectors.length;
        if (bl) {
            n2 = 0;
        }
        int n3 = n2;
        while (bl == n3 <= this.lastIndex) {
            int n4;
            BlockingQueue<NodeMessage> blockingQueue = this.connectors[n3].outQueue;
            synchronized (blockingQueue) {
                n4 = this.connectors[n3].outQueue.size();
            }
            if (n4 < n) {
                n = n4;
                n2 = n3;
            }
            if (n4 == 0) break;
            bl = ++n3 >= this.connectors.length;
            n3 = bl ? 0 : n3;
        }
        this.lastIndex = n2;
        return this.connectors[n2];
    }

    public void enqueueMessage(NodeMessage nodeMessage) {
        this.pickConnector().enqueueMessage(nodeMessage);
    }

    public void addMessageListener(IMessageListener iMessageListener) {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].addMessageListener(iMessageListener);
        }
    }

    public void removeMessageListener(IMessageListener iMessageListener) {
        for (int i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].removeMessageListener(iMessageListener);
        }
    }
}

