/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.communication;

import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.IMessageListener;
import com.edb.gridsql.communication.message.NodeMessage;
import com.edb.gridsql.exception.XDBBaseException;
import com.edb.gridsql.exception.XDBWrappedException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public abstract class AbstractConnector
implements Runnable {
    private static final XLogger logger = XLogger.getLogger(AbstractConnector.class);
    private Collection<IMessageListener> messageListeners;
    protected BlockingQueue<NodeMessage> inQueue;
    protected BlockingQueue<NodeMessage> outQueue;
    private Collection<Thread> threads = new LinkedList<Thread>();
    private boolean destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractConnector() {
        this.messageListeners = new HashSet<IMessageListener>();
        this.inQueue = new LinkedBlockingQueue<NodeMessage>();
        this.outQueue = new LinkedBlockingQueue<NodeMessage>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IMessageListener iMessageListener) {
        Collection<IMessageListener> collection = this.messageListeners;
        synchronized (collection) {
            this.messageListeners.add(iMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(IMessageListener iMessageListener) {
        Collection<IMessageListener> collection = this.messageListeners;
        synchronized (collection) {
            this.messageListeners.remove(iMessageListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processMessage(NodeMessage nodeMessage) {
        IMessageListener[] iMessageListenerArray = null;
        Collection<IMessageListener> collection = this.messageListeners;
        synchronized (collection) {
            iMessageListenerArray = this.messageListeners.toArray(new IMessageListener[this.messageListeners.size()]);
        }
        boolean bl = false;
        for (int i = 0; i < iMessageListenerArray.length; ++i) {
            bl |= iMessageListenerArray[i].processMessage(nodeMessage);
        }
        if (!bl) {
            XLogger.getLogger("Server").warn("Message was not consumed: " + nodeMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMessage(NodeMessage nodeMessage) {
        this.outQueue.offer(nodeMessage);
    }

    protected synchronized void addWorkerThread(Runnable runnable) {
        if (!this.destroyed) {
            Thread thread = new Thread(runnable);
            thread.start();
            this.threads.add(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        this.destroyed = true;
        for (Thread thread : this.threads) {
            thread.interrupt();
        }
        this.threads.clear();
    }

    public void processIncomingMessage() throws InterruptedException {
        NodeMessage nodeMessage = this.inQueue.poll(5L, TimeUnit.SECONDS);
        if (nodeMessage != null) {
            this.processMessage(nodeMessage);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.processIncomingMessage();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Throwable throwable) {
                logger.catching(throwable);
                continue;
            }
            break;
        }
    }

    public abstract void start();

    protected abstract class AbstractReceivingThread
    implements Runnable {
        protected AbstractReceivingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block5: while (true) {
                var1_1 = null;
                try {
                    var1_1 = this.receive();
                }
                catch (InterruptedException var2_3) {
                    break;
                }
                catch (Exception var2_4) {
                    if (Thread.currentThread().isInterrupted()) break;
                    this.receiveFailed(var2_4);
                }
                if (var1_1 == null || var1_1.length <= 0) continue;
                var2_5 = 0;
                while (true) {
                    if (var2_5 < var1_1.length) ** break;
                    continue block5;
                    AbstractConnector.this.inQueue.offer(var1_1[var2_5]);
                    ++var2_5;
                }
                break;
            }
        }

        protected void receiveFailed(Exception exception) {
        }

        protected abstract NodeMessage[] receive() throws Exception;
    }

    protected abstract class AbstractSendingThread
    implements Runnable {
        protected AbstractSendingThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block6: while (true) {
                try {
                    while (true) {
                        NodeMessage nodeMessage = AbstractConnector.this.outQueue.poll(5L, TimeUnit.SECONDS);
                        try {
                            if (nodeMessage == null) continue block6;
                            NodeMessage.CATEGORY_MESSAGE.info("Sending message: " + nodeMessage);
                            this.send(nodeMessage);
                            continue block6;
                        }
                        catch (Exception exception) {
                            logger.catching(exception);
                            this.sendFailed(nodeMessage, exception);
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void sendFailed(NodeMessage nodeMessage, Exception exception) {
            while (nodeMessage.sendFailed() < 3) {
                try {
                    this.send(nodeMessage);
                    return;
                }
                catch (Exception exception2) {
                    logger.catching(exception2);
                }
            }
            XLogger.getLogger("Server").error("Can not deliver message, sending MSG_ABORT back to Agent");
            NodeMessage nodeMessage2 = NodeMessage.getNodeMessage(1);
            Integer n = nodeMessage.getTargetNodeID();
            nodeMessage2.setSourceNodeID(n == null ? -1 : n);
            nodeMessage2.setTargetNodeID(new Integer(nodeMessage.getSourceNodeID()));
            nodeMessage2.setSessionID(nodeMessage.getSessionID());
            nodeMessage2.setRequestId(nodeMessage.getRequestId());
            nodeMessage2.setCause(exception instanceof XDBBaseException ? (XDBBaseException)exception : new XDBWrappedException(nodeMessage.getSourceNodeID(), (Throwable)exception));
            AbstractConnector.this.processMessage(nodeMessage2);
        }

        protected abstract void send(NodeMessage var1) throws Exception;
    }
}

