/*
 * Decompiled with CFR 0.152.
 */
package com.edb.gridsql.server;

import com.edb.gridsql.common.util.Property;
import com.edb.gridsql.common.util.Props;
import com.edb.gridsql.common.util.XLogger;
import com.edb.gridsql.communication.CoordinatorAgent;
import com.edb.gridsql.metadata.MetaData;
import com.edb.gridsql.metadata.NodeDBConnectionInfo;
import com.edb.gridsql.protocol.ProtocolManager;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    private static final XLogger logger = XLogger.getLogger(Server.class);
    private int port;
    private ProtocolManager theManager;
    private ServerSocketChannel channel = null;
    private Selector selector = null;

    public Server() {
        CoordinatorAgent.getInstance().resetNodes(true);
    }

    public NodeDBConnectionInfo[] getNodeDBConnectionInfos(Collection<String> collection) {
        return MetaData.getMetaData().getNodeDBConnectionInfos(collection);
    }

    public void initDatabases(Collection<String> collection) {
        if (collection != null) {
            CoordinatorAgent coordinatorAgent = CoordinatorAgent.getInstance();
            for (String string : collection) {
                coordinatorAgent.initDatabase(string);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            block7: while (true) {
                if (this.selector.select() <= 0) {
                    continue;
                }
                var1_1 = this.selector.selectedKeys();
                var2_4 = var1_1.iterator();
                while (true) {
                    if (var2_4.hasNext()) ** break;
                    continue block7;
                    var3_5 = var2_4.next();
                    var2_4.remove();
                    if (!var3_5.isAcceptable()) continue;
                    var4_6 = (ServerSocketChannel)var3_5.channel();
                    var5_7 = var4_6.accept();
                    try {
                        if (var5_7.isConnectionPending()) {
                            var5_7.finishConnect();
                        }
                        this.theManager.addClient(var5_7);
                    }
                    catch (Exception var6_8) {
                        this.theManager.rejectClient(var5_7, var6_8);
                        try {
                            var5_7.close();
                        }
                        catch (IOException var7_9) {
                            Server.logger.catching((Throwable)var7_9);
                        }
                    }
                }
                break;
            }
        }
        catch (ClosedChannelException var1_2) {
            return;
        }
        catch (IOException var1_3) {
            XLogger.getLogger((String)"Server").fatal((Object)var1_3.getMessage());
            System.exit(1);
            return;
        }
    }

    public void open() throws IOException {
        Serializable serializable;
        this.port = Property.getInt((String)"xdb.port", (int)6453);
        try {
            serializable = Class.forName(Props.XDB_PROTOCOL_HANDLER_CLASS);
            Method method = serializable.getMethod("getProtocolManager", new Class[0]);
            this.theManager = (ProtocolManager)method.invoke(null, new Object[0]);
        }
        catch (Exception exception) {
            throw new IOException("Can not initialize the Protocol Handler" + exception.getMessage());
        }
        this.selector = Selector.open();
        this.channel = ServerSocketChannel.open();
        this.channel.configureBlocking(false);
        serializable = new InetSocketAddress(this.port);
        this.channel.socket().bind((SocketAddress)serializable);
        this.channel.register(this.selector, 16);
    }
}

