/*
 * Decompiled with CFR 0.152.
 */
package com.edb.core.v3;

import com.edb.core.Oid;
import com.edb.core.PGStream;
import com.edb.core.ParameterList;
import com.edb.core.Utils;
import com.edb.core.v3.V3ParameterList;
import com.edb.util.GT;
import com.edb.util.PSQLException;
import com.edb.util.PSQLState;
import com.edb.util.StreamWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;

public class SimpleParameterList
implements V3ParameterList {
    boolean isCallable = false;
    private int outCount = 0;
    private final Object[] paramValues;
    private final int[] paramTypes;
    private final byte[][] encoded;
    private int return_type = -1;
    private static final Object NULL_OBJECT = new Object();
    private int[] paramDirections;
    private int[] outParameterTypes;

    SimpleParameterList(int paramCount) {
        this.paramValues = new Object[paramCount];
        this.paramTypes = new int[paramCount];
        this.encoded = new byte[paramCount][];
        this.paramDirections = new int[paramCount];
        this.outParameterTypes = new int[paramCount];
    }

    public int getParamDirection(int index) {
        return this.paramDirections[index - 1];
    }

    public void setAsOut(int index, int sqlType) throws SQLException {
        if (index < 1 || index > this.paramDirections.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramDirections.length)}), PSQLState.UNEXPECTED_ERROR);
        }
        if (this.paramDirections[--index] == 0) {
            this.paramDirections[index] = 2;
        } else if (this.paramDirections[index] == 1) {
            this.paramDirections[index] = 3;
        }
        this.outParameterTypes[index] = Oid.getOid(sqlType);
        this.paramTypes[index] = Oid.getOid(sqlType);
        ++this.outCount;
    }

    public int getOutCount() {
        return this.outCount;
    }

    private void bind(int index, Object value, int oid) throws SQLException {
        if (index < 1 || index > this.paramValues.length) {
            throw new PSQLException(GT.tr("The column index is out of range: {0}, number of columns: {1}.", new Object[]{new Integer(index), new Integer(this.paramValues.length)}), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.encoded[--index] = null;
        this.paramValues[index] = value;
        if (oid != 0 || this.paramTypes[index] == 0) {
            this.paramTypes[index] = oid;
        }
        if (this.paramDirections[index] == 0) {
            this.paramDirections[index] = 1;
        } else if (this.paramDirections[index] == 2) {
            this.paramDirections[index] = 3;
        }
    }

    public int getParameterCount() {
        return this.paramValues.length;
    }

    public void setIntParameter(int index, int value) throws SQLException {
        byte[] data = new byte[4];
        data[3] = (byte)value;
        data[2] = (byte)(value >> 8);
        data[1] = (byte)(value >> 16);
        data[0] = (byte)(value >> 24);
        this.bind(index, data, 23);
    }

    public void setLiteralParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    public void setStringParameter(int index, String value, int oid) throws SQLException {
        this.bind(index, value, oid);
    }

    public void setBytea(int index, byte[] data, int offset, int length) throws SQLException {
        this.bind(index, new StreamWrapper(data, offset, length), 17);
    }

    public void setBytea(int index, InputStream stream, int length) throws SQLException {
        this.bind(index, new StreamWrapper(stream, length), 17);
    }

    public void setNull(int index, int oid) throws SQLException {
        this.bind(index, NULL_OBJECT, oid);
    }

    public String toString(int index) {
        if (this.paramValues[--index] == null) {
            return "?";
        }
        if (this.paramValues[index] == NULL_OBJECT) {
            return "NULL";
        }
        return this.paramValues[index].toString();
    }

    boolean hasUnresolvedTypes() {
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (this.paramTypes[i] != 0) continue;
            return true;
        }
        return false;
    }

    void setResolvedType(int index, int oid) {
        if (this.paramTypes[index - 1] == 0) {
            this.paramTypes[index - 1] = oid;
        } else if (this.paramTypes[index - 1] != oid) {
            throw new IllegalArgumentException("Can't change resolved type for param: " + index + " from " + this.paramTypes[index] + " to " + oid);
        }
    }

    public void checkAllParametersSet() throws SQLException {
        if (!this.isCallable) {
            for (int i = 0; i < this.paramTypes.length; ++i) {
                if (this.paramValues[i] != null) continue;
                throw new PSQLException(GT.tr("No value specified for parameter {0}.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        } else {
            for (int i = 0; i < this.paramDirections.length; ++i) {
                if (this.paramDirections[i] != 0) continue;
                throw new PSQLException(GT.tr("No value specified for parameter {0} nor registered as out parameter.", new Integer(i + 1)), PSQLState.INVALID_PARAMETER_VALUE);
            }
        }
    }

    private static void streamBytea(PGStream pgStream, StreamWrapper wrapper) throws IOException {
        byte[] rawData = wrapper.getBytes();
        if (rawData != null) {
            pgStream.Send(rawData, wrapper.getOffset(), wrapper.getLength());
            return;
        }
        pgStream.SendStream(wrapper.getStream(), wrapper.getLength());
    }

    public int[] getTypeOIDs() {
        return this.paramTypes;
    }

    int getTypeOID(int index) {
        return this.paramTypes[index - 1];
    }

    boolean isNull(int index) {
        return this.paramValues[index - 1] == NULL_OBJECT;
    }

    boolean isBinary(int index) {
        return this.paramValues[index - 1] instanceof StreamWrapper;
    }

    int getV3Length(int index) {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't getV3Length() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            return ((byte[])this.paramValues[index]).length;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            return ((StreamWrapper)this.paramValues[index]).getLength();
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8(this.paramValues[index].toString());
        }
        return this.encoded[index].length;
    }

    void writeV3Value(int index, PGStream pgStream) throws IOException {
        if (this.paramValues[--index] == NULL_OBJECT) {
            throw new IllegalArgumentException("can't writeV3Value() on a null parameter");
        }
        if (this.paramValues[index] instanceof byte[]) {
            pgStream.Send((byte[])this.paramValues[index]);
            return;
        }
        if (this.paramValues[index] instanceof StreamWrapper) {
            SimpleParameterList.streamBytea(pgStream, (StreamWrapper)this.paramValues[index]);
            return;
        }
        if (this.encoded[index] == null) {
            this.encoded[index] = Utils.encodeUTF8((String)this.paramValues[index]);
        }
        pgStream.Send(this.encoded[index]);
    }

    public ParameterList copy() {
        SimpleParameterList newCopy = new SimpleParameterList(this.paramValues.length);
        System.arraycopy(this.paramValues, 0, newCopy.paramValues, 0, this.paramValues.length);
        System.arraycopy(this.paramTypes, 0, newCopy.paramTypes, 0, this.paramTypes.length);
        System.arraycopy(this.paramDirections, 0, newCopy.paramDirections, 0, this.paramDirections.length);
        return newCopy;
    }

    public void clear() {
        Arrays.fill(this.paramValues, null);
        Arrays.fill(this.paramTypes, 0);
        Arrays.fill((Object[])this.encoded, null);
        Arrays.fill(this.paramDirections, 0);
    }

    public SimpleParameterList[] getSubparams() {
        return null;
    }

    public void fillNulls() throws SQLException {
        for (int i = 1; i <= this.getParameterCount(); ++i) {
            if (this.paramValues[i - 1] != null) continue;
            int dir = this.paramDirections[i - 1];
            this.setNull(i, this.outParameterTypes[i - 1]);
            this.paramDirections[i - 1] = dir;
        }
    }

    public void setReturnType(int type) {
        this.return_type = type;
    }

    public int getReturnType() {
        return this.return_type;
    }

    public void setIsCallable(boolean isCallable) {
        this.isCallable = isCallable;
    }
}

