<%
    /********************************************************/
    /*****  Item Information Page.                      *****/
    /*****  Show item images, descriptions, and a       *****/ 
    /*****  list box of items under the same category.  *****/
    /********************************************************/
%>

<% 
    /****************************************/
    /******* Variables Initialization *******/
    /****************************************/

    Item this_item = ItemBean.getItem(id, language);
    String item_name = this_item.getItemName();
    String item_des = this_item.getItemDes();
    String image1 = this_item.getItemImage1();
    String image2 = this_item.getItemImage2();
    int cat_id = this_item.getCatID();
    double item_price = this_item.getItemPrice();

    /*** Get list of items under the same category. ***/
    ItemBean.refreshList(cat_id, language); 
    int num_of_row = ItemBean.getListSize();

    String order_servlet = new String(Util.getServletRoot() + 
                               "/com.kplab.webeasy.OrderServlet");
%>

<script language="JavaScript">
<!--
    function changePage(obj) 
    {
      i = obj.selectedIndex;
      {
        window.parent.location = obj.options[i].value;
      }
    }
// -->
</script>


<table border="0" width="100%" cellspacing="5" cellpadding="0">
  <tr>
    <td valign="top" align="left" colspan="3">
      <font size="4" face="Arial"><strong><%= item_name %></strong></font>
    </td>
  </tr>


<%
      /*******************************************/
      /*** Other items under the same category ***/
      /*******************************************/
%>
  <tr>
    <td valign="top" align="left" nowrap><b>Other items:&nbsp;</b></td>
    <td valign="top" align="left" width="2000" colspan="2">
      <form enctype="application/x-www-form-urlencoded" name="URLGo">
      <select name="item" onChange="changePage(this.form.item)" size="1">
          <option selected><%= item_name %></option>
<%
    for (int i=0; i<num_of_row; i++)
    {
      Item other_item = ItemBean.getItemAt(i); 
      String name = other_item.getItemName();
      int item_id = other_item.getItemID();
      String link = new String("Product.jsp?Type=ITEM&ID=" + Integer.toString(item_id));
      if (item_id != id)
      {
%>
          <option value="<%= link %>"><%= name %></option>
<%
      }
    }
%>
      </select>
      </form>
    </td>
  </tr>


<%
      /***************************************/
      /************* Item Images *************/
      /***************************************/

      if (! Util.isMissing(image1) || ! Util.isMissing(image2)) 
      {
%>
  <tr>
    <td valign="top" align="left" colspan="3">
<%
        if (! Util.isMissing(image1)) {
%>
        <img src="../pimages/<%= image1 %>" width="150" height="150" hspace="0">
<%
        }
        if (! Util.isMissing(image2)) {
%>
        <img src="../pimages/<%= image2 %>" width="150" height="150" hspace="0">
<%
        }
%>
    </td>
  </tr>
  <tr><td valign="top" align="left" colspan="3">&nbsp;</td></tr>
<%
      }
%>

<%
      /***************************************/
      /********** Item Description ***********/
      /***************************************/

      if (! Util.isMissing(item_des)) 
      {
%>
  <tr>
    <td valign="top" align="left" colspan="3">
      <table border="0" width="100%" cellspacing="0" cellpadding="0">
        <tr>
          <td valign="top" align="left">
            <p><%= item_des %></p>
          </td>
        </tr>
      </table>
    </td>
  </tr>

  <tr><td valign="top" align="left" colspan="3">&nbsp;</td></tr>
<%
      }
%>


<%
      /***************************************/
      /********** Item Unit Price ************/
      /***************************************/

      if (item_price > 0)
      {
%>
  <form action="<%= order_servlet %>" method="post">
  <tr>
    <td valign="top" align="left" nowrap><b>Price:&nbsp;</b></td>
    <td valign="top" align="left" nowrap>US$<%= Double.toString(item_price) %></td>
    <td valign="top" align="left" width="2000">
      <input type="hidden" name="Action" value="ADD">
      <input type="hidden" name="ItemID" value="<%= Integer.toString(id) %>">
      <input type="hidden" name="Qty" value="1">
      <input type="submit" value="Buy !">
    </td>
  </tr>
<%
      }
%>



</table>
