<%
    /*******************************************/
    /*****  Check if user has logged-on.   *****/
    /*****  If not, forward to logon page. *****/
    /*******************************************/
%>

<jsp:useBean id="MemberBean" scope="session" class="com.kplab.webeasy.MemberBean" />

<%
    /* Check if the user has a valid cookie, if so, auto-logon. */
    if (session.getValue("UserID") == null) 
    {
      Cookie cookies[];
      cookies = request.getCookies();
      if (cookies != null)
      {
        for (int i=0; i<cookies.length; i++)
        {
          if (cookies[i].getName().equals("com.kplab.webeasy"))
          {
            String userid = cookies[i].getValue();
            Member user   = MemberBean.getMember(userid);
            int language  = user.getLanguage();
            if (language == 0)  continue;   /* User-id not found, search next cookie */
            session.putValue("Language", Integer.toString(language));
            session.putValue("FirstName", user.getFirstName());
            session.putValue("UserID", userid);
            break;
          }
        }
      }
    }


    /* No valid cookie found, save attempted URI and then forward to logon page. */
    if (session.getValue("UserID") == null) 
    {
      String uri = request.getRequestURI();
      String query = request.getQueryString();
      String checkedURI = null;
      if (query == null)
           checkedURI = new String(uri);
      else checkedURI = new String(uri + "?" + query);
      session.putValue("CheckedURI", checkedURI);
      Util.gotoPage(Util.getMemberPage(), "Status=LOGON", request, response);
      return;
    }


    /* Save cookie to user's browser. */
    if (request.isRequestedSessionIdFromCookie())
    {
      Cookie c = new Cookie("com.kplab.webeasy", (String) session.getValue("UserID"));
      c.setMaxAge(90*24*60*60);
      response.addCookie(c);
    }
%> 
