package com.kplab.webeasy;

import java.io.*;
import java.sql.*;


/**********************************************************************/
/*** To customize WebEasy for your site, do the followings:         ***/
/***                                                                ***/
/*** 1. Change the DB_MODE to that of your DBMS.                    ***/
/***    If your DBMS is not included in this file,                  ***/
/***    you can modify the getConnection() method to include it.    ***/
/***                                                                ***/
/*** 2. Change DB_NAME, DBUSER_NAME and DBUSER_PASS to your         ***/
/***    database name, username which can access the database,      ***/
/***    and the corresponding user password.                        ***/
/***                                                                ***/
/*** 3. Change PHYSICAL_ROOT to the physical path where you         ***/
/***    place the WebEasy directory, e.g. "c:/JRun/server/webeasy"  ***/
/***    or "/home/httpd/html/webeasy".                              ***/
/***                                                                ***/
/*** 4. Change JSP_ROOT to the URI path where user can access the   ***/
/***    WebEasy jsp and html, e.g. "/webeasy".                      ***/ 
/***                                                                ***/
/*** 5. Change SERVLET_ROOT to the URI path where user can access   ***/
/***    the WebEasy servlets, e.g. "/webeasy/servlets".             ***/  
/***                                                                ***/
/*** 6. Change ROLLBACK_SUPPORT to "false" if you are using MySQL   ***/
/***    or any other DBMS not supporting transaction rollback.      ***/
/***                                                                ***/
/*** 7. Change SSL_SUPPORT to "true" if your web server support     ***/
/***    SSL. Remain "false" if otherwise.                           ***/
/***                                                                ***/
/*** 8. Compile this class by "javac Util2.java".                   ***/
/**********************************************************************/


public class Util2
{

  /* Information related to the database */
  static final private int    DB_MODE=1,
                              MODE_ODBC=1,          /* for ODBC       */
                              MODE_DB2=2,           /* for DB2        */
                              MODE_ORACLE=3,        /* for Oracle     */
                              MODE_POSTGRESQL=4,    /* for PostgreSQL */
                              MODE_MYSQL_MM=5;      /* for MySQL MM   */

  static final private String DB_NAME="WEBEASY",    // "webeasy" for PostgreSQL
                              DBUSER_NAME="username",
                              DBUSER_PASS="password";

  /* Physical path */
  static final private String PHYSICAL_ROOT="c:/jrun/servers/default/kplab/webeasy";
//  static final private String PHYSICAL_ROOT="/home/httpd/html/kplab/webeasy";
  /* URI path */
  static final private String JSP_ROOT="/kplab/webeasy";
  static final private String SERVLET_ROOT="/kplab/servlet";

  /* Transaction support ("false" for MySQL) */
  static final private boolean ROLLBACK_SUPPORT=true;
  /* SSL support */
  static final private boolean SSL_SUPPORT=false;


  /******************************************************/
  /************** Database Connection *******************/
  /******************************************************/

  public static Connection getConnection()
  {
    Connection con=null;
    try { 
      int    dbMode = DB_MODE;
      String dbName = DB_NAME;
      String dbUserName = DBUSER_NAME;
      String dbUserPass = DBUSER_PASS;

      switch (dbMode)
      {
        case MODE_ODBC:
          Class.forName("sun.jdbc.odbc.JdbcOdbcDriver"); 
          con = DriverManager.getConnection("jdbc:odbc:" + dbName,
                dbUserName, dbUserPass);
          break;

        case MODE_DB2:
          Class.forName("COM.ibm.db2.jdbc.app.DB2Driver"); 
          con = DriverManager.getConnection("jdbc:db2:" + dbName,
                dbUserName, dbUserPass);
          break;

        case MODE_ORACLE:
          Class.forName("oracle.jdbc.driver.OracleDriver"); 
          con = DriverManager.getConnection("jdbc:oracle:oci8:@" + dbName,
                dbUserName, dbUserPass);
          break;

        case MODE_POSTGRESQL:
          Class.forName("postgresql.Driver"); 
          con = DriverManager.getConnection("jdbc:postgresql:" + dbName,
                dbUserName, dbUserPass);
          break;

        case MODE_MYSQL_MM:
          Class.forName("org.gjt.mm.mysql.Driver"); 
          con = DriverManager.getConnection("jdbc:mysql://localhost/" + dbName,
                dbUserName, dbUserPass);
          break;

        default: con=null; break;
      }
    }
    catch(Exception e) {
//      Util.log("JDBC connection error. " + e.toString());
      return null;
    }
    return con;
  }



  /***************************************************/
  /************** Get Constants **********************/
  /***************************************************/

  public static String getPhysicalRoot()
  {
    return (PHYSICAL_ROOT);
  }
  public static String getJspRoot()
  {
    return (JSP_ROOT);
  }
  public static String getServletRoot()
  {
    return (SERVLET_ROOT);
  }

  public static boolean getRollBackSupport()
  {
    return (ROLLBACK_SUPPORT);
  }
  public static boolean getSSLSupport()
  {
    return (SSL_SUPPORT);
  }

}
