#ifndef bcalg_h_
#define bcalg_h_ 0

#ifndef CTL_CODE

#define FILE_DEVICE_DISK   0x00000007
#define IOCTL_DISK_BASE    FILE_DEVICE_DISK
#define METHOD_BUFFERED    0
#define METHOD_IN_DIRECT   1
#define FILE_ANY_ACCESS    0

#define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
    ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
)

#endif

// old functions

#ifndef __BCSTATUS
#define	__BCSTATUS

#define BCSTATUS_SUCCESS                 0

#define BCSTATUS_ERR_NOSYSTEM_RESOURCES  1

#define	BCSTATUS_ERR_ALREADYMOUNTED	     2
#define BCSTATUS_ERR_CONNECTALGORITHM    3
#define BCSTATUS_ERR_CREATEDEVICELINK    4
#define BCSTATUS_ERR_INVALIDDISKNUMBER   5
#define BCSTATUS_ERR_DISK_IS_NOT_MOUNTED 6

#define BCSTATUS_ERR_INVALIDALGORITHM    7
#define BCSTATUS_ERR_CANTOPENCONTAINER   8

#define BCSTATUS_ERR_INVALID_KEY         0x10
#define BCSTATUS_ERR_INVALID_KEY_LENGTH  0x11

#endif


#include "bcalgins.h"

//
//  bc_ioctl.h - Control Codes for interface between Control Panel and drivers
//

#ifndef __BCIOCTL
#define __BCIOCTL

#define UNUSED_ALGORITHM_ID 0xff

// MAX_KEY_LENGTH value in bites
#define MAX_KEY_LENGTH      512

/* Pool of random bytes */
#define POOL_SIZE_BYTES		512






typedef struct _BUFFER_HEADER { __int64   Signature;  // input: "LOCOS97",00 ; output: "LS06CXX",00
                                UCHAR     Status;
                              } BUFFER_HEADER, *PBUFFER_HEADER;

/*******************************************************************************
***************** IOCTLs for BestCrypt Disk Driver Service *********************
********************************************************************************/

// Get version command & structure definition

#define IOCTL_PRIVATE_GET_VERSION_INFO \
              CTL_CODE(IOCTL_DISK_BASE, 0x800, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _VERSION_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR   Status;
                                  UCHAR   Major_version;
                                  UCHAR   Minor_version;
								} VERSION_BUFFER, *PVERSION_BUFFER;




//
//  Control codes for the "program -> algorithm driver" interface
//
//  This control codes are private for this driver, hence,
//  functions number must be >= 0x800
//
//  Functions numbers for Algorithm Driver are 0x810 - 0x8FF
//

// Expand key, save it, and return a handle for the given key

#define IOCTL_PRIVATE_CREATE_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x810, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _CREATEKEY_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                    UCHAR       Status;
                                    UCHAR       Dummy[3];
                                    DWORD       KeyLength;
                                    KEY_HANDLE  KeyHandle;
                                    UCHAR       Key[MAX_KEY_LENGTH / 8];
                                    UCHAR       Pool[POOL_SIZE_BYTES];
                                  } CREATEKEY_BUFFER, *PCREATEKEY_BUFFER;


// Test if the key for the given key handle exists

#define IOCTL_PRIVATE_TEST_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x811, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _TESTKEY_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR        Status;
                                  UCHAR        IsValid;
                                  UCHAR        Dummy[2];
                                  KEY_HANDLE  KeyHandle;
								} TESTKEY_BUFFER, *PTESTKEY_BUFFER;


// Free Key Handle command: uses a TESTKEY_BUFFER structure definition

#define IOCTL_PRIVATE_FREE_KEY_HANDLE \
              CTL_CODE(IOCTL_DISK_BASE, 0x812, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Encrypt command & structure definition

#define IOCTL_PRIVATE_ENCRYPT \
              CTL_CODE(IOCTL_DISK_BASE, 0x814, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

// Buffer for data is in the Output buffer of DeviceIoControl

typedef struct  _ENCRYPT_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR       Status;
                                  UCHAR       Dummy[3];
                                  KEY_HANDLE  KeyHandle;
                                  UCHAR       IVector[8];
                                  DWORD       Length;       // in bytes
								} ENCRYPT_BUFFER, *PENCRYPT_BUFFER;

// Decrypt command definition

#define IOCTL_PRIVATE_DECRYPT \
              CTL_CODE(IOCTL_DISK_BASE, 0x815, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


// Get function address from Algorithm Driver
#define IOCTL_PRIVATE_GETFUNCTIONS \
              CTL_CODE(IOCTL_DISK_BASE, 0x816, METHOD_IN_DIRECT, FILE_ANY_ACCESS)

typedef struct  _GETFUNC_BUFFER { char        Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR       Status;
                                  UCHAR       Dummy[3];
                                  PVOID       FuncTestKey;
                                  PVOID       FuncFreeKey;
                                  PVOID       FuncEncrypt;
                                  PVOID       FuncDecrypt;
								} GETFUNC_BUFFER, *PGETFUNC_BUFFER;



// Check, whether the algorithm driver supports 64-bit sector number as Initial Vector 

#define IOCTL_PRIVATE_SUPPORTS_SYNCRO_64BITS \
              CTL_CODE(IOCTL_DISK_BASE, 0x818, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _SYNCRO64BITS_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                       UCHAR  Status;
                                       UCHAR  Dummy[3];
                                       BOOL   SupportStatus;
} SYNCRO64BITS_BUFFER, *PSYNCRO64BITS_BUFFER;




// Get version command & structure definition

#define IOCTL_PRIVATE_GET_INFO \
              CTL_CODE(IOCTL_DISK_BASE, 0x817, METHOD_IN_DIRECT, FILE_ANY_ACCESS)


typedef struct  _INFO_BUFFER { char   Signature[8];	// input: "LOCOS97",00 ; output: "LS06CXX",00
                                  UCHAR   Status;
                                  UCHAR   DisplayName[32];
                                  UCHAR   Dummy[3];
                                  DWORD   AlgorithmID;
                                  DWORD   KeyLength;
} INFO_BUFFER, *PINFO_BUFFER;



#endif


/*
#define DRIVER_MAJOR_VERSION 1
#define DRIVER_MINOR_VERSION 4
*/

#endif
