CREATE TABLE [platform_users] (
  [ID] int DEFAULT NULL,
  [username] nvarchar(60) NOT NULL,
  CONSTRAINT [PriKey_platform_users] PRIMARY KEY ([username])
);

INSERT INTO [platform_users] ([username]) VALUES ('Admin');

CREATE TABLE [platform_groups] (
  [ID] int DEFAULT NULL,
  [groupname] nvarchar(60) NOT NULL,
  CONSTRAINT [PriKey_platform_groups] PRIMARY KEY ([groupname])
);

CREATE TABLE [col_files_folders] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [parent] int DEFAULT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_files_folders] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_folders_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_folders_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_folders_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_files_types] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_col_files_types] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_types_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_files_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [folder] int NOT NULL,
  [type] int DEFAULT NULL,
  [deleted] smallint DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [filenum] nvarchar(255) DEFAULT NULL,
  [status] smallint DEFAULT '0',
  [keywords] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [versioncount] int DEFAULT '0',
  CONSTRAINT [PriKey_col_files_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_files_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_files_folder] FOREIGN KEY ([folder]) REFERENCES [col_files_folders] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_files_type] FOREIGN KEY ([type]) REFERENCES [col_files_types] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_files_items] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [file] int NOT NULL,
  [filename] nvarchar(255) DEFAULT NULL,
  [version] nvarchar(255) DEFAULT NULL,
  [mimetype] nvarchar(255) DEFAULT NULL,
  [size] int DEFAULT '0',
  [comment] nvarchar(max) DEFAULT NULL,
  [binfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_col_files_items] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_items_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_items_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_files_journal] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [file] int NOT NULL,
  [date] int DEFAULT '0',
  [subject] nvarchar(255) DEFAULT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_files_journal] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_journal_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_journal_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_files_shortcuts] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [creationdate] int DEFAULT '0',
  [file] int NOT NULL,
  CONSTRAINT [PriKey_col_files_shortcuts] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_files_shortcuts_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_files_shortcuts_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_columns] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_col_forums_columns] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_columns_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_forums] (
  [ID] int identity NOT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [column] int DEFAULT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [lastentry] int DEFAULT '0',
  CONSTRAINT [PriKey_col_forums_forums] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_forums_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_forums_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_forums_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_forums_column] FOREIGN KEY ([column]) REFERENCES [col_forums_columns] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_topics] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [forum] int NOT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [lastentry] int DEFAULT '0',
  CONSTRAINT [PriKey_col_forums_topics] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_topics_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_topics_forum] FOREIGN KEY ([forum]) REFERENCES [col_forums_forums] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_entries] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [topic] int NOT NULL,
  [flag] smallint DEFAULT '0',
  [text] nvarchar(max) DEFAULT NULL,
  [attachname] nvarchar(255) DEFAULT NULL,
  [attachbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_col_forums_entries] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_entries_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_entries_topic] FOREIGN KEY ([topic]) REFERENCES [col_forums_topics] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_notify] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [forum] int NOT NULL,
  CONSTRAINT [PriKey_col_forums_notify] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_notify_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_notify_forum] FOREIGN KEY ([forum]) REFERENCES [col_forums_forums] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_forums_view] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [forum] int NOT NULL,
  CONSTRAINT [PriKey_col_forums_view] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_forums_view_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_forums_view_forum] FOREIGN KEY ([forum]) REFERENCES [col_forums_forums] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_messages_folders] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [parent] int DEFAULT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_messages_folders] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_messages_folders_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_folders_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_folders_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_messages_accounts] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [activity] smallint DEFAULT '0',
  [default] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [email] nvarchar(255) DEFAULT NULL,
  [server] nvarchar(255) DEFAULT NULL,
  [port] smallint DEFAULT '0',
  [protocol] nvarchar(255) DEFAULT NULL,
  [username] nvarchar(255) DEFAULT NULL,
  [password] nvarchar(255) DEFAULT NULL,
  [movetoprimary] smallint DEFAULT '0',
  [moveto] int DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [leavemsg] smallint DEFAULT '0',
  CONSTRAINT [PriKey_col_messages_accounts] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_messages_accounts_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_accounts_moveto] FOREIGN KEY ([moveto]) REFERENCES [col_messages_folders] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_messages_messages] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [account] int DEFAULT NULL,
  [primaryfolder] smallint DEFAULT '0',
  [folder] int DEFAULT NULL,
  [flag] smallint DEFAULT '0',
  [date] int DEFAULT '0',
  [subject] nvarchar(255) DEFAULT NULL,
  [sender] nvarchar(255) DEFAULT NULL,
  [sender_name] nvarchar(255) DEFAULT NULL,
  [to] nvarchar(255) DEFAULT NULL,
  [to_name] nvarchar(255) DEFAULT NULL,
  [cc] nvarchar(255) DEFAULT NULL,
  [bcc] nvarchar(255) DEFAULT NULL,
  [reply_to] nvarchar(255) DEFAULT NULL,
  [count_to] int DEFAULT '0',
  [contenttype] nvarchar(255) DEFAULT NULL,
  [binfile] nvarchar(32) DEFAULT NULL,
  [keywords] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_col_messages_messages] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_messages_messages_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_messages_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_messages_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_messages_account] FOREIGN KEY ([account]) REFERENCES [col_messages_accounts] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_messages_folder] FOREIGN KEY ([folder]) REFERENCES [col_messages_folders] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_messages_msglog] (
  [ID] int identity NOT NULL,
  [account] int NOT NULL,
  [uid] int DEFAULT '0',
  CONSTRAINT [PriKey_col_messages_msglog] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_messages_msglog_account] FOREIGN KEY ([account]) REFERENCES [col_messages_accounts] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_messages_templates] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [default] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_messages_templates] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_messages_templates_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_templates_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_messages_templates_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_news_channels] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [type] smallint DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [newsfeed] nvarchar(255) DEFAULT NULL,
  [link] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_news_channels] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_news_channels_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_channels_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_channels_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [col_news_newsitems] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [channel] int DEFAULT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [pubdate] int DEFAULT '0',
  [link] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_col_news_newsitems] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_news_newsitems_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_newsitems_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_newsitems_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_newsitems_channel] FOREIGN KEY ([channel]) REFERENCES [col_news_channels] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [col_news_view] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [channel] int NOT NULL,
  CONSTRAINT [PriKey_col_news_view] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_col_news_view_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_col_news_view_channel] FOREIGN KEY ([channel]) REFERENCES [col_news_channels] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_companies] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60)  DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [director] nvarchar(255) DEFAULT NULL,
  [traderegister] nvarchar(255) DEFAULT NULL,
  [taxcode] nvarchar(255) DEFAULT NULL,
  [address] nvarchar(255) DEFAULT NULL,
  [postalcode] nvarchar(255) DEFAULT NULL,
  [city] nvarchar(255) DEFAULT NULL,
  [region] nvarchar(255) DEFAULT NULL,
  [country] nvarchar(255) DEFAULT NULL,
  [phone] nvarchar(255) DEFAULT NULL,
  [phone2] nvarchar(255) DEFAULT NULL,
  [fax] nvarchar(255) DEFAULT NULL,
  [fax2] nvarchar(255) DEFAULT NULL,
  [email] nvarchar(255) DEFAULT NULL,
  [website] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_org_contacts_companies] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_companies_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_companies_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_companies_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_people] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [lastname] nvarchar(255) DEFAULT NULL,
  [firstname] nvarchar(255) DEFAULT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [company] nvarchar(255) DEFAULT NULL,
  [position] nvarchar(255) DEFAULT NULL,
  [workgroup] nvarchar(255) DEFAULT NULL,
  [address] nvarchar(255) DEFAULT NULL,
  [postalcode] nvarchar(255) DEFAULT NULL,
  [city] nvarchar(255) DEFAULT NULL,
  [region] nvarchar(255) DEFAULT NULL,
  [country] nvarchar(255) DEFAULT NULL,
  [phone] nvarchar(255) DEFAULT NULL,
  [phone2] nvarchar(255) DEFAULT NULL,
  [cell] nvarchar(255) DEFAULT NULL,
  [fax] nvarchar(255) DEFAULT NULL,
  [fax2] nvarchar(255) DEFAULT NULL,
  [pager] nvarchar(255) DEFAULT NULL,
  [iptel] nvarchar(255) DEFAULT NULL,
  [email] nvarchar(255) DEFAULT NULL,
  [usebirthdate] smallint DEFAULT '0',
  [birthdate] int DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  [picbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_org_contacts_people] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_people_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_customers_customers] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [customernum] nvarchar(255) DEFAULT NULL,
  [status] smallint DEFAULT '0',
  [risk] smallint DEFAULT '0',
  [dispatch] smallint DEFAULT '0',
  [payment] smallint DEFAULT '0',
  [prefcontact] smallint DEFAULT '0',
  [person] int DEFAULT NULL,
  [company] int DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [usebilling] smallint DEFAULT '0',
  [billingaddr] nvarchar(255) DEFAULT NULL,
  [billingpc] nvarchar(255) DEFAULT NULL,
  [billingcity] nvarchar(255) DEFAULT NULL,
  [billingcountry] nvarchar(255) DEFAULT NULL,
  [useshipping] smallint DEFAULT '0',
  [shippingaddr] nvarchar(255) DEFAULT NULL,
  [shippingpc] nvarchar(255) DEFAULT NULL,
  [shippingcity] nvarchar(255) DEFAULT NULL,
  [shippingcountry] nvarchar(255) DEFAULT NULL,
  [bank] nvarchar(255) DEFAULT NULL,
  [bankid] nvarchar(255) DEFAULT NULL,
  [account] nvarchar(255) DEFAULT NULL,
  [cctype] smallint DEFAULT '0',
  [ccnum] nvarchar(255) DEFAULT NULL,
  [ccvalid] nvarchar(5) DEFAULT NULL,
  [ccauth] nvarchar(3) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_customers_customers] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_customers_customers_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_customers_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_customers_person] FOREIGN KEY ([person]) REFERENCES [org_contacts_people] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_customers_company] FOREIGN KEY ([company]) REFERENCES [org_contacts_companies] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_deliveries] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [deliverynum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [date] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [discount] double precision DEFAULT '0',
  [netamount] double precision DEFAULT '0',
  [tax] double precision DEFAULT '0',
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_deliveries] PRIMARY KEY ([ID]),
  CONSTRAINT [ForKey_crm_billing_deliveries_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  /*
  CONSTRAINT [ForKey_crm_billing_deliveries_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_invoices] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [invoicenum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [date] int DEFAULT '0',
  [duedate] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [amountpayable] double precision DEFAULT '0',
  [payment] double precision DEFAULT '0',
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_invoices] PRIMARY KEY ([ID]),
  CONSTRAINT [ForKey_crm_billing_invoices_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  /*
  CONSTRAINT [ForKey_crm_billing_invoices_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_invoices_deliveries] (
  [ID] int identity NOT NULL,
  [invoice] int NOT NULL,
  [delivery] int NOT NULL,
  CONSTRAINT [PriKey_crm_billing_invoices_deliveries] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_invoices_deliveries_invoice] FOREIGN KEY ([invoice]) REFERENCES [crm_billing_invoices] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_invoices_deliveries_delivery] FOREIGN KEY ([delivery]) REFERENCES [crm_billing_deliveries] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_offers] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [quotationnum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [date] int DEFAULT '0',
  [duedate] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [discount] double precision DEFAULT '0',
  [netamount] double precision DEFAULT '0',
  [tax] double precision DEFAULT '0',
  [margin] double precision DEFAULT '0',
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_offers] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_offers_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_offers_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_orders] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [ordernum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [date] int DEFAULT '0',
  [duedate] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [discount] double precision DEFAULT '0',
  [netamount] double precision DEFAULT '0',
  [tax] double precision DEFAULT '0',
  [margin] double precision DEFAULT '0',
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_orders] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_orders_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_orders_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_payments] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [invoice] int NOT NULL,
  [date] int DEFAULT '0',
  [account] nvarchar(255) DEFAULT NULL,
  [reference] nvarchar(255) DEFAULT NULL,
  [amount] double precision DEFAULT '0',
  CONSTRAINT [PriKey_crm_billing_payments] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_payments_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_payments_invoice] FOREIGN KEY ([invoice]) REFERENCES [crm_billing_invoices] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_templates] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [type] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [inputbinfile] nvarchar(32) DEFAULT NULL,
  [outputbinfile] nvarchar(32) DEFAULT NULL,
  [pdfbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_templates] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_templates_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_printouts] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [type] smallint DEFAULT '0',
  [transaction] int NOT NULL,
  [transactionnum] nvarchar(255) DEFAULT NULL,
  [template] int DEFAULT NULL,
  [maildate] int DEFAULT '0',
  [databinfile] nvarchar(32) DEFAULT NULL,
  [pdfbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_printouts] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_printouts_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_printouts_template] FOREIGN KEY ([template]) REFERENCES [crm_billing_templates] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_billing_requests] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [requestnum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [date] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_billing_requests] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_billing_requests_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_billing_requests_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_campaigns_campaigns] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [datefrom] int DEFAULT '0',
  [dateto] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [media] smallint DEFAULT '0',
  [replyrate] smallint DEFAULT '0',
  [projectedeffort] double precision DEFAULT '0',
  [budget] double precision DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_campaigns_campaigns] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_campaigns_campaigns_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_campaigns_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_campaigns_addressees] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [campaign] int NOT NULL,
  [customer] int NOT NULL,
  [flag] smallint DEFAULT '0',
  CONSTRAINT [PriKey_crm_campaigns_addressees] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_campaigns_addressees_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_addressees_campaign] FOREIGN KEY ([campaign]) REFERENCES [crm_campaigns_campaigns] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_addressees_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_campaigns_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [campaign] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_crm_campaigns_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_campaigns_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_files_campaign] FOREIGN KEY ([campaign]) REFERENCES [crm_campaigns_campaigns] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_campaigns_records] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [campaign] int NOT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_campaigns_records] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_campaigns_records_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_records_campaign] FOREIGN KEY ([campaign]) REFERENCES [crm_campaigns_campaigns] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_tasks_tasks] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [parent] int DEFAULT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [duedate] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [progress] smallint DEFAULT '0',
  [priority] smallint DEFAULT '0',
  [projectedeffort] double precision DEFAULT '0',
  [actualeffort] double precision DEFAULT '0',
  [budget] double precision DEFAULT '0',
  [costs] double precision DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_tasks_tasks] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_tasks_tasks_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_tasks_tasks_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_tasks_tasks_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_tasks_tasks_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_campaigns_tasks] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [campaign] int NOT NULL,
  [task] int NOT NULL,
  CONSTRAINT [PriKey_crm_campaigns_tasks] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_campaigns_tasks_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_tasks_campaign] FOREIGN KEY ([campaign]) REFERENCES [crm_campaigns_campaigns] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_campaigns_tasks_task] FOREIGN KEY ([task]) REFERENCES [org_tasks_tasks] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_cases_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_cases_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_cases_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_cases_cases] (
  [ID] int identity NOT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [casenum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [status] smallint DEFAULT '0',
  [priority] smallint DEFAULT '0',
  [category] int DEFAULT NULL,
  [projectedeffort] double precision DEFAULT '0',
  [budget] double precision DEFAULT '0',
  [materialcosts] double precision DEFAULT '0',
  [message] int DEFAULT NULL,
  [databinfile] nvarchar(32) DEFAULT NULL,
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_cases_cases] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_cases_cases_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_cases_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_cases_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_cases_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_cases_category] FOREIGN KEY ([category]) REFERENCES [crm_cases_categories] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_cases_message] FOREIGN KEY ([message]) REFERENCES [col_messages_messages] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_cases_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [case] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_crm_cases_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_cases_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_files_case] FOREIGN KEY ([case]) REFERENCES [crm_cases_cases] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_cases_records] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [case] int NOT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_cases_records] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_cases_records_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_records_case] FOREIGN KEY ([case]) REFERENCES [crm_cases_cases] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_cases_tasks] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [case] int NOT NULL,
  [task] int NOT NULL,
  CONSTRAINT [PriKey_crm_cases_tasks] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_cases_tasks_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_tasks_case] FOREIGN KEY ([case]) REFERENCES [crm_cases_cases] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_cases_tasks_task] FOREIGN KEY ([task]) REFERENCES [org_tasks_tasks] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_contracts_classes] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [default] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [inputbinfile] nvarchar(32) DEFAULT NULL,
  [outputbinfile] nvarchar(32) DEFAULT NULL,
  [pdfbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_contracts_classes] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_contracts_classes_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_contracts_contracts] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [contractnum] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [class] int NOT NULL,
  [datefrom] int DEFAULT '0',
  [usedateto] smallint DEFAULT '0',
  [dateto] int DEFAULT '0',
  [usedatecancel] smallint DEFAULT '0',
  [datecancel] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [databinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_contracts_contracts] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_contracts_contracts_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_contracts_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_contracts_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_contracts_class] FOREIGN KEY ([class]) REFERENCES [crm_contracts_classes] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_contracts_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [contract] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_crm_contracts_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_contracts_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_files_contract] FOREIGN KEY ([contract]) REFERENCES [crm_contracts_contracts] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_contracts_records] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [contract] int NOT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_contracts_records] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_contracts_records_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_contracts_records_contract] FOREIGN KEY ([contract]) REFERENCES [crm_contracts_contracts] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_customers_groups] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_customers_groups] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_customers_groups_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_customers_customers_groups] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [customer] int NOT NULL,
  [group] int NOT NULL,
  CONSTRAINT [PriKey_crm_customers_customers_groups] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_customers_customers_groups_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_customers_groups_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_customers_groups_group] FOREIGN KEY ([group]) REFERENCES [crm_customers_groups] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_customers_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [customer] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_crm_customers_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_customers_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_files_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_customers_journal] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [customer] int NOT NULL,
  [date] int DEFAULT '0',
  [label] smallint DEFAULT '0',
  [contact] int DEFAULT NULL,
  [subject] nvarchar(255) DEFAULT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_customers_journal] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_customers_journal_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_journal_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_customers_journal_contact] FOREIGN KEY ([contact]) REFERENCES [org_contacts_people] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_opportunities_opportunities] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [customer] int DEFAULT NULL,
  [status] smallint DEFAULT '0',
  [probability] smallint DEFAULT '0',
  [closedate] int DEFAULT '0',
  [priority] smallint DEFAULT '0',
  [forecast] smallint DEFAULT '0',
  [worstcase] double precision DEFAULT '0',
  [mostlikely] double precision DEFAULT '0',
  [upside] double precision DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  [message] int DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_opportunities_opportunities] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_opportunities_opportunities_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_opportunities_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_opportunities_customer] FOREIGN KEY ([customer]) REFERENCES [crm_customers_customers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_opportunities_message] FOREIGN KEY ([message]) REFERENCES [col_messages_messages] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_opportunities_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [opportunity] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_crm_opportunities_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_opportunities_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_files_opportunity] FOREIGN KEY ([opportunity]) REFERENCES [crm_opportunities_opportunities] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [crm_opportunities_records] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [opportunity] int NOT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_crm_opportunities_records] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_crm_opportunities_records_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_crm_opportunities_records_opportunity] FOREIGN KEY ([opportunity]) REFERENCES [crm_opportunities_opportunities] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_archive_locations] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_archive_locations] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_archive_locations_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_archive_rooms] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [location] int NOT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [roomnum] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [lastinsert] int DEFAULT '0',
  [mapbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_archive_rooms_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_archive_rooms_location] FOREIGN KEY ([location]) REFERENCES [erp_archive_locations] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_archive_shelves] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [room] int NOT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_archive_shelves] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_archive_shelves_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_archive_shelves_room] FOREIGN KEY ([room]) REFERENCES [erp_archive_rooms] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_archive_types] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_archive_types] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_archive_types_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_archive_elements] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [shelf] int NOT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [elementid] nvarchar(255) DEFAULT NULL,
  [type] int DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_archive_elements] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_archive_elements_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_archive_elements_shelf] FOREIGN KEY ([shelf]) REFERENCES [erp_archive_shelves] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_archive_elements_type] FOREIGN KEY ([type]) REFERENCES [erp_archive_types] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [number] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_storages] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [default] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_storages] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_storages_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_storages_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_items] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [storage] int NOT NULL,
  [useserials] smallint DEFAULT '0',
  [evalmethod] smallint DEFAULT '0',
  [periode] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [manufacturer] nvarchar(255) DEFAULT NULL,
  [itemnum] nvarchar(255) DEFAULT NULL,
  [location] nvarchar(255) DEFAULT NULL,
  [quantity] smallint DEFAULT '0',
  [barcode] nvarchar(255) DEFAULT NULL,
  [price] double precision DEFAULT '0',
  [taxrate] smallint DEFAULT '0',
  [minstock] int DEFAULT '0',
  [weight] double precision DEFAULT '0',
  [dimx] double precision DEFAULT '0',
  [dimy] double precision DEFAULT '0',
  [dimz] double precision DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_items] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_items_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_items_storage] FOREIGN KEY ([storage]) REFERENCES [erp_stockcalc_storages] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_productions] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [item] int NOT NULL,
  [date] int DEFAULT '0',
  [productionid] nvarchar(255) DEFAULT NULL,
  [output] int DEFAULT '0',
  [target] int DEFAULT '0',
  [materialcosts] double precision DEFAULT '0',
  [manufactcosts] double precision DEFAULT '0',
  [itemsbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_productions] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_productions_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_productions_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_depletions] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [item] int NOT NULL,
  [date] int DEFAULT '0',
  [delivery] int DEFAULT NULL,
  [production] int DEFAULT NULL,
  [purpose] nvarchar(255) DEFAULT NULL,
  [amount] int DEFAULT '0',
  [price] double precision DEFAULT '0',
  CONSTRAINT [PriKey_erp_stockcalc_depletions] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_depletions_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_depletions_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_depletions_delivery] FOREIGN KEY ([delivery]) REFERENCES [crm_billing_deliveries] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_depletions_production] FOREIGN KEY ([production]) REFERENCES [erp_stockcalc_productions] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_depletions_serials] (
  [ID] int identity NOT NULL,
  [depletion] int NOT NULL,
  [int identity] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_depletions_serials] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_depletions_serials_depletion] FOREIGN KEY ([depletion]) REFERENCES [erp_stockcalc_depletions] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_devices] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [item] int NOT NULL,
  [int identity] nvarchar(255) DEFAULT NULL,
  [location] nvarchar(255) DEFAULT NULL,
  [reference] nvarchar(255) DEFAULT NULL,
  [comment] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_devices] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_devices_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_devices_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [item] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_files_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_items_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [item] int NOT NULL,
  [category] int NOT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_items_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_items_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_items_categories_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_items_categories_category] FOREIGN KEY ([category]) REFERENCES [erp_stockcalc_categories] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_suppliers_suppliers] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [vendornum] nvarchar(255) DEFAULT NULL,
  [status] smallint DEFAULT '0',
  [customernum] nvarchar(255) DEFAULT NULL,
  [dispatch] smallint DEFAULT '0',
  [payment] smallint DEFAULT '0',
  [prefcontact] smallint DEFAULT '0',
  [bank] nvarchar(255) DEFAULT NULL,
  [bankid] nvarchar(255) DEFAULT NULL,
  [account] nvarchar(255) DEFAULT NULL,
  [person] int DEFAULT NULL,
  [company] int DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [lastupload] int DEFAULT '0',
  [pricelistbinfile] nvarchar(32) DEFAULT NULL,
  [extdatabinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_suppliers_suppliers] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_suppliers_suppliers_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_suppliers_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_suppliers_person] FOREIGN KEY ([person]) REFERENCES [org_contacts_people] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_suppliers_company] FOREIGN KEY ([company]) REFERENCES [org_contacts_companies] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_orders] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [item] int NOT NULL,
  [flag] smallint DEFAULT '0',
  [date] int DEFAULT '0',
  [orderid] nvarchar(255) DEFAULT NULL,
  [supplier] int DEFAULT NULL,
  [amount] int DEFAULT '0',
  [delivered] int DEFAULT '0',
  [price] double precision DEFAULT '0',
  [etd] int DEFAULT '0',
  [td] int DEFAULT '0',
  CONSTRAINT [PriKey_erp_stockcalc_orders] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_orders_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_orders_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_orders_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_incoming] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [item] int NOT NULL,
  [date] int DEFAULT '0',
  [order] int DEFAULT NULL,
  [production] int DEFAULT NULL,
  [amount] int DEFAULT '0',
  [price] double precision DEFAULT '0',
  [periode] smallint DEFAULT '0',
  CONSTRAINT [PriKey_erp_stockcalc_incoming] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_incoming_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_incoming_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_incoming_order] FOREIGN KEY ([order]) REFERENCES [erp_stockcalc_orders] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_incoming_production] FOREIGN KEY ([production]) REFERENCES [erp_stockcalc_productions] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_incoming_serials] (
  [ID] int identity NOT NULL,
  [incoming] int NOT NULL,
  [int identity] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_incoming_serials] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_incoming_serials_incoming] FOREIGN KEY ([incoming]) REFERENCES [erp_stockcalc_incoming] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_templates] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [inputbinfile] nvarchar(32) DEFAULT NULL,
  [outputbinfile] nvarchar(32) DEFAULT NULL,
  [pdfbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_templates] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_templates_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_printouts] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [orderid] nvarchar(255) DEFAULT NULL,
  [template] int DEFAULT NULL,
  [maildate] int DEFAULT '0',
  [databinfile] nvarchar(32) DEFAULT NULL,
  [pdfbinfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_printouts] PRIMARY KEY ([ID]),
  CONSTRAINT [ForKey_erp_stockcalc_printouts_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  /*
  CONSTRAINT [ForKey_erp_stockcalc_printouts_template] FOREIGN KEY ([template]) REFERENCES [erp_stockcalc_templates] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_stockcalc_suppliers] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [item] int NOT NULL,
  [supplier] int NOT NULL,
  CONSTRAINT [PriKey_erp_stockcalc_suppliers] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_stockcalc_suppliers_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_suppliers_item] FOREIGN KEY ([item]) REFERENCES [erp_stockcalc_items] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_stockcalc_suppliers_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_suppliers_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [supplier] int NOT NULL,
  [category] int NOT NULL,
  CONSTRAINT [PriKey_erp_suppliers_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_suppliers_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_categories_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_categories_category] FOREIGN KEY ([category]) REFERENCES [erp_stockcalc_categories] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_suppliers_files] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [supplier] int NOT NULL,
  [file] int NOT NULL,
  CONSTRAINT [PriKey_erp_suppliers_files] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_suppliers_files_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_files_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_files_file] FOREIGN KEY ([file]) REFERENCES [col_files_files] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_suppliers_invoices] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [supplier] int NOT NULL,
  [flag] smallint DEFAULT '0',
  [invoicenum] nvarchar(255) DEFAULT NULL,
  [billingdate] int DEFAULT '0',
  [duedate] int DEFAULT '0',
  [netamount] double precision DEFAULT '0',
  [totalamount] double precision DEFAULT '0',
  [payment] double precision DEFAULT '0',
  [comment] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_suppliers_invoices] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_suppliers_invoices_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_invoices_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [erp_suppliers_journal] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [supplier] int NOT NULL,
  [date] int DEFAULT '0',
  [label] smallint DEFAULT '0',
  [contact] int DEFAULT NULL,
  [subject] nvarchar(255) DEFAULT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_erp_suppliers_journal] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_erp_suppliers_journal_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_journal_supplier] FOREIGN KEY ([supplier]) REFERENCES [erp_suppliers_suppliers] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_erp_suppliers_journal_contact] FOREIGN KEY ([contact]) REFERENCES [org_contacts_people] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_calendar_events] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [location] nvarchar(255) DEFAULT NULL,
  [datefrom] int DEFAULT '0',
  [dateto] int DEFAULT '0',
  [repeat] smallint DEFAULT '0',
  [interval] int DEFAULT '0',
  [usedaterepeat] smallint DEFAULT '0',
  [daterepeat] int DEFAULT '0',
  [label] smallint DEFAULT '0',
  [display] smallint DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_calendar_events] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_calendar_events_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_calendar_events_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_calendar_events_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_calendar_invitations] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [event] int NOT NULL,
  [flag] smallint DEFAULT '0',
  CONSTRAINT [PriKey_org_calendar_invitations] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_calendar_invitations_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_calendar_invitations_event] FOREIGN KEY ([event]) REFERENCES [org_calendar_events] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_org_contacts_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_companies_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [company] int NOT NULL,
  [category] int NOT NULL,
  CONSTRAINT [PriKey_org_contacts_companies_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_companies_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_companies_categories_company] FOREIGN KEY ([company]) REFERENCES [org_contacts_companies] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_companies_categories_category] FOREIGN KEY ([category]) REFERENCES [org_contacts_categories] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_people_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [person] int NOT NULL,
  [category] int NOT NULL,
  CONSTRAINT [PriKey_org_contacts_people_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_people_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_categories_person] FOREIGN KEY ([person]) REFERENCES [org_contacts_people] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_categories_category] FOREIGN KEY ([category]) REFERENCES [org_contacts_categories] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_contacts_people_companies] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [person] int NOT NULL,
  [company] int NOT NULL,
  CONSTRAINT [PriKey_org_contacts_people_companies] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_contacts_people_companies_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_companies_person] FOREIGN KEY ([person]) REFERENCES [org_contacts_people] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_contacts_people_companies_company] FOREIGN KEY ([company]) REFERENCES [org_contacts_companies] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_followup_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_org_followup_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_followup_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_followup_reminders] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [category] int DEFAULT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [duedate] int DEFAULT '0',
  [status] smallint DEFAULT '0',
  [priority] smallint DEFAULT '0',
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_followup_reminders] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_followup_reminders_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_reminders_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_reminders_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_reminders_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_reminders_category] FOREIGN KEY ([category]) REFERENCES [org_followup_categories] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_followup_associates] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [reminder] int NOT NULL,
  [entity] nvarchar(60) DEFAULT NULL,
  [index] int DEFAULT '0',
  CONSTRAINT [PriKey_org_followup_associates] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_followup_associates_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_associates_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_associates_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_followup_associates_reminder] FOREIGN KEY ([reminder]) REFERENCES [org_followup_reminders] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_links_linklists] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [title] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_links_linklists] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_links_linklists_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_links_linklists_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_links_linklists_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_links_links] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [linklist] int NOT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [url] nvarchar(255) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  [numviews] int DEFAULT '0',
  CONSTRAINT [PriKey_org_links_links] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_links_links_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_links_links_linklist] FOREIGN KEY ([linklist]) REFERENCES [org_links_linklists] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_links_view] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [linklist] int NOT NULL,
  CONSTRAINT [PriKey_org_links_view] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_links_view_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_links_view_linklist] FOREIGN KEY ([linklist]) REFERENCES [org_links_linklists] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [org_notes_categories] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_org_notes_categories] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_notes_categories_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_notes_notes] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [assigneduser] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [category] int DEFAULT NULL,
  [title] nvarchar(255) DEFAULT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_notes_notes] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_notes_notes_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_notes_notes_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_notes_notes_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_notes_notes_assigneduser] FOREIGN KEY ([assigneduser]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_notes_notes_category] FOREIGN KEY ([category]) REFERENCES [org_notes_categories] ([ID]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [org_tasks_records] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [task] int NOT NULL,
  [text] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_org_tasks_records] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_org_tasks_records_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_org_tasks_records_task] FOREIGN KEY ([task]) REFERENCES [org_tasks_tasks] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_accesskeys] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [key] nvarchar(32) DEFAULT NULL,
  [description] nvarchar(max) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_accesskeys] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_accesskeys_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_boarditems] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [text] nvarchar(255) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_boarditems] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_boarditems_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_charts] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [activity] smallint DEFAULT '0',
  [timeoriented] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [binfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_charts] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_charts_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_exporttemplates] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [activity] smallint DEFAULT '0',
  [entity] nvarchar(60) DEFAULT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [binfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_exporttemplates] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_exporttemplates_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_monitor] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) DEFAULT NULL,
  [ownergroup] nvarchar(60) DEFAULT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [UMI] nvarchar(60) DEFAULT NULL,
  [entity] nvarchar(60) DEFAULT NULL,
  [index] int DEFAULT '0',
  [url] nvarchar(255) DEFAULT NULL,
  [name] nvarchar(255) DEFAULT NULL,
  [action] smallint DEFAULT '0',
  CONSTRAINT [PriKey_platform_monitor] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_monitor_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_platform_monitor_ownergroup] FOREIGN KEY ([ownergroup]) REFERENCES [platform_groups] ([groupname]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_platform_monitor_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_services] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [activity] smallint DEFAULT '0',
  [name] nvarchar(255) DEFAULT NULL,
  [event] smallint DEFAULT '0',
  [entity] nvarchar(60) DEFAULT NULL,
  [schedule] int DEFAULT '0',
  [interval] int DEFAULT '0',
  [binfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_services] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_services_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_services_accesskeys] (
  [ID] int identity NOT NULL,
  [creator] nvarchar(60) DEFAULT NULL,
  [creationdate] int DEFAULT '0',
  [service] int NOT NULL,
  [accesskey] int NOT NULL,
  CONSTRAINT [PriKey_platform_services_accesskeys] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_services_accesskeys_creator] FOREIGN KEY ([creator]) REFERENCES [platform_users] ([username]) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT [ForKey_platform_services_accesskeys_service] FOREIGN KEY ([service]) REFERENCES [platform_services] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT [ForKey_platform_services_accesskeys_accesskey] FOREIGN KEY ([accesskey]) REFERENCES [platform_accesskeys] ([ID]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TABLE [platform_settings] (
  [ID] int identity NOT NULL,
  [owneruser] nvarchar(60) NOT NULL,
  [creationdate] int DEFAULT '0',
  [lastmodified] int DEFAULT '0',
  [UMI] nvarchar(60) DEFAULT NULL,
  [binfile] nvarchar(32) DEFAULT NULL,
  CONSTRAINT [PriKey_platform_settings] PRIMARY KEY ([ID]),
  /*
  CONSTRAINT [ForKey_platform_settings_owneruser] FOREIGN KEY ([owneruser]) REFERENCES [platform_users] ([username]) ON DELETE CASCADE ON UPDATE CASCADE
  */
);

CREATE TRIGGER [TrgUpdateOwnerUser_platform_users] ON [platform_users] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId nvarchar(60), @VarOldId nvarchar(60)
SELECT @VarNewId = [username] FROM [inserted]
SELECT @VarOldId = [username] FROM [deleted]
UPDATE [col_files_folders] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_files_shortcuts] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_forums_notify] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_forums_view] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_messages_folders] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_messages_accounts] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_messages_messages] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_messages_templates] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_news_channels] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_news_newsitems] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [col_news_view] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_contacts_companies] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_tasks_tasks] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_contacts_people] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_calendar_events] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_calendar_invitations] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_followup_reminders] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_followup_associates] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_links_linklists] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_links_view] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [org_notes_notes] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [platform_monitor] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
UPDATE [platform_settings] SET [owneruser] = @VarNewId WHERE [owneruser] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdateCreator_platform_users] ON [platform_users] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId nvarchar(60), @VarOldId nvarchar(60)
SELECT @VarNewId = [username] FROM [inserted]
SELECT @VarOldId = [username] FROM [deleted]
UPDATE [col_files_folders] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_files_types] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_files_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_files_items] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_files_journal] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_forums_columns] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_forums_forums] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_forums_topics] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_forums_entries] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_messages_folders] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_messages_messages] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_messages_templates] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_news_channels] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [col_news_newsitems] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_companies] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_customers_customers] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_deliveries] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_invoices] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_offers] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_orders] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_payments] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_templates] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_printouts] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_billing_requests] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_campaigns_campaigns] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_campaigns_addressees] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_campaigns_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_campaigns_records] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_tasks_tasks] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_campaigns_tasks] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_cases_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_cases_cases] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_cases_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_cases_records] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_cases_tasks] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_contracts_classes] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_contracts_contracts] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_contracts_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_contracts_records] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_customers_groups] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_customers_customers_groups] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_customers_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_people] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_customers_journal] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_opportunities_opportunities] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_opportunities_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [crm_opportunities_records] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_archive_locations] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_archive_rooms] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_archive_shelves] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_archive_types] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_archive_elements] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_storages] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_items] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_productions] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_depletions] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_devices] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_items_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_suppliers_suppliers] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_orders] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_incoming] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_templates] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_printouts] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_stockcalc_suppliers] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_suppliers_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_suppliers_files] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_suppliers_invoices] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [erp_suppliers_journal] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_calendar_events] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_companies_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_people_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_contacts_people_companies] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_followup_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_followup_reminders] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_followup_associates] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_links_linklists] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_links_links] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_notes_categories] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_notes_notes] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [org_tasks_records] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_accesskeys] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_boarditems] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_charts] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_exporttemplates] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_monitor] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_services] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
UPDATE [platform_services_accesskeys] SET [creator] = @VarNewId WHERE [creator] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdateAssignedUser_platform_users] ON [platform_users] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId nvarchar(60), @VarOldId nvarchar(60)
SELECT @VarNewId = [username] FROM [inserted]
SELECT @VarOldId = [username] FROM [deleted]
UPDATE [col_files_files] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [col_forums_forums] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [crm_customers_customers] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [crm_campaigns_campaigns] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [org_tasks_tasks] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [crm_cases_cases] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [crm_contracts_contracts] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [crm_opportunities_opportunities] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [erp_stockcalc_storages] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [erp_suppliers_suppliers] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [org_followup_reminders] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
UPDATE [org_notes_notes] SET [assigneduser] = @VarNewId WHERE [assigneduser] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDeleteOwnerUser_platform_users] ON [platform_users] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId nvarchar(60)
SELECT @VarId = [username] FROM [deleted]
DELETE FROM [col_files_folders] WHERE [owneruser] = @VarId
DELETE FROM [col_files_shortcuts] WHERE [owneruser] = @VarId
DELETE FROM [col_forums_notify] WHERE [owneruser] = @VarId
DELETE FROM [col_forums_view] WHERE [owneruser] = @VarId
DELETE FROM [col_messages_folders] WHERE [owneruser] = @VarId
DELETE FROM [col_messages_accounts] WHERE [owneruser] = @VarId
DELETE FROM [col_messages_messages] WHERE [owneruser] = @VarId
DELETE FROM [col_messages_templates] WHERE [owneruser] = @VarId
DELETE FROM [col_news_channels] WHERE [owneruser] = @VarId
DELETE FROM [col_news_newsitems] WHERE [owneruser] = @VarId
DELETE FROM [col_news_view] WHERE [owneruser] = @VarId
DELETE FROM [org_contacts_companies] WHERE [owneruser] = @VarId
DELETE FROM [org_tasks_tasks] WHERE [owneruser] = @VarId
DELETE FROM [org_contacts_people] WHERE [owneruser] = @VarId
DELETE FROM [org_calendar_events] WHERE [owneruser] = @VarId
DELETE FROM [org_calendar_invitations] WHERE [owneruser] = @VarId
DELETE FROM [org_followup_reminders] WHERE [owneruser] = @VarId
DELETE FROM [org_followup_associates] WHERE [owneruser] = @VarId
DELETE FROM [org_links_linklists] WHERE [owneruser] = @VarId
DELETE FROM [org_links_view] WHERE [owneruser] = @VarId
DELETE FROM [org_notes_notes] WHERE [owneruser] = @VarId
DELETE FROM [platform_monitor] WHERE [owneruser] = @VarId
DELETE FROM [platform_settings] WHERE [owneruser] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDeleteCreator_platform_users] ON [platform_users] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId nvarchar(60)
SELECT @VarId = [username] FROM [deleted]
UPDATE [col_files_folders] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_files_types] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_files_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_files_items] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_files_journal] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_forums_columns] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_forums_forums] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_forums_topics] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_forums_entries] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_messages_folders] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_messages_messages] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_messages_templates] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_news_channels] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [col_news_newsitems] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_companies] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_customers_customers] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_deliveries] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_invoices] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_offers] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_orders] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_payments] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_templates] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_printouts] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_billing_requests] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_campaigns_campaigns] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_campaigns_addressees] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_campaigns_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_campaigns_records] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_tasks_tasks] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_campaigns_tasks] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_cases_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_cases_cases] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_cases_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_cases_records] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_cases_tasks] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_contracts_classes] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_contracts_contracts] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_contracts_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_contracts_records] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_customers_groups] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_customers_customers_groups] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_customers_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_people] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_customers_journal] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_opportunities_opportunities] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_opportunities_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [crm_opportunities_records] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_archive_locations] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_archive_rooms] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_archive_shelves] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_archive_types] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_archive_elements] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_storages] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_items] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_productions] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_depletions] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_devices] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_items_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_suppliers_suppliers] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_orders] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_incoming] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_templates] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_printouts] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_stockcalc_suppliers] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_suppliers_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_suppliers_files] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_suppliers_invoices] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [erp_suppliers_journal] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_calendar_events] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_companies_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_people_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_contacts_people_companies] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_followup_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_followup_reminders] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_followup_associates] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_links_linklists] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_links_links] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_notes_categories] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_notes_notes] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [org_tasks_records] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_accesskeys] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_boarditems] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_charts] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_exporttemplates] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_monitor] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_services] SET [creator] = NULL WHERE [creator] = @VarId
UPDATE [platform_services_accesskeys] SET [creator] = NULL WHERE [creator] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDeleteAssignedUser_platform_users] ON [platform_users] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId nvarchar(60)
SELECT @VarId = [username] FROM [deleted]
UPDATE [col_files_files] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [col_forums_forums] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [crm_customers_customers] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [crm_campaigns_campaigns] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [org_tasks_tasks] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [crm_cases_cases] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [crm_contracts_contracts] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [crm_opportunities_opportunities] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [erp_stockcalc_storages] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [erp_suppliers_suppliers] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [org_followup_reminders] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
UPDATE [org_notes_notes] SET [assigneduser] = NULL WHERE [assigneduser] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_platform_groups] ON [platform_groups] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId nvarchar(60), @VarOldId nvarchar(60)
SELECT @VarNewId = [groupname] FROM [inserted]
SELECT @VarOldId = [groupname] FROM [deleted]
UPDATE [col_files_folders] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_forums_forums] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_messages_folders] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_messages_messages] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_messages_templates] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_news_channels] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [col_news_newsitems] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_contacts_companies] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_tasks_tasks] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [crm_cases_cases] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_contacts_people] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_calendar_events] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_followup_reminders] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_followup_associates] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_links_linklists] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [org_notes_notes] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
UPDATE [platform_monitor] SET [ownergroup] = @VarNewId WHERE [ownergroup] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_platform_groups] ON [platform_groups] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId nvarchar(60)
SELECT @VarId = [groupname] FROM [deleted]
DELETE FROM [col_files_folders] WHERE [ownergroup] = @VarId
DELETE FROM [col_forums_forums] WHERE [ownergroup] = @VarId
DELETE FROM [col_messages_folders] WHERE [ownergroup] = @VarId
DELETE FROM [col_messages_messages] WHERE [ownergroup] = @VarId
DELETE FROM [col_messages_templates] WHERE [ownergroup] = @VarId
DELETE FROM [col_news_channels] WHERE [ownergroup] = @VarId
DELETE FROM [col_news_newsitems] WHERE [ownergroup] = @VarId
DELETE FROM [org_contacts_companies] WHERE [ownergroup] = @VarId
DELETE FROM [org_tasks_tasks] WHERE [ownergroup] = @VarId
DELETE FROM [crm_cases_cases] WHERE [ownergroup] = @VarId
DELETE FROM [org_contacts_people] WHERE [ownergroup] = @VarId
DELETE FROM [org_calendar_events] WHERE [ownergroup] = @VarId
DELETE FROM [org_followup_reminders] WHERE [ownergroup] = @VarId
DELETE FROM [org_followup_associates] WHERE [ownergroup] = @VarId
DELETE FROM [org_links_linklists] WHERE [ownergroup] = @VarId
DELETE FROM [org_notes_notes] WHERE [ownergroup] = @VarId
DELETE FROM [platform_monitor] WHERE [ownergroup] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_files_folders] ON [col_files_folders] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_files_files] SET [folder] = @VarNewId WHERE [folder] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_files_folders] ON [col_files_folders] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [col_files_files] WHERE [folder] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_files_types] ON [col_files_types] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_files_files] SET [type] = @VarNewId WHERE [type] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_files_types] ON [col_files_types] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [col_files_files] SET [type] = NULL WHERE [type] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_files_files] ON [col_files_files] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_files_items] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [col_files_journal] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [col_files_shortcuts] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [crm_campaigns_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [crm_cases_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [crm_contracts_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [crm_customers_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [crm_opportunities_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [erp_stockcalc_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
UPDATE [erp_suppliers_files] SET [file] = @VarNewId WHERE [file] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_files_files] ON [col_files_files] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [col_files_items] WHERE [file] = @VarId
DELETE FROM [col_files_journal] WHERE [file] = @VarId
DELETE FROM [col_files_shortcuts] WHERE [file] = @VarId
DELETE FROM [crm_campaigns_files] WHERE [file] = @VarId
DELETE FROM [crm_cases_files] WHERE [file] = @VarId
DELETE FROM [crm_contracts_files] WHERE [file] = @VarId
DELETE FROM [crm_customers_files] WHERE [file] = @VarId
DELETE FROM [crm_opportunities_files] WHERE [file] = @VarId
DELETE FROM [erp_stockcalc_files] WHERE [file] = @VarId
DELETE FROM [erp_suppliers_files] WHERE [file] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_forums_columns] ON [col_forums_columns] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_forums_forums] SET [column] = @VarNewId WHERE [column] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_forums_columns] ON [col_forums_columns] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [col_forums_forums] SET [column] = NULL WHERE [column] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_forums_forums] ON [col_forums_forums] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_forums_topics] SET [forum] = @VarNewId WHERE [forum] = @VarOldId
UPDATE [col_forums_notify] SET [forum] = @VarNewId WHERE [forum] = @VarOldId
UPDATE [col_forums_view] SET [forum] = @VarNewId WHERE [forum] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_forums_forums] ON [col_forums_forums] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [col_forums_topics] WHERE [forum] = @VarId
DELETE FROM [col_forums_notify] WHERE [forum] = @VarId
DELETE FROM [col_forums_view] WHERE [forum] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_forums_topics] ON [col_forums_topics] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_forums_entries] SET [topic] = @VarNewId WHERE [topic] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_forums_topics] ON [col_forums_topics] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [col_forums_entries] WHERE [topic] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_messages_accounts] ON [col_messages_accounts] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_messages_messages] SET [account] = @VarNewId WHERE [account] = @VarOldId
UPDATE [col_messages_msglog] SET [account] = @VarNewId WHERE [account] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_messages_accounts] ON [col_messages_accounts] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [col_messages_messages] SET [account] = NULL WHERE [account] = @VarId
DELETE FROM [col_messages_msglog] WHERE [account] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_messages_folders] ON [col_messages_folders] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_messages_accounts] SET [moveto] = @VarNewId WHERE [moveto] = @VarOldId
UPDATE [col_messages_messages] SET [folder] = @VarNewId WHERE [folder] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_messages_folders] ON [col_messages_folders] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [col_messages_accounts] SET [moveto] = NULL WHERE [moveto] = @VarId
DELETE FROM [col_messages_messages] WHERE [folder] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_messages_messages] ON [col_messages_messages] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_cases_cases] SET [message] = @VarNewId WHERE [message] = @VarOldId
UPDATE [crm_opportunities_opportunities] SET [message] = @VarNewId WHERE [message] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_messages_messages] ON [col_messages_messages] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_cases_cases] SET [message] = NULL WHERE [message] = @VarId
UPDATE [crm_opportunities_opportunities] SET [message] = NULL WHERE [message] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_col_news_channels] ON [col_news_channels] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [col_news_newsitems] SET [channel] = @VarNewId WHERE [channel] = @VarOldId
UPDATE [col_news_view] SET [channel] = @VarNewId WHERE [channel] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_col_news_channels] ON [col_news_channels] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [col_news_newsitems] WHERE [channel] = @VarId
DELETE FROM [col_news_view] WHERE [channel] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_contacts_companies] ON [org_contacts_companies] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_customers_customers] SET [company] = @VarNewId WHERE [company] = @VarOldId
UPDATE [erp_suppliers_suppliers] SET [company] = @VarNewId WHERE [company] = @VarOldId
UPDATE [org_contacts_companies_categories] SET [company] = @VarNewId WHERE [company] = @VarOldId
UPDATE [org_contacts_people_companies] SET [company] = @VarNewId WHERE [company] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_contacts_companies] ON [org_contacts_companies] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_customers_customers] SET [company] = NULL WHERE [company] = @VarId
UPDATE [erp_suppliers_suppliers] SET [company] = NULL WHERE [company] = @VarId
DELETE FROM [org_contacts_companies_categories] WHERE [company] = @VarId
DELETE FROM [org_contacts_people_companies] WHERE [company] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_contacts_people] ON [org_contacts_people] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_customers_customers] SET [person] = @VarNewId WHERE [person] = @VarOldId
UPDATE [crm_customers_journal] SET [contact] = @VarNewId WHERE [contact] = @VarOldId
UPDATE [erp_suppliers_suppliers] SET [person] = @VarNewId WHERE [person] = @VarOldId
UPDATE [erp_suppliers_journal] SET [contact] = @VarNewId WHERE [contact] = @VarOldId
UPDATE [org_contacts_people_categories] SET [person] = @VarNewId WHERE [person] = @VarOldId
UPDATE [org_contacts_people_companies] SET [person] = @VarNewId WHERE [person] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_contacts_people] ON [org_contacts_people] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_customers_customers] SET [company] = NULL WHERE [company] = @VarId
UPDATE [crm_customers_journal] SET [contact] = NULL WHERE [contact] = @VarId
UPDATE [erp_suppliers_suppliers] SET [company] = NULL WHERE [company] = @VarId
UPDATE [erp_suppliers_journal] SET [contact] = NULL WHERE [contact] = @VarId
DELETE FROM [org_contacts_people_categories] WHERE [person] = @VarId
DELETE FROM [org_contacts_people_companies] WHERE [person] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_customers_customers] ON [crm_customers_customers] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_billing_deliveries] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_billing_invoices] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_billing_offers] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_billing_orders] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_billing_requests] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_campaigns_addressees] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_cases_cases] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_contracts_contracts] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_customers_customers_groups] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_customers_files] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_customers_journal] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
UPDATE [crm_opportunities_opportunities] SET [customer] = @VarNewId WHERE [customer] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_customers_customers] ON [crm_customers_customers] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_billing_deliveries] SET [customer] = NULL WHERE [customer] = @VarId
UPDATE [crm_billing_invoices] SET [customer] = NULL WHERE [customer] = @VarId
UPDATE [crm_billing_offers] SET [customer] = NULL WHERE [customer] = @VarId
UPDATE [crm_billing_orders] SET [customer] = NULL WHERE [customer] = @VarId
UPDATE [crm_billing_requests] SET [customer] = NULL WHERE [customer] = @VarId
DELETE FROM [crm_campaigns_addressees] WHERE [customer] = @VarId
UPDATE [crm_cases_cases] SET [customer] = NULL WHERE [customer] = @VarId
UPDATE [crm_contracts_contracts] SET [customer] = NULL WHERE [customer] = @VarId
DELETE FROM [crm_customers_customers_groups] WHERE [customer] = @VarId
DELETE FROM [crm_customers_files] WHERE [customer] = @VarId
DELETE FROM [crm_customers_journal] WHERE [customer] = @VarId
UPDATE [crm_opportunities_opportunities] SET [customer] = NULL WHERE [customer] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_billing_invoices] ON [crm_billing_invoices] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_billing_invoices_deliveries] SET [invoice] = @VarNewId WHERE [invoice] = @VarOldId
UPDATE [crm_billing_payments] SET [invoice] = @VarNewId WHERE [invoice] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_billing_invoices] ON [crm_billing_invoices] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_billing_invoices_deliveries] WHERE [invoice] = @VarId
DELETE FROM [crm_billing_payments] WHERE [invoice] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_billing_deliveries] ON [crm_billing_deliveries] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_billing_invoices_deliveries] SET [delivery] = @VarNewId WHERE [delivery] = @VarOldId
UPDATE [erp_stockcalc_depletions] SET [delivery] = @VarNewId WHERE [delivery] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_billing_deliveries] ON [crm_billing_deliveries] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_billing_invoices_deliveries] WHERE [invoice] = @VarId
UPDATE [erp_stockcalc_depletions] SET [delivery] = NULL WHERE [delivery] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_billing_templates] ON [crm_billing_templates] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_billing_printouts] SET [template] = @VarNewId WHERE [template] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_billing_templates] ON [crm_billing_templates] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_billing_printouts] SET [template] = NULL WHERE [template] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_campaigns_campaigns] ON [crm_campaigns_campaigns] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_campaigns_addressees] SET [campaign] = @VarNewId WHERE [campaign] = @VarOldId
UPDATE [crm_campaigns_files] SET [campaign] = @VarNewId WHERE [campaign] = @VarOldId
UPDATE [crm_campaigns_records] SET [campaign] = @VarNewId WHERE [campaign] = @VarOldId
UPDATE [crm_campaigns_tasks] SET [campaign] = @VarNewId WHERE [campaign] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_campaigns_campaigns] ON [crm_campaigns_campaigns] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_campaigns_addressees] WHERE [campaign] = @VarId
DELETE FROM [crm_campaigns_files] WHERE [campaign] = @VarId
DELETE FROM [crm_campaigns_records] WHERE [campaign] = @VarId
DELETE FROM [crm_campaigns_tasks] WHERE [campaign] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_tasks_tasks] ON [org_tasks_tasks] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_campaigns_tasks] SET [task] = @VarNewId WHERE [task] = @VarOldId
UPDATE [crm_cases_tasks] SET [task] = @VarNewId WHERE [task] = @VarOldId
UPDATE [org_tasks_records] SET [task] = @VarNewId WHERE [task] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_tasks_tasks] ON [org_tasks_tasks] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_campaigns_tasks] WHERE [task] = @VarId
DELETE FROM [crm_cases_tasks] WHERE [task] = @VarId
DELETE FROM [org_tasks_records] WHERE [task] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_cases_categories] ON [crm_cases_categories] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_cases_cases] SET [category] = @VarNewId WHERE [category] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_cases_categories] ON [crm_cases_categories] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [crm_cases_cases] SET [category] = NULL WHERE [category] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_cases_cases] ON [crm_cases_cases] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_cases_files] SET [case] = @VarNewId WHERE [case] = @VarOldId
UPDATE [crm_cases_records] SET [case] = @VarNewId WHERE [case] = @VarOldId
UPDATE [crm_cases_tasks] SET [case] = @VarNewId WHERE [case] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_cases_cases] ON [crm_cases_cases] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_cases_files] WHERE [case] = @VarId
DELETE FROM [crm_cases_records] WHERE [case] = @VarId
DELETE FROM [crm_cases_tasks] WHERE [case] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_contracts_classes] ON [crm_contracts_classes] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_contracts_contracts] SET [class] = @VarNewId WHERE [class] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_contracts_classes] ON [crm_contracts_classes] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_contracts_contracts] WHERE [class] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_contracts_contracts] ON [crm_contracts_contracts] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_contracts_files] SET [contract] = @VarNewId WHERE [contract] = @VarOldId
UPDATE [crm_contracts_records] SET [contract] = @VarNewId WHERE [contract] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_contracts_contracts] ON [crm_contracts_contracts] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_contracts_files] WHERE [contract] = @VarId
DELETE FROM [crm_contracts_records] WHERE [contract] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_customers_groups] ON [crm_customers_groups] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_customers_customers_groups] SET [group] = @VarNewId WHERE [group] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_customers_groups] ON [crm_customers_groups] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_customers_customers_groups] WHERE [group] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_crm_opportunities_opportunities] ON [crm_opportunities_opportunities] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [crm_opportunities_files] SET [opportunity] = @VarNewId WHERE [opportunity] = @VarOldId
UPDATE [crm_opportunities_records] SET [opportunity] = @VarNewId WHERE [opportunity] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_crm_opportunities_opportunities] ON [crm_opportunities_opportunities] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [crm_opportunities_files] WHERE [opportunity] = @VarId
DELETE FROM [crm_opportunities_records] WHERE [opportunity] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_archive_locations] ON [erp_archive_locations] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_archive_rooms] SET [location] = @VarNewId WHERE [location] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_archive_locations] ON [erp_archive_locations] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_archive_rooms] WHERE [location] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_archive_rooms] ON [erp_archive_rooms] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_archive_shelves] SET [room] = @VarNewId WHERE [room] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_archive_rooms] ON [erp_archive_rooms] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_archive_shelves] WHERE [room] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_archive_shelves] ON [erp_archive_shelves] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_archive_elements] SET [shelf] = @VarNewId WHERE [shelf] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_archive_shelves] ON [erp_archive_shelves] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_archive_elements] WHERE [shelf] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_archive_types] ON [erp_archive_types] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_archive_elements] SET [type] = @VarNewId WHERE [type] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_archive_types] ON [erp_archive_types] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [erp_archive_elements] SET [type] = NULL WHERE [type] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_storages] ON [erp_stockcalc_storages] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_items] SET [storage] = @VarNewId WHERE [storage] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_storages] ON [erp_stockcalc_storages] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_stockcalc_items] WHERE [storage] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_items] ON [erp_stockcalc_items] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_productions] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_depletions] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_devices] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_files] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_items_categories] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_orders] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_incoming] SET [item] = @VarNewId WHERE [item] = @VarOldId
UPDATE [erp_stockcalc_suppliers] SET [item] = @VarNewId WHERE [item] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_items] ON [erp_stockcalc_items] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_stockcalc_productions] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_depletions] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_devices] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_files] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_items_categories] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_orders] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_incoming] WHERE [item] = @VarId
DELETE FROM [erp_stockcalc_suppliers] WHERE [item] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_productions] ON [erp_stockcalc_productions] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_depletions] SET [production] = @VarNewId WHERE [production] = @VarOldId
UPDATE [erp_stockcalc_incoming] SET [production] = @VarNewId WHERE [production] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_productions] ON [erp_stockcalc_productions] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_depletions] SET [production] = NULL WHERE [production] = @VarId
UPDATE [erp_stockcalc_incoming] SET [production] = NULL WHERE [production] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_depletions] ON [erp_stockcalc_depletions] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_depletions_serials] SET [depletion] = @VarNewId WHERE [depletion] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_depletions] ON [erp_stockcalc_depletions] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_stockcalc_depletions_serials] WHERE [depletion] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_categories] ON [erp_stockcalc_categories] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_items_categories] SET [category] = @VarNewId WHERE [category] = @VarOldId
UPDATE [erp_suppliers_categories] SET [category] = @VarNewId WHERE [category] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_categories] ON [erp_stockcalc_categories] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_stockcalc_items_categories] WHERE [category] = @VarId
DELETE FROM [erp_suppliers_categories] WHERE [category] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_suppliers_suppliers] ON [erp_suppliers_suppliers] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_orders] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
UPDATE [erp_stockcalc_suppliers] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
UPDATE [erp_suppliers_categories] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
UPDATE [erp_suppliers_files] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
UPDATE [erp_suppliers_invoices] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
UPDATE [erp_suppliers_journal] SET [supplier] = @VarNewId WHERE [supplier] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_suppliers_suppliers] ON [erp_suppliers_suppliers] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_orders] SET [supplier] = NULL WHERE [supplier] = @VarId
DELETE FROM [erp_stockcalc_suppliers] WHERE [supplier] = @VarId
DELETE FROM [erp_suppliers_categories] WHERE [supplier] = @VarId
DELETE FROM [erp_suppliers_files] WHERE [supplier] = @VarId
DELETE FROM [erp_suppliers_invoices] WHERE [supplier] = @VarId
DELETE FROM [erp_suppliers_journal] WHERE [supplier] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_orders] ON [erp_stockcalc_orders] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_incoming] SET [order] = @VarNewId WHERE [order] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_orders] ON [erp_stockcalc_orders] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_incoming] SET [order] = NULL WHERE [order] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_incoming] ON [erp_stockcalc_incoming] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_incoming_serials] SET [incoming] = @VarNewId WHERE [incoming] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_incoming] ON [erp_stockcalc_incoming] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [erp_stockcalc_incoming_serials] WHERE [incoming] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_erp_stockcalc_templates] ON [erp_stockcalc_templates] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_printouts] SET [template] = @VarNewId WHERE [template] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_erp_stockcalc_templates] ON [erp_stockcalc_templates] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [erp_stockcalc_printouts] SET [template] = NULL WHERE [template] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_calendar_events] ON [org_calendar_events] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_calendar_invitations] SET [event] = @VarNewId WHERE [event] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_calendar_events] ON [org_calendar_events] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [org_calendar_invitations] WHERE [event] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_contacts_categories] ON [org_contacts_categories] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_contacts_companies_categories] SET [category] = @VarNewId WHERE [category] = @VarOldId
UPDATE [org_contacts_people_categories] SET [category] = @VarNewId WHERE [category] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_contacts_categories] ON [org_contacts_categories] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [org_contacts_companies_categories] WHERE [category] = @VarId
DELETE FROM [org_contacts_people_categories] WHERE [category] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_followup_categories] ON [org_followup_categories] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_followup_reminders] SET [category] = @VarNewId WHERE [category] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_followup_categories] ON [org_followup_categories] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [org_followup_reminders] SET [category] = NULL WHERE [category] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_followup_reminders] ON [org_followup_reminders] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_followup_associates] SET [reminder] = @VarNewId WHERE [reminder] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_followup_reminders] ON [org_followup_reminders] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [org_followup_associates] WHERE [reminder] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_links_linklists] ON [org_links_linklists] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_links_links] SET [linklist] = @VarNewId WHERE [linklist] = @VarOldId
UPDATE [org_links_view] SET [linklist] = @VarNewId WHERE [linklist] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_links_linklists] ON [org_links_linklists] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [org_links_links] WHERE [linklist] = @VarId
DELETE FROM [org_links_view] WHERE [linklist] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_org_notes_categories] ON [org_notes_categories] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [org_notes_notes] SET [category] = @VarNewId WHERE [category] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_org_notes_categories] ON [org_notes_categories] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
UPDATE [org_notes_notes] SET [category] = NULL WHERE [category] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_platform_services] ON [platform_services] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [platform_services_accesskeys] SET [service] = @VarNewId WHERE [service] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_platform_services] ON [platform_services] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [platform_services_accesskeys] WHERE [service] = @VarId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgUpdate_platform_accesskeys] ON [platform_accesskeys] FOR UPDATE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarNewId int, @VarOldId int
SELECT @VarNewId = [ID] FROM [inserted]
SELECT @VarOldId = [ID] FROM [deleted]
UPDATE [platform_services_accesskeys] SET [accesskey] = @VarNewId WHERE [accesskey] = @VarOldId
SET NOCOUNT OFF
END;

CREATE TRIGGER [TrgDelete_platform_accesskeys] ON [platform_accesskeys] FOR DELETE AS
BEGIN
SET NOCOUNT ON
DECLARE @VarId int
SELECT @VarId = [ID] FROM [deleted]
DELETE FROM [platform_services_accesskeys] WHERE [accesskey] = @VarId
SET NOCOUNT OFF
END;