
{*******************************************************}
{                                                       }
{       ScaleRichView                                   }
{       The given component represents TPanel for work  }
{       with ScaleRichView.                             }
{                                                       }
{       Copyright (c) Ilya Zelenskiy                    }
{       Ilya.Zelenskiy@gmail.com                        }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit SRVPanel;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, Forms, Graphics, Controls, Classes, SRVControl;

type
  TSRVPanel = class(TSRVCustomControl)
  private
    FBorderColor: TColor;
    FBorderWidth: Integer;
    FCaptionOffset: Integer;
    FCornersOffset: Integer;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure SetBorderColor(NewBorderColor: TColor);
    procedure SetBorderWidth(NewBorderWidth: Integer);
    procedure SetCaptionOffset(Value: Integer);
    procedure SetCornersOffset(Value: Integer);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Anchors;
    property Align;
    property Alignment default taCenter;
    property BorderColor: TColor read FBorderColor write SetBorderColor default SRV_BORDER_COLOR;
    property BorderWidth: Integer read FBorderWidth write SetBorderWidth default SRV_BORDER_WIDTH;
    property Caption;
    property CaptionOffset: Integer read FCaptionOffset write SetCaptionOffset default SRV_CAPTION_OFFSET;
    property Color;
    property CornersOffset: Integer read FCornersOffset write SetCornersOffset default SRV_CORNERS_OFFSET;
    property DrawOnPrint default True;
    property Font;
    property Hint;
    property Height default 41;
    property Enabled;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property OnClick;
    {$IFDEF RICHVIEWDEF5}
    property OnContextPopup;
    {$ENDIF}
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnEnter;
    property OnExit;
    property Width default 185;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('SRichView', [TSRVPanel]);
end;

constructor TSRVPanel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
    csSetCaption, csDoubleClicks, csReplicatable];
  Height := 41;
  Width := 185;
  FBorderWidth := SRV_BORDER_WIDTH;
  FBorderColor := SRV_BORDER_COLOR;
  FCornersOffset := SRV_CORNERS_OFFSET;
  FAlignment := taCenter;
  FCaptionOffset := SRV_CAPTION_OFFSET;
  Font.Color := SRV_CAPTION_COLOR;
end;

procedure TSRVPanel.CMDialogChar(var Message: TCMDialogChar);
begin
with Message do
  if IsAccel(CharCode, Caption) then
    Result := 1
else
  inherited;
end;

procedure TSRVPanel.SetBorderColor(NewBorderColor: TColor);
begin
  FBorderColor := NewBorderColor;
  Invalidate;
end;

procedure TSRVPanel.SetBorderWidth(NewBorderWidth: Integer);
begin
  if NewBorderWidth > SRV_MAX_BORDER_WIDTH then
    begin
      FBorderWidth := SRV_MAX_BORDER_WIDTH;
      Invalidate;
      Exit;
    end;
  if NewBorderWidth < SRV_MIN_BORDER_WIDTH then
    begin
      FBorderWidth := SRV_MIN_BORDER_WIDTH;
      Invalidate;
      Exit;
    end;
  FBorderWidth := NewBorderWidth;
  Invalidate;
end;

procedure TSRVPanel.SetCaptionOffset(Value: Integer);
begin
  if Value > SRV_MAX_CAPTION_OFFSET then
    begin
      FCaptionOffset := SRV_MAX_CAPTION_OFFSET;
      Invalidate;
      Exit;
    end;
  if Value < SRV_MIN_CAPTION_OFFSET then
    begin
      FCaptionOffset := SRV_MIN_CAPTION_OFFSET;
      Invalidate;
      Exit;
    end;
  FCaptionOffset := Value;
  Invalidate;
end;

procedure TSRVPanel.SetCornersOffset(Value: Integer);
begin
  if Value > SRV_MAX_CORNERS_OFFSET then
    begin
      FCornersOffset := SRV_MAX_CORNERS_OFFSET;
      Invalidate;
      Exit;
    end;
  if Value < SRV_MIN_CORNERS_OFFSET then
    begin
      FCornersOffset := SRV_MIN_CORNERS_OFFSET;
      Invalidate;
      Exit;
    end;
  FCornersOffset := Value;
  Invalidate;
end;

procedure TSRVPanel.Paint;
var Rector: TRect;
    Flag: LongInt;
begin
  Rector := Rect(BorderWidth+CaptionOffset, BorderWidth+CaptionOffset,
    Width-BorderWidth-CaptionOffset, Height-BorderWidth-CaptionOffset);
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Rect(0, 0, Width, Height));
  Canvas.Pen.Color := BorderColor;
  Canvas.Pen.Width := BorderWidth;
  Canvas.Font := Font;
  Canvas.Brush.Color := Color;
  Canvas.RoundRect(0, 0, Width, Height, -CornersOffset+BorderWidth-1, -CornersOffset+BorderWidth-1);
  Flag := Alignments[Alignment];
  Rector.Top := ((Rector.Bottom + Rector.Top) - Canvas.TextHeight('W')) div 2;
  Rector.Bottom := Rector.Top + Canvas.TextHeight('W');
  DrawText(Canvas.handle, PChar(Caption), Length(Caption), Rector, Flag);
end;

end.
