
{*******************************************************}
{                                                       }
{       ScaleRichView                                   }
{       The given component represents TGroupBox for    }
{       work with ScaleRichView.                        }
{                                                       }
{       Copyright (c) Ilya Zelenskiy                    }
{       Ilya.Zelenskiy@gmail.com                        }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit SRVGroupBox;

interface
{$I RV_Defs.inc}
uses
  Windows, Messages, Forms, Graphics, Controls, Classes, SRVControl;

type
  TSRVGroupBox = class(TSRVCustomControl)
  private
    FBorderWidth: Integer;
    FBorderColor: TColor;
    FCornersOffset: Integer;
    FCaptionOffset: Integer;
    FMouseEnter: TNotifyEvent;
    FMouseLeave: TNotifyEvent;
    procedure CMDialogChar(var Message: TCMDialogChar); message CM_DIALOGCHAR;
    procedure CMTextChanged(var Message: TMessage); message CM_TEXTCHANGED;
    procedure MouseEnter(var Message: TMessage); message CM_MOUSEENTER;
    procedure MouseLeave(var Message: TMessage); message CM_MOUSELEAVE;
    procedure WMSize(var Message: TMessage); message WM_SIZE;
    procedure SetBorderColor(NewBorderColor: TColor);
    procedure SetBorderWidth(NewBorderWidth: Integer);
    procedure SetCaptionOffset(Value: Integer);
    procedure SetCornersOffset(Value: Integer);
  protected
    procedure Paint; override;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Anchors;
    property Align;
    property BorderColor: TColor read FBorderColor write SetBorderColor default SRV_BORDER_COLOR;
    property BorderWidth: Integer read FBorderWidth write SetBorderWidth default SRV_BORDER_WIDTH;
    property Caption;
    property Alignment default taLeftJustify;
    property CaptionOffset: Integer read FCaptionOffset write SetCaptionOffset default SRV_CAPTION_OFFSET;
    property Color;
    property CornersOffset: Integer read FCornersOffset write SetCornersOffset default SRV_CORNERS_OFFSET;
    property DrawOnPrint default True;
    property Enabled;
    property Font;
    property Hint;
    property Height default 105;
    property PopupMenu;
    property ShowHint;
    property Visible;
    property OnClick;
    {$IFDEF RICHVIEWDEF5}
    property OnContextPopup;
    {$ENDIF}
    property OnDblClick;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnEnter;
    property OnExit;
    property OnMouseEnter: TNotifyEvent read FMouseEnter write FMouseEnter;
    property OnMouseLeave: TNotifyEvent read FMouseLeave write FMouseLeave;
    property Width default 185;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('SRichView', [TSRVGroupBox]);
end;

constructor TSRVGroupBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  ControlStyle := [csAcceptsControls, csCaptureMouse, csClickEvents,
    csSetCaption, csDoubleClicks, csReplicatable];
  Width := 185;
  Height := 105;
  FBorderWidth := SRV_BORDER_WIDTH;
  FBorderColor := SRV_BORDER_COLOR;
  FCornersOffset := SRV_CORNERS_OFFSET;
  FCaptionOffset := SRV_CAPTION_OFFSET;
  FAlignment := taLeftJustify;
end;

procedure TSRVGroupBox.Paint;
var Rector: TRect;
    Flag: LongInt;
begin
  Rector := Rect(CaptionOffset, 0,
    Width-CaptionOffset, Height-BorderWidth);
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Rect(0, 0, Width, Height));
  Canvas.Pen.Color := BorderColor;
  Canvas.Pen.Width := BorderWidth;
  Canvas.Font := Font;
  Canvas.Brush.Color := Color;
  Flag := Alignments[Alignment];
  Canvas.RoundRect(0, Canvas.TextHeight('W') div 2, Width, Height, -CornersOffset+BorderWidth-1, -CornersOffset+BorderWidth-1);
  DrawText(Canvas.handle, PChar(Caption), Length(Caption), Rector, Flag);
end;

procedure TSRVGroupBox.CMDialogChar(var Message: TCMDialogChar);
begin
with Message do
  if IsAccel(CharCode, Caption) then
    Result := 1
else
  inherited;
end;

procedure TSRVGroupBox.CMTextChanged(var Message: TMessage);
begin
  Invalidate;
end;

procedure TSRVGroupBox.MouseEnter(var Message: TMessage);
begin
  if Assigned(FMouseEnter) then
    FMouseEnter(Self);
end;

procedure TSRVGroupBox.MouseLeave(var Message: TMessage);
begin
  if Assigned(FMouseLeave) then
    FMouseLeave(Self);
end;

procedure TSRVGroupBox.WMSize(var Message: TMessage);
begin
  inherited;
  Invalidate;
end;

procedure TSRVGroupBox.SetBorderColor(NewBorderColor: TColor);
begin
  if FBorderColor <> NewBorderColor then
    begin
      FBorderColor := NewBorderColor;
      Invalidate;
    end;
end;

procedure TSRVGroupBox.SetBorderWidth(NewBorderWidth: Integer);
begin
  if NewBorderWidth = FBorderWidth then
    Exit;
  if NewBorderWidth > SRV_MAX_BORDER_WIDTH then
    begin
      FBorderWidth := SRV_MAX_BORDER_WIDTH;
      Invalidate;
      Exit;
    end;
  if NewBorderWidth < SRV_MIN_BORDER_WIDTH then
    begin
      FBorderWidth := SRV_MIN_BORDER_WIDTH;
      Invalidate;
      Exit;
    end;
  FBorderWidth := NewBorderWidth;
  Invalidate;
end;

procedure TSRVGroupBox.SetCaptionOffset(Value: Integer);
begin
  if Value = FCaptionOffset then
    Exit;
  if Value > SRV_MAX_CAPTION_OFFSET then
    begin
      FCaptionOffset := SRV_MAX_CAPTION_OFFSET;
      Invalidate;
      Exit;
    end;
  if Value < SRV_MIN_CAPTION_OFFSET then
    begin
      FCaptionOffset := SRV_MIN_CAPTION_OFFSET;
      Invalidate;
      Exit;
    end;
  FCaptionOffset := Value;
  Invalidate;
end;

procedure TSRVGroupBox.SetCornersOffset(Value: Integer);
begin
  if Value = FCornersOffset then
    Exit;
  if Value > SRV_MAX_CORNERS_OFFSET then
    begin
      FCornersOffset := SRV_MAX_CORNERS_OFFSET;
      Invalidate;
      Exit;
    end;
  if Value < SRV_MIN_CORNERS_OFFSET then
    begin
      FCornersOffset := SRV_MIN_CORNERS_OFFSET;
      Invalidate;
      Exit;
    end;
  FCornersOffset := Value;
  Invalidate;
end;

end.