unit MFSRVPrint;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SRVPrint, ExtCtrls, RVScroll, CRVPP, SRVPreview, SclRView, StdCtrls, Printers,
  RVStyle;

type
  TFSRVPrint = class(TForm)
    srve: TSRichViewEdit;
    srvprvw: TSRVPreview;
    Splitter1: TSplitter;
    SRVPrint1: TSRVPrint;
    Panel1: TPanel;
    cmbPrinterPageFormat: TComboBox;
    Label2: TLabel;
    rgPrinterPageOrientation: TRadioGroup;
    cmbPrinter: TComboBox;
    Label4: TLabel;
    Bevel1: TBevel;
    Label5: TLabel;
    Label6: TLabel;
    btnPreview: TButton;
    cbAutoUpdate: TCheckBox;
    Label7: TLabel;
    cmbDocPageFormat: TComboBox;
    rgDocOrientation: TRadioGroup;
    Bevel2: TBevel;
    procedure FormCreate(Sender: TObject);
    procedure rgPrinterPageOrientationClick(Sender: TObject);
    procedure cmbPrinterChange(Sender: TObject);
    procedure cmbPrinterPageFormatChange(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure cbAutoUpdateClick(Sender: TObject);
    procedure btnPreviewClick(Sender: TObject);
    procedure cmbDocPageFormatChange(Sender: TObject);
    procedure rgDocOrientationClick(Sender: TObject);
  private
    procedure AssignPageFormat;
    { Private declarations }
  public
    { Public declarations }
    procedure UpdateControlsForPrinter;
  end;

var
  FSRVPrint: TFSRVPrint;

implementation

{$R *.DFM}

procedure TFSRVPrint.UpdateControlsForPrinter;
var
     index, indexFormat : Integer;
begin
  cmbPrinterPageFormat.Clear;
  with SRVPrint1.SRVPrtInfo do begin
    UpdateCurPrinterData;
    indexFormat := -1;
    for index := 0 to (PaperFormatsList.Count-1) do
      begin
        if (PaperFormatsList.Items[index].PaperSizeCode = PaperSizeCode) then
          indexFormat := index;
        if (Trim(SRVPrint1.SRVPrtInfo.PaperFormatsList.Items[index].Name) <> '') then
          cmbPrinterPageFormat.Items.Append(SRVPrint1.SRVPrtInfo.PaperFormatsList.Items[index].Name);
      end;
  end;
  cmbPrinterPageFormat.ItemIndex := indexFormat;
  if (Printer.Orientation = poPortrait) then
    rgPrinterPageOrientation.ItemIndex := 0
  else
    rgPrinterPageOrientation.ItemIndex := 1;
end;

procedure TFSRVPrint.FormCreate(Sender: TObject);
var
     index : Integer;
begin
  // Printers
  if (Printer.Printers.Count > 0) then
    for index := 0 to (Printer.Printers.Count-1) do
      cmbPrinter.Items.Append(Printer.Printers.Strings[index]);
  cmbPrinter.ItemIndex := Printer.PrinterIndex;


  UpdateControlsForPrinter;
  cmbDocPageFormat.ItemIndex := 3;

  cmbPrinterPageFormatChange(nil);
  cbAutoUpdateClick(nil);
end;

procedure TFSRVPrint.cmbPrinterChange(Sender: TObject);
begin
  if (Printer.Printers.Count > 0) then
    begin
      Printer.PrinterIndex := cmbPrinter.ItemIndex;
      UpdateControlsForPrinter;
      cmbPrinterPageFormatChange(nil);
    end;
end;


procedure TFSRVPrint.cmbPrinterPageFormatChange(Sender: TObject);
var
     index : Integer;
     Device : array[0..255] of char;
     Driver : array[0..255] of char;
     Port   : array[0..255] of char;
     hDMode : THandle;
     PDMode : PDEVMODE;
begin
  index := cmbPrinterPageFormat.ItemIndex;
  if (index = -1) then
    Exit;

  Printer.PrinterIndex := Printer.PrinterIndex;
  Printer.GetPrinter(Device, Driver, Port, hDMode);
  if hDMode <> 0 then begin
    pDMode := GlobalLock(hDMode);
    if pDMode <> nil then begin
     {Set to custom size}
      pDMode^.dmFields := pDMode^.dmFields or
                          DM_PAPERSIZE;
      pDMode^.dmPaperSize :=
        SRVPrint1.SRVPrtInfo.PaperFormatsList.Items[index].PaperSizeCode;

     {Set the bin to use}
      pDMode^.dmFields := pDMode^.dmFields or DMBIN_MANUAL;
      pDMode^.dmDefaultSource := DMBIN_MANUAL;

      GlobalUnlock(hDMode);
    end;
  end;
  Printer.SetPrinter(Device, Driver, Port, hDMode);
  SRVPrint1.Update;
  srvprvw.ZoomMode := rvzmFullPage;
  cmbDocPageFormatChange(nil);
end;

procedure TFSRVPrint.rgPrinterPageOrientationClick(Sender: TObject);
begin
  if (rgPrinterPageOrientation.ItemIndex = 0) then
    SRVPrint1.Orientation := poPortrait
  else
    SRVPrint1.Orientation := poLandscape;
  Printer.Orientation := SRVPrint1.Orientation;
  cmbPrinterPageFormatChange(nil);
end;

procedure TFSRVPrint.FormResize(Sender: TObject);
begin
  srvprvw.ZoomMode := rvzmFullPage;
end;

procedure TFSRVPrint.cbAutoUpdateClick(Sender: TObject);
begin
  SRVPrint1.AutoUpdate := cbAutoUpdate.Checked;
  btnPreview.Enabled := not cbAutoUpdate.Checked;
end;

procedure TFSRVPrint.btnPreviewClick(Sender: TObject);
begin
  SRVPrint1.Update;
end;

procedure TFSRVPrint.AssignPageFormat;
var
     pW : Extended;
     pH : Extended;
begin
  case cmbDocPageFormat.ItemIndex of
    0: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA1, srve.UnitsProgram, pW, pH);
    1: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA2, srve.UnitsProgram, pW, pH);
    2: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA3, srve.UnitsProgram, pW, pH);
    3: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA4, srve.UnitsProgram, pW, pH);
    4: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA5, srve.UnitsProgram, pW, pH);
    5: srve.PageProperty.ConvertPageFormatToPageSize(srvfmA6, srve.UnitsProgram, pW, pH);
    6: srve.PageProperty.ConvertPageFormatToPageSize(srvfmLetter, srve.UnitsProgram, pW, pH);
    7: srve.PageProperty.ConvertPageFormatToPageSize(srvfmLegal, srve.UnitsProgram, pW, pH);
  else
    srve.PageProperty.ConvertPageFormatToPageSize(srvfmA4, srve.UnitsProgram, pW, pH);
  end;
  if srve.PageProperty.Orientation = poLandscape then begin
    srve.PageProperty.PageWidth := pH;
    srve.PageProperty.PageHeight := pW;
    end
  else begin
    srve.PageProperty.PageWidth := pW;
    srve.PageProperty.PageHeight := pH;
  end;
  srve.ViewProperty.ZoomMode := srve.ViewProperty.ZoomMode;
end;

procedure TFSRVPrint.cmbDocPageFormatChange(Sender: TObject);
var
     index : Integer;
begin
  index := cmbDocPageFormat.ItemIndex;
  if (index = -1) then
    Exit;
  AssignPageFormat;
  SRVPrint1.Update;
  srvprvw.ZoomMode := rvzmFullPage;
end;

procedure TFSRVPrint.rgDocOrientationClick(Sender: TObject);
begin
  if (rgDocOrientation.ItemIndex = 0) then
    srve.PageProperty.Orientation := poPortrait
  else
    srve.PageProperty.Orientation := poLandscape;
  cmbDocPageFormatChange(nil);
end;

end.
