unit Demo7Frm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  RVScroll, RichView, RVEdit, ExtCtrls, StdCtrls, SclRView;

type
  TfrmDemo7 = class(TForm)
    Panel1: TPanel;
    txt: TEdit;
    btnMark: TButton;
    btnUnmark: TButton;
    srv: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure btnMarkClick(Sender: TObject);
    procedure btnUnmarkClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


implementation
uses MainFrm;

{$R *.DFM}

{
 See advanced versions of this demo on the forum:
 http://www.trichview.com/forums/viewtopic.php?t=57
}

procedure TfrmDemo7.FormCreate(Sender: TObject);
begin
  srv.SetMargin(5, 5, 5, 5);

  srv.RichViewEdit.Clear;
  srv.RichViewEdit.LoadText(ExtractFilePath(Application.ExeName)+'MainFrm.pas',0,0, False);
  srv.RichViewEdit.Format;
end;

procedure TfrmDemo7.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if Key=VK_ESCAPE then Close;
end;

procedure TfrmDemo7.btnMarkClick(Sender: TObject);
begin
  srv.RichViewEdit.SetSelectionBounds(0,srv.RichViewEdit.GetOffsBeforeItem(0),0,srv.RichViewEdit.GetOffsBeforeItem(0));
  while srv.RichViewEdit.SearchText(txt.Text, [rvseoDown]) do
    begin
      srv.RichViewEdit.ApplyTextStyle(sncomMarked);
      srv.ScrollToCaret;
    end;
// Note: every call of ApplyTextStyle reformats affected paragraphs
end;

procedure TfrmDemo7.btnUnmarkClick(Sender: TObject);
begin
  srv.RichViewEdit.SelectAll;
  srv.RichViewEdit.ApplyTextStyle(sncomNormal);
  srv.RichViewEdit.Deselect;
  srv.RichViewEdit.Refresh;
end;

end.
