{==============================================================================}
{ Example: two ways of drawing RichView document onto Canvas                   }
{==============================================================================}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, RVScroll, RichView, RVStyle, ComCtrls,
  PtblRV, RVReport, SclRView, SRVPrint, Spin;

type
  TForm1 = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    Image1: TImage;
    Button1: TButton;
    Image2: TImage;
    Button2: TButton;
    Label1: TLabel;
    Label2: TLabel;
    SRVPrint1: TSRVPrint;
    srv: TSRichViewEdit;
    Panel1: TPanel;
    PageNo: TSpinEdit;
    Label3: TLabel;
    PageNoVisible: TCheckBox;
    ClipMargins: TCheckBox;
    BreakPages: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure ClipMarginsClick(Sender: TObject);
    procedure BreakPagesClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var i: Integer;
begin
  // For Example
  srv.RichViewEdit.AddNL('This is a line of text',1,1);
  for i := 1 to 20 do
    srv.RichViewEdit.AddNL('This is a line of text',0,0);
  srv.RichViewEdit.Format;
end;

const VERYLARGEVALUE = $FFFFFFF;

// Example 1
procedure TForm1.Button1Click(Sender: TObject);
var Metafile: TMetafile;
begin
  Metafile := TMetafile.Create;
  Metafile.Width := Image1.ClientWidth;
  Metafile.Height := Image1.ClientHeight;


  srv.DrawMetafile(PageNo.Value, Metafile, PageNoVisible.Checked, ClipMargins.Checked, False);
  Image1.Picture.Graphic := Metafile;
  Metafile.Free;
end;

// Example 2

procedure TForm1.Button2Click(Sender: TObject);
var
     bmp : TBitmap;
begin
  SRVPrint1.ClipMargins := ClipMargins.Checked;
  SRVPrint1.Update;
  bmp := TBitmap.Create;
  bmp.Width := Image2.ClientWidth;
  bmp.Height := Image2.ClientHeight;

  SRVPrint1.SRichViewEdit.DrawPage(PageNo.Value,
                                   bmp.Width, bmp.Height, 0, 0,
                                   bmp.Canvas,
                                   PageNoVisible.Checked,
                                   ClipMargins.Checked, True);
  Image2.Picture.Bitmap := bmp;
  bmp.Free;
end;

procedure TForm1.ClipMarginsClick(Sender: TObject);
begin
  Button1Click(nil);
  Button2Click(nil);
end;

procedure TForm1.BreakPagesClick(Sender: TObject);
begin
  srv.PageProperty.PageViewMode := BreakPages.Checked;
  if BreakPages.Checked then
    srv.PageProperty.PageFormat := srvfmA4;
  ClipMarginsClick(nil);
end;

end.
