unit TEMainFrm;

{------------------------------------------------------------------------------}
{
  Very simple template editor for "mail merging"
  It loads and saves a template in TEMPLATE.RVF.

  See mail merging application in the same directory - MAILMERGE.

  Main settings:
  - since field names are stored in tags (see the help topic about tags)
    as strings, rvoTagsArePChars is included in Options of srv.RichViewEdit.
  - this demo uses a predefined set of styles (right click richviews,
    choose "Settings" from the context menu, choose "Use a predefined
    set of styles"). That means - only two text styles (see below) will be used.
  - srv.RichViewEdit.Style has two styles:
    0th style - normal text,
    1st - field code (bold, with background, protected)
}
{------------------------------------------------------------------------------}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, RVStyle, RVScroll, RichView, RVEdit, StdCtrls, ExtCtrls,
  SclRView;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    Button1: TButton;
    Button2: TButton;
    RVStyle1: TRVStyle;
    Button4: TButton;
    srv: TSRichViewEdit;
    procedure Button4Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  srv.RichViewEdit.LoadRVF(ExtractFilePath(Application.ExeName)+'template.rvf');
  srv.RichViewEdit.Format;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  srv.RichViewEdit.SaveRVF(ExtractFilePath(Application.ExeName)+'template.rvf', False);
end;

{------------------------------------------------------------------------------}
{
  Inserting a field "code". Text of this item does not matter, but tag
  is important and equal to "code".
  Since rvprDoNotAutoSwitch is in Protection of the 1st text style,
  a current style will be switched back to previous value after insertion.
}
{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
  srv.RichViewEdit.CurTextStyleNo := 1;
  srv.RichViewEdit.InsertStringTag('Code', Integer(StrNew('code')));
  srv.RichViewEdit.SetFocus;  
end;
{------------------------------------------------------------------------------}
{
  Inserting a field "name".
}
{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
begin
  srv.RichViewEdit.CurTextStyleNo := 1;
  srv.RichViewEdit.InsertStringTag('Name', Integer(StrNew('name')));
  srv.RichViewEdit.SetFocus;
end;

end.
