unit MFSRVControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SclRView, RVScroll, SRVButton, SRVCheckBox, SRVEdit, SRVGroupBox, SRVLabel,
  SRVPanel, SRVRadioButton, SRVMediaPlayer;


type
  TFSRVControls = class(TForm)
    SRichViewEdit1: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure SRichViewEdit1MessageControl(Sender: TSRichViewEdit;
      AControl: TControl; var Message: TMessage);
    procedure CheckControl(Sender: TSRichViewEdit; AControl: TControl);
    procedure GetValueControl(Sender: TSRichViewEdit; AControl: TControl);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FSRVControls: TFSRVControls;
  isReady, isSex : Boolean;
  InfoText : String;

implementation

{$R *.DFM}

procedure TFSRVControls.FormCreate(Sender: TObject);
begin
  SRichViewEdit1.RichViewEdit.ReadOnly := True;
  SRichViewEdit1.RichViewEdit.Options := SRichViewEdit1.RichViewEdit.Options - [rvoAllowSelection];
  SRichViewEdit1.LoadRVF(ExtractFilePath(Application.ExeName)+'Information.rvf');
end;

procedure TFSRVControls.SRichViewEdit1MessageControl(
  Sender: TSRichViewEdit; AControl: TControl; var Message: TMessage);
begin
  {if button 'Ready' pressed}
  if (AControl.Name = 'Ready') and (Message.Msg = WM_LBUTTONUP) then
    begin
      {Checking flags}
      isReady := True;
      isSex := False;
      {Check controls}
      Sender.OnCheckControl := CheckControl;
      Sender.ProcessControls;
      {Checking flags}
      isReady := isReady and isSex;
      if not isSex then
        Application.MessageBox('Please indicate your sex', 'Check', 0);
      {Result of the check}
      if isReady then
        begin
          {We get values of controls}
          InfoText := '';
          Sender.OnCheckControl := GetValueControl;
          Sender.ProcessControls;
          Application.MessageBox(PChar(InfoText), 'Ready', 0)
        end
      else
        Application.MessageBox('Please fill the form!', 'Error', 0);
    end;
end;

procedure TFSRVControls.CheckControl(Sender: TSRichViewEdit; AControl: TControl);
var
     s : String;
begin
  {Check Name and SurName and About yourself}
  if (AControl is TSRVEdit) then
    begin
      s := Trim(TSRVEdit(AControl).Text);
      if (s = '') or (not TSRVEdit(AControl).Modified) then
        begin
          isReady := False;
          Application.MessageBox(PChar('Field ' + TSRVEdit(AControl).Name + ' is not filled!'),
                                 'Check', 0);
        end;
    end;
  {Check Sex}
  if (AControl is TSRVRadioButton) then
    isSex := isSex or TSRVRadioButton(AControl).Checked;
end;

procedure TFSRVControls.GetValueControl(Sender: TSRichViewEdit; AControl: TControl);
begin
  {Field Name}
  if (AControl.Name = 'Name') then
    InfoText := InfoText + 'Name: ' + Trim(TSRVEdit(AControl).Text) + #13 + #10;
  {Field Surname}
  if (AControl.Name = 'Surname') then
    InfoText := InfoText + 'Surname: ' + Trim(TSRVEdit(AControl).Text) + #13 + #10;
  {Field Sex}
  if (AControl is TSRVRadioButton) and TSRVRadioButton(AControl).Checked then
    InfoText := InfoText + 'Sex: ' + TSRVRadioButton(AControl).Name + #13 + #10;
  {Field Married}
  if (AControl.Name = 'Married') then
    if TSRVCheckBox(AControl).Checked then
      InfoText := InfoText + 'Married' + #13 + #10
    else
      InfoText := InfoText + 'Single' + #13 + #10;
  {Field AboutYourSelf}
  if (AControl.Name = 'AboutYourSelf') then
    InfoText := InfoText + 'About: ' + Trim(TSRVEdit(AControl).Text) + #13 + #10;
end;

initialization
  RegisterClass(TSRVButton);
  RegisterClass(TSRVEdit);
  RegisterClass(TSRVCheckBox);
  RegisterClass(TSRVRadioButton);

end.
