unit MRWProperty;

interface

uses SysUtils, Classes, Controls, Forms, SRVCheckBox, SRVEdit;

function GetBool(Value : Boolean) : String;
function GetAlign(Value : TAlign) : String;
function GetAlignment(Value : TAlignment) : String;
function GetModalResult(Value : TModalResult) : String;
function GetCharCase(Value : TSRVEditCharCase) : String;
function GetCBState(Value : TSRVCheckBoxState) : String;
function GetEnabled(AControl : TControl) : String;

function SetBool(Value : String) : Boolean;
function SetAlign(Value : String) : TAlign;
function SetAlignment(Value : String) : TAlignment;
function SetModalResult(Value : String) : TModalResult;
function SetCBState(Value : String) : TSRVCheckBoxState;
function SetCharCase(Value : String) : TSRVEditCharCase;

implementation

{*************** Get Value ******************}
function GetBool(Value : Boolean) : String;
begin
  if Value then Result := 'True'
  else Result := 'False';
end;

function GetAlign(Value : TAlign) : String;
begin
  case Value of
    alTop : Result := 'alTop';
    alBottom : Result := 'alBottom';
    alLeft : Result := 'alLeft';
    alRight : Result := 'alRight';
    alClient : Result := 'alClient';
  else
    Result := 'alNone';
  end;
end;

function GetAlignment(Value : TAlignment) : String;
begin
  case Value of
    taRightJustify : Result := 'taRightJustify';
    taCenter : Result := 'taCenter';
  else
    Result := 'taLeftJustify';
  end;
end;

function GetModalResult(Value : TModalResult) : String;
begin
  case Value of
    mrOk : Result := 'mrOk';
    mrCancel : Result := 'mrCancel';
    mrAbort : Result := 'mrAbort';
    mrRetry : Result := 'mrRetry';
    mrIgnore : Result := 'mrIgnore';
    mrYes : Result := 'mrYes';
    mrNo : Result := 'mrNo';
    mrAll : Result := 'mrAll';
  else
    Result := 'mrNone';
  end;
end;

function GetCharCase(Value : TSRVEditCharCase) : String;
begin
  case Value of
    srvecUpperCase : Result := 'srvecUpperCase';
    srvecLowerCase : Result := 'srvecLowerCase';
  else
    Result := 'srvecNormal';
  end;
end;

function GetCBState(Value : TSRVCheckBoxState) : String;
begin
  case Value of
    cbChecked : Result := 'cbChecked';
    cbGrayed : Result := 'cbGrayed';
  else
    Result := 'cbUnchecked';
  end;
end;

function GetEnabled(AControl : TControl) : String;
begin
  Result := GetBool(AControl.Enabled);
end;

{*************** Set Value ******************}
function SetBool(Value : String) : Boolean;
begin
  if UpperCase(Trim(Value)) = 'TRUE' then Result := True
  else Result := False;
end;

function SetAlign(Value : String) : TAlign;
begin
  if Value = 'alTop' then Result := alTop
  else if Value = 'alBottom' then Result := alBottom
  else if Value = 'alLeft' then Result := alLeft
  else if Value = 'alRight' then Result := alRight
  else if Value = 'alClient' then Result := alClient
  else Result := alNone;
end;

function SetAlignment(Value : String) : TAlignment;
begin
  if Value = 'taRightJustify' then Result := taRightJustify
  else if Value = 'taCenter' then Result := taCenter
  else Result := taLeftJustify;
end;

function SetModalResult(Value : String) : TModalResult;
begin
  if Value = 'mrOk' then Result := mrOk
  else if Value = 'mrCancel' then Result := mrCancel
  else if Value = 'mrAbort' then Result := mrAbort
  else if Value = 'mrRetry' then Result := mrRetry
  else if Value = 'mrIgnore' then Result := mrIgnore
  else if Value = 'mrYes' then Result := mrYes
  else if Value = 'mrNo' then Result := mrNo
  else if Value = 'mrAll' then Result := mrAll
  else Result := mrNone;
end;

function SetCBState(Value : String) : TSRVCheckBoxState;
begin
  if Value = 'cbChecked' then Result := cbChecked
  else if Value = 'cbGrayed' then Result := cbGrayed
  else Result := cbUnchecked;
end;

function SetCharCase(Value : String) : TSRVEditCharCase;
begin
  if Value = 'srvecUpperCase' then Result := srvecUpperCase
  else if Value = 'srvecLowerCase' then Result := srvecLowerCase
  else Result := srvecNormal;
end;

end.
