{
  This demo shows how to use standard Delphi controls.

  Displaying selection and caret in TEdit and TMemo is not supported.
  It's recommended to use ScaleRichView controls instead, see the demo
  SRVControls\Example2.
}

unit MFStandardControls;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  SclRView, RVScroll, StdCtrls;

type
  TFStandardControls = class(TForm)
    SRichViewEdit1: TSRichViewEdit;
    procedure FormCreate(Sender: TObject);
    procedure SRichViewEdit1MessageControl(Sender: TSRichViewEdit;
      AControl: TControl; var Message: TMessage);
    procedure CheckControl(Sender: TSRichViewEdit; AControl: TControl);
    procedure GetValueControl(Sender: TSRichViewEdit; AControl: TControl);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FStandardControls: TFStandardControls;
  isReady, isSex : Boolean;
  InfoText : String;

implementation

{$R *.DFM}

procedure TFStandardControls.FormCreate(Sender: TObject);
begin
  SRichViewEdit1.RichViewEdit.ReadOnly := True;
  SRichViewEdit1.RichViewEdit.Options := SRichViewEdit1.RichViewEdit.Options - [rvoAllowSelection];
  SRichViewEdit1.LoadRVF(ExtractFilePath(Application.ExeName)+'Information.rvf');
end;

procedure TFStandardControls.SRichViewEdit1MessageControl(
  Sender: TSRichViewEdit; AControl: TControl; var Message: TMessage);
begin
  {if button 'Ready' pressed}
  if (AControl.Name = 'Ready') and (Message.Msg = WM_LBUTTONUP) then
  begin
    {Checking flags}
    isReady := True;
    isSex := False;
    {Check controls}
    Sender.OnCheckControl := CheckControl;
    Sender.ProcessControls;
    {Checking flags}
    isReady := isReady and isSex;
    if not isSex then
      Application.MessageBox('Please indicate your sex', 'Check', 0);
    {Result of the check}
    if isReady then
    begin
      {We get values of controls}
      InfoText := '';
      Sender.OnCheckControl := GetValueControl;
      Sender.ProcessControls;
      Application.MessageBox(PChar(InfoText), 'Ready', 0)
    end
    else
      Application.MessageBox('Please complete the form!', 'Error', 0);
  end;
end;

procedure TFStandardControls.CheckControl(Sender: TSRichViewEdit; AControl: TControl);
var
     s : String;
begin
  {Check Name and SurName}
  if (AControl is TEdit) then
  begin
    s := Trim(TEdit(AControl).Text);
    if (s = '') or (not TEdit(AControl).Modified) then
    begin
      isReady := False;
      Application.MessageBox(
        PChar('Field ' + TEdit(AControl).Name + ' is not filled!'), 'Check', 0);
    end;
  end;
  {Check Sex}
  if (AControl is TRadioButton) then
    isSex := isSex or TRadioButton(AControl).Checked;
  {Check About yourself}
  if (AControl is TMemo) then
  begin
    s := Trim(TMemo(AControl).Lines.Text);
    if (s = '') or (not TMemo(AControl).Modified) then
    begin
      isReady := False;
      Application.MessageBox('Write about yourself', 'Check', 0);
    end;
  end;
end;

procedure TFStandardControls.GetValueControl(Sender: TSRichViewEdit; AControl: TControl);
begin
  {Field Name}
  if (AControl.Name = 'Name') then
    InfoText := InfoText + 'Name: ' + Trim(TEdit(AControl).Text) + #13 + #10;
  {Field Surname}
  if (AControl.Name = 'Surname') then
    InfoText := InfoText + 'Surname: ' + Trim(TEdit(AControl).Text) + #13 + #10;
  {Field Sex}
  if (AControl is TRadioButton) and TRadioButton(AControl).Checked then
    InfoText := InfoText + 'Sex: ' + TRadioButton(AControl).Name + #13 + #10;
  {Field Married}
  if (AControl.Name = 'Married') then
    if TCheckBox(AControl).Checked then
      InfoText := InfoText + 'Married' + #13 + #10
    else
      InfoText := InfoText + 'Single' + #13 + #10;
  {Field AboutYourSelf}
  if (AControl.Name = 'AboutYourSelf') then
    InfoText := InfoText + 'About: ' + Trim(TMemo(AControl).Lines.Text) + #13 + #10;
end;

initialization
  RegisterClass(TButton);
  RegisterClass(TEdit);
  RegisterClass(TCheckBox);
  RegisterClass(TRadioButton);
  RegisterClass(TMemo);

end.
