
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Demo project.                                   }
{       You can use it as a basis for your              }
{       applications.                                   }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit Unit3;

interface

{$I RV_Defs.inc}          // contains defines about Delphi compiler versions

{
  Remove dots from the defines below to enable support for Gif and Png.

  GifImage (by Anders Melander)
    http://www.torry.net/vcl/graphics/gif/gifimage.exe (original)
    http://www.trichview.com/resources/thirdparty/gifimage.zip (update)
  Note: for Delphi 2007+, use the built in TGifImage instead

  PngObject (by Gustavo Huffenbacher Daud)
    http://www.trichview.com/resources/thirdparty/pngimage.zip
  Note: for Delphi 2009+, use the built in TPngImage instead)
}

{.$DEFINE USE_GIFIMAGE}
{.$DEFINE USE_PNGOBJECT}


uses
  Windows, Messages, SysUtils,
  Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  ActnList, StdActns, ImgList,
  Menus, ShellApi, Printers, ToolWin, RVUni,
  RVScroll, RichView, RVEdit,
  RVStyle, PtblRV, CRVFData, RVTable, RVItem, CRVData, RVFuncs,

  // RVAAddictLanguages,

  RichViewActions, RVALocRuler, RVFontCombos, RVALocalize, Ruler, RVRuler,


  {$IFDEF USE_GIFIMAGE}
  {$IFDEF RICHVIEWDEF2007}GifImg,{$ELSE}GifImage,{$ENDIF}
  {$ENDIF}
  {$IFDEF USE_PNGOBJECT}
  PngImage,
  {$ENDIF}
  RVTypes;

type
  TForm3 = class(TForm)
    RichViewEdit1: TRichViewEdit;
    MainMenu1: TMainMenu;
    mitFile: TMenuItem;
    mitEdit: TMenuItem;
    New1: TMenuItem;
    Load1: TMenuItem;
    PrintPreview1: TMenuItem;
    N1: TMenuItem;
    Print1: TMenuItem;
    mitExit: TMenuItem;
    Cut1: TMenuItem;
    Copy1: TMenuItem;
    n2: TMenuItem;
    mitFont: TMenuItem;
    Bold1: TMenuItem;
    Italic1: TMenuItem;
    Underline1: TMenuItem;
    N3: TMenuItem;
    mitPara: TMenuItem;
    Leftjustify1: TMenuItem;
    N4: TMenuItem;
    Undo1: TMenuItem;
    Redo1: TMenuItem;
    Changefont1: TMenuItem;
    Save1: TMenuItem;
    Strikeout1: TMenuItem;
    mitTable: TMenuItem;
    InsertTable1: TMenuItem;
    N5: TMenuItem;
    SelectAll1: TMenuItem;
    AlignLeft1: TMenuItem;
    AlignCenter1: TMenuItem;
    AlignRight1: TMenuItem;
    N6: TMenuItem;
    DecreaseIndent1: TMenuItem;
    IncreaseIndent1: TMenuItem;
    RVStyle1: TRVStyle;
    N7: TMenuItem;
    StatusBar1: TStatusBar;
    Justify1: TMenuItem;
    InsertRowAbove1: TMenuItem;
    InsertRowBelow1: TMenuItem;
    N8: TMenuItem;
    InsertColumnLeft1: TMenuItem;
    InsertColumnRight1: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    DeleteRows1: TMenuItem;
    rvActionTableDeleteCols11: TMenuItem;
    N11: TMenuItem;
    MergeCells1: TMenuItem;
    SplitCells1: TMenuItem;
    N12: TMenuItem;
    mitTableSelect: TMenuItem;
    SelectTable1: TMenuItem;
    SelectColumns1: TMenuItem;
    SelectRows1: TMenuItem;
    SelectCell1: TMenuItem;
    mitFontStyle: TMenuItem;
    mitFontSize: TMenuItem;
    ShrinkFont1: TMenuItem;
    GrowFont1: TMenuItem;
    N13: TMenuItem;
    ShrinkFontByOnePoint1: TMenuItem;
    GrowFontByOnePoint1: TMenuItem;
    N14: TMenuItem;
    AllCapitals1: TMenuItem;
    Overline1: TMenuItem;
    N15: TMenuItem;
    Find1: TMenuItem;
    FindNext1: TMenuItem;
    Replace1: TMenuItem;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    ToolButton11: TToolButton;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton13: TToolButton;
    ToolButton22: TToolButton;
    ToolButton17: TToolButton;
    ToolButton18: TToolButton;
    ToolButton19: TToolButton;
    ToolButton20: TToolButton;
    ToolButton21: TToolButton;
    ToolBar2: TToolBar;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    ToolButton43: TToolButton;
    ToolButton44: TToolButton;
    ToolButton49: TToolButton;
    ToolButton50: TToolButton;
    ToolButton51: TToolButton;
    ToolButton53: TToolButton;
    ToolButton54: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolBar3: TToolBar;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton12: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton16: TToolButton;
    ToolButton23: TToolButton;
    ToolButton24: TToolButton;
    ToolButton25: TToolButton;
    ToolButton26: TToolButton;
    ToolButton28: TToolButton;
    ToolButton8: TToolButton;
    ToolButton27: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    ToolButton31: TToolButton;
    ToolButton32: TToolButton;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton35: TToolButton;
    N16: TMenuItem;
    ToolButton36: TToolButton;
    ToolButton37: TToolButton;
    extColor1: TMenuItem;
    ToolButton38: TToolButton;
    extBackgroundColor1: TMenuItem;
    N17: TMenuItem;
    ParagraphBackgroundColor1: TMenuItem;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    mitFormat: TMenuItem;
    BackgroundColor1: TMenuItem;
    DeleteTable1: TMenuItem;
    ToolButton45: TToolButton;
    N18: TMenuItem;
    rvActionParagraph11: TMenuItem;
    RVAControlPanel1: TRVAControlPanel;
    Font1: TMenuItem;
    FillColor1: TMenuItem;
    SaveAs1: TMenuItem;
    Export1: TMenuItem;
    mitInsert: TMenuItem;
    File1: TMenuItem;
    Picture1: TMenuItem;
    ToolButton46: TToolButton;
    PasteSpecial1: TMenuItem;
    N19: TMenuItem;
    SingleLineSpacing1: TMenuItem;
    N15LineSpacing1: TMenuItem;
    DoubleLineSpacing1: TMenuItem;
    N20: TMenuItem;
    InsertPageBreak1: TMenuItem;
    RemovePageBreak1: TMenuItem;
    N21: TMenuItem;
    mitTableAlignCellContents: TMenuItem;
    AlignCellToTheTop1: TMenuItem;
    AlignCellToTheMiddle1: TMenuItem;
    AlignCellToTheBottom1: TMenuItem;
    DefaultCellVerticalAlignment1: TMenuItem;
    ParagraphBorders1: TMenuItem;
    N22: TMenuItem;
    Properties1: TMenuItem;
    HorizontalLine1: TMenuItem;
    HypertextLink1: TMenuItem;
    ToolButton47: TToolButton;
    N23: TMenuItem;
    ableProperties1: TMenuItem;
    N24: TMenuItem;
    ShowGridLines1: TMenuItem;
    N25: TMenuItem;
    BulletsandNumbering1: TMenuItem;
    InsertSymbol1: TMenuItem;
    mitTableCellBorders: TMenuItem;
    LeftBorder1: TMenuItem;
    rvActionTableCellTopBorder11: TMenuItem;
    rvActionTableCellRightBorder11: TMenuItem;
    rvActionTableCellBottomBorder11: TMenuItem;
    rvActionTableCellAllBorders11: TMenuItem;
    rvActionTableCellNoBorders11: TMenuItem;
    ToolBar4: TToolBar;
    ToolButton48: TToolButton;
    ToolButton52: TToolButton;
    ToolButton55: TToolButton;
    ToolButton56: TToolButton;
    ToolButton58: TToolButton;
    ToolButton59: TToolButton;
    Bullets1: TMenuItem;
    Numbering1: TMenuItem;
    ToolButton57: TToolButton;
    ToolButton60: TToolButton;
    ToolButton61: TToolButton;
    ToolBar5: TToolBar;
    cmbFont: TRVFontComboBox;
    RVAPopupMenu1: TRVAPopupMenu;
    Background1: TMenuItem;
    RVPrint1: TRVPrint;
    ColorDialog1: TColorDialog;
    Button1: TButton;
    cmbFontSize: TRVFontSizeComboBox;
    PageSetup1: TMenuItem;
    N26: TMenuItem;
    CharacterCase1: TMenuItem;
    RVRuler1: TRVRuler;
    ToolButton62: TToolButton;
    ToolButton63: TToolButton;
    pmFakeDropDown: TPopupMenu;
    N27: TMenuItem;
    rvActionSubscript11: TMenuItem;
    rvActionSuperscript11: TMenuItem;
    ToolButton64: TToolButton;
    ToolButton65: TToolButton;
    mitHelp: TMenuItem;
    mitHelpTOC: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure mitExitClick(Sender: TObject);
    procedure RichViewEdit1Jump(Sender: TObject; id: Integer);
    procedure RichViewEdit1ReadHyperlink(Sender: TCustomRichView;
      const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
      ItemTag: Integer; var ItemName: TRVRawByteString);
    procedure cmbFontClick(Sender: TObject);
    procedure cmbKeyPress(Sender: TObject; var Key: Char);
    procedure RichViewEdit1CurTextStyleChanged(Sender: TObject);
    procedure cmbFontSizeClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure RichViewEdit1WriteHyperlink(Sender: TCustomRichView;
      id: Integer; RVData: TCustomRVData; ItemNo: Integer;
      SaveFormat: TRVSaveFormat; var Target, Extras: String);
    procedure RVAControlPanel1MarginsChanged(Sender: TrvAction;
      Edit: TCustomRichViewEdit);
    procedure RVAControlPanel1Download(Sender: TrvAction;
      const Source: String);
    procedure pmFakeDropDownPopup(Sender: TObject);
    procedure RichViewEdit1KeyPress(Sender: TObject; var Key: Char);
    procedure mitHelpTOCClick(Sender: TObject);
  private
    { Private declarations }
    UpdatingCombos: Boolean;
    procedure ColorPickerShow(Sender: TObject);
    procedure ColorPickerHide(Sender: TObject);
    procedure rvActionSave1DocumentFileChange(Sender: TObject;
      Editor: TCustomRichViewEdit; const FileName: String;
      FileFormat: TrvFileSaveFilter; IsNew: Boolean);
    procedure Localize;
  public
    { Public declarations }
  end;

var
  Form3: TForm3;

implementation

uses dmActions;
{$R *.dfm}

procedure TForm3.FormCreate(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF2009}
  RichViewEdit1.RTFReadProperties.UnicodeMode := rvruOnlyUnicode;
  {$ENDIF}

  // Almost all these assignments could be done at design time in the Object Inspector
  // But in this demo we do not want to modify rvActionsResource
  // (and we recommend to use a copy of it in your applications)

  rvActionsResource.rvActionSave1.OnDocumentFileChange := rvActionSave1DocumentFileChange;

  // Code for making color-picking buttons stay pressed while a
  // color-picker window is visible.
  rvActionsResource.rvActionColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionParaColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionParaColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontColor1.OnHideColorPicker := ColorPickerHide;
  rvActionsResource.rvActionFontBackColor1.OnShowColorPicker := ColorPickerShow;
  rvActionsResource.rvActionFontBackColor1.OnHideColorPicker := ColorPickerHide;

  // Delphi 4 and 5 do not have ActionComponent property for actions.
  // Coloring actions have a substitution - CallerControl property
  // It is ignored in Delphi 6 and 7
  rvActionsResource.rvActionParaColor1.CallerControl := ToolButton39;
  rvActionsResource.rvActionFontBackColor1.CallerControl := ToolButton38;
  rvActionsResource.rvActionFontColor1.CallerControl := ToolButton36;

  {$IFDEF RICHVIEWDEF6}
  // AutoComplete feature causes OnClick generation when editing combo-box's text.
  // Since in OnClick we move input focus in RichViewEdit1, this effect is
  // undesirable
  cmbFont.AutoComplete := False;
  cmbFontSize.AutoComplete := False;
  {$ENDIF}

  Localize;

  // Loading initial file via ActionOpen (allowing to update user interface)
  rvActionsResource.rvActionOpen1.LoadFile(RichViewEdit1,
    ExtractFilePath(Application.ExeName)+'readme.rvf', ffiRVF);

  {
  // alternative way to start
    rvActionsResource.rvActionNew1.ExecuteTarget(RichViewEdit1);
  }
end;


{------------------- Working with document ------------------------------------}

// When document is created, saved, loaded...
procedure TForm3.rvActionSave1DocumentFileChange(Sender: TObject;
  Editor: TCustomRichViewEdit; const FileName: String;
  FileFormat: TrvFileSaveFilter; IsNew: Boolean);
var s: String;
begin
  s := ExtractFileName(FileName);
  rvActionsResource.rvActionPrint1.Title := s;
  rvActionsResource.rvActionQuickPrint1.Title := s;
  if IsNew then
    s := s+' (*)';
  Caption := s + ' - RichViewActionsTest';
end;

// Prompt for saving...
procedure TForm3.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  CanClose := rvActionsResource.rvActionSave1.CanCloseDoc(RichViewEdit1);
end;

procedure TForm3.mitExitClick(Sender: TObject);
begin
  Close;
end;

{--------------- Working with color-picking buttons ---------------------------}

// Code for making color-picking buttons pressed while
// a color-picker window is visible.
procedure TForm3.ColorPickerShow(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := True;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := True;
  {$ENDIF};
end;

procedure TForm3.ColorPickerHide(Sender: TObject);
begin
  {$IFDEF RICHVIEWDEF6}
  if (Sender as TAction).ActionComponent is TToolButton then
    TToolButton(TAction(Sender).ActionComponent).Down := False;
  {$ELSE}
  if TrvActionCustomColor(Sender).CallerControl<>nil then
    TToolButton(TrvActionCustomColor(Sender).CallerControl).Down := False;
  {$ENDIF}
end;

{-------------- Set of events for processing hypertext jumps ------------------}

// Hyperlink click
procedure TForm3.RichViewEdit1Jump(Sender: TObject; id: Integer);
begin
  rvActionsResource.rvActionInsertHyperlink1.GoToLink(RichViewEdit1, id);
end;

// Importing hyperlink from RTF
procedure TForm3.RichViewEdit1ReadHyperlink(Sender: TCustomRichView;
  const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo,
  ItemTag: Integer; var ItemName: TRVRawByteString);
var URL: String;
begin
  if DocFormat=rvlfURL then
    StyleNo :=
      rvActionsResource.rvActionInsertHyperlink1.GetHyperlinkStyleNo(RichViewEdit1);
  URL := rvActionsResource.rvActionInsertHyperlink1.EncodeTarget(Target);
  ItemTag := Integer(StrNew(PChar(URL)));
end;

// Exporting hyperlink to RTF and HTML
procedure TForm3.RichViewEdit1WriteHyperlink(Sender: TCustomRichView;
  id: Integer; RVData: TCustomRVData; ItemNo: Integer;
  SaveFormat: TRVSaveFormat; var Target, Extras: String);
begin
  Target := PChar(RVData.GetItemTag(ItemNo));
end;

// URL detection on typing
procedure TForm3.RichViewEdit1KeyPress(Sender: TObject; var Key: Char);
begin
  {
  // uncomment if you use Addict3
  if (Key in ['''', #13, #9]) or (Pos(Key, RichViewEdit1.Delimiters)<>0) then
    RVA_Addict3AutoCorrect(RichViewEdit1);
  }
  if Key in [#13, #9, ' ', ',', ';'] then begin
    rvActionsResource.rvActionInsertHyperlink1.DetectURL(RichViewEdit1);
    rvActionsResource.rvActionInsertHyperlink1.TerminateHyperlink(RichViewEdit1);
  end;
end;

{----------------------- Insert table popup      -----------------------------}
{ We use a trick: insert-table button has style tbsDropDown and assigned
  DropDownMenu (pmFakeDropDown). This menu is empty, but shows table size
  popup instead of itself }
procedure TForm3.pmFakeDropDownPopup(Sender: TObject);
begin
  rvActionsResource.rvActionInsertTable1.ShowTableSizeDialog(RichViewEdit1,
    ToolButton12);
end;

{----------------------- Working with combo-boxes -----------------------------}

// Current font is changed. Updating the combo-boxes.
procedure TForm3.RichViewEdit1CurTextStyleChanged(Sender: TObject);
var CurStyle: TFontInfo;
begin
  UpdatingCombos := True;
  try
    CurStyle := RVStyle1.TextStyles[RichViewEdit1.CurTextStyleNo];
    cmbFont.Text := CurStyle.FontName;
    cmbFont.OnClick(Sender);
    cmbFontSize.FontName := CurStyle.FontName;
    cmbFontSize.Text := IntToStr(CurStyle.Size);
  finally
    UpdatingCombos := False;
  end;
end;

// Applying the font name
procedure TForm3.cmbFontClick(Sender: TObject);
var FontName: String;
begin
  if cmbFont.ItemIndex<0 then
    FontName := cmbFont.Text
  else
    FontName := cmbFont.Items[cmbFont.ItemIndex];
  if UpdatingCombos then
    exit;
  UpdatingCombos := True;
  cmbFontSize.FontName := FontName;
  UpdatingCombos := False;
  if cmbFont.ItemIndex<0 then
    cmbFont.ItemIndex := cmbFont.Items.IndexOf(FontName);
  if cmbFont.ItemIndex<0 then begin
      Beep
    end
  else
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimFontName];
      Font.Name := FontName;
      Execute;
      UserInterface := True;
    end;
  RichViewEdit1.SetFocus;
end;

// Changing the font size
procedure TForm3.cmbFontSizeClick(Sender: TObject);
var FontSize: Integer;
begin
  if UpdatingCombos then
    exit;
  try
    FontSize := StrToInt(cmbFontSize.Text);
    with rvActionsResource.rvActionFontEx1 do begin
      UserInterface := False;
      ValidProperties := [rvfimSize];
      Font.Size := FontSize;
      Execute;
      UserInterface := True;
    end;
  except
    Beep;
  end;
  RichViewEdit1.SetFocus;
end;

procedure TForm3.cmbKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#13 then begin
    Key := #0;
    TComboBox(Sender).OnClick(Sender);
  end;
end;

{---------------------------- Ruler ------------------------------------}

procedure TForm3.RVAControlPanel1MarginsChanged(Sender: TrvAction;
  Edit: TCustomRichViewEdit);
begin
  RVRuler1.UpdateRulerMargins;
end;

{---------------------------- Localization ------------------------------------}

procedure TForm3.Button1Click(Sender: TObject);
begin
  if RVA_ChooseLanguage then
    Localize;
end;

procedure TForm3.Localize;
begin
  // Fonts
  Font.Charset            := RVA_GetCharset;
  StatusBar1.Font.Charset := RVA_GetCharset;
  {$IFDEF RICHVIEWDEF6}
  Screen.HintFont.Charset := RVA_GetCharset;
  Screen.MenuFont.Charset := RVA_GetCharset;
  {$ENDIF}
  // Localizing all actions on rvActionsResource
  RVA_LocalizeForm(rvActionsResource);
  // Localizing all actions on this form
  RVA_LocalizeForm(Self);
  // Localizing ruler
  RVALocalizeRuler(RVRuler1);
  // Localizing menus (not all menus in this demo are translated)
  mitFile.Caption := RVA_GetS(rvam_menu_File);
  mitEdit.Caption := RVA_GetS(rvam_menu_Edit);
  mitFont.Caption := RVA_GetS(rvam_menu_Font);
  mitPara.Caption := RVA_GetS(rvam_menu_Para);
  mitFormat.Caption := RVA_GetS(rvam_menu_Format);
  mitInsert.Caption := RVA_GetS(rvam_menu_Insert);
  mitTable.Caption := RVA_GetS(rvam_menu_Table);
  mitExit.Caption := RVA_GetS(rvam_menu_Exit);
  mitHelp.Caption := RVA_GetS(rvam_menu_Help);
  mitHelpTOC.Caption := RVA_GetS(rvam_menu_Help);

  mitFontSize.Caption := RVA_GetS(rvam_menu_FontSize);
  mitFontStyle.Caption := RVA_GetS(rvam_menu_FontStyle);
  mitTableSelect.Caption := RVA_GetS(rvam_menu_TableSelect);
  mitTableCellBorders.Caption := RVA_GetS(rvam_menu_TableCellBorders);
  mitTableAlignCellContents.Caption := RVA_GetS(rvam_menu_TableCellAlign);
  // In your application, you can use either TrvActionFonts or TrvActionFontEx
  rvActionsResource.rvActionFonts1.Caption := rvActionsResource.rvActionFonts1.Caption+' (Standard)';
  rvActionsResource.rvActionFontEx1.Caption := rvActionsResource.rvActionFontEx1.Caption+' (Advanced)';

  {
  // uncomment if you use Addict3. It's assumed that RVAddictSpell31
  // and RVThesaurus31 are on this form.
  RVAddictSpell31.UILanguage := GetAddictSpellLanguage(RVA_GetLanguageName);
  RVThesaurus31.UILanguage := GetAddictThesLanguage(RVA_GetLanguageName);
  }
end;

{-------------------------------- Misc. ---------------------------------------}

procedure TForm3.RVAControlPanel1Download(Sender: TrvAction;
  const Source: String);
begin
  if Source='' then
    Application.Hint := ''
  else
    Application.Hint := 'Downloading '+Source+'...';
end;

procedure TForm3.mitHelpTOCClick(Sender: TObject);
var HelpFileName: TRVUnicodeString;
begin
  HelpFileName := ExtractFilePath(Application.ExeName)+'Help\RichViewActions.chm';
  RvHtmlHelp(HelpFileName);
end;

{---------------------- Live spelling with Addict 3 ---------------------------}
(*
// Add these events if you use Addict3
// (Assuming that you have RVAddictSpell31: TRVAddictSpell3 on the form)

// RichViewEdit1.OnSpellingCheck event
procedure TForm3.RichViewEdit1SpellingCheck(Sender: TCustomRichView;
  const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
begin
  Misspelled := not RVAddictSpell31.WordAcceptable(AWord);
end;

// RVAddictSpell31.OnParserIgnoreWord: if Ignore All or Add buttons were pressed
// in spellchecker dialog, removing underlines from the ignored word
procedure TForm3.RVAddictSpell31ParserIgnoreWord(Sender: TObject;
  Before: Boolean; State: Integer);
begin
  if not Before and (State in [IgnoreState_IgnoreAll, IgnoreState_Add]) then
    RichViewEdit1.LiveSpellingValidateWord(RVAddictSpell31.CurrentWord);
end;

// Besides, if you want spelling check starting when loading document, call
// RichViewEdit1.StartLiveSpelling in rvActionFileOpen.OnOpenFile event
*)


initialization

{$IFDEF USE_GIFIMAGE}
  RegisterClasses([TGifImage]);
  // uncomment the line below if Gif does not appear in Insert | Image
  //TPicture.RegisterFileFormat('gif', 'Gif Image', TGifImage);
  RV_RegisterHTMLGraphicFormat(TGifImage);
{$ENDIF}
{$IFDEF USE_PNGOBJECT}
  {$IFDEF RICHVIEWDEF2009}
  RegisterClass(TPngImage);
  RV_RegisterHTMLGraphicFormat(TPngImage);
  RV_RegisterPngGraphic(TPngImage);
  {$ELSE}
  RegisterClass(TPngObject);
  RV_RegisterHTMLGraphicFormat(TPngObject);
  RV_RegisterPngGraphic(TPngObject);  
  {$ENDIF}
{$ENDIF}

end.