
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for entering one numeric value           }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit IntegerRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RVSpinEdit, BaseRVFrm, RVALocalize;

type
  TfrmInteger = class(TfrmRVBase)
    GroupBox1: TGroupBox;
    lbl: TLabel;
    se: TRVSpinEdit;
    btnOk: TButton;
    btnCancel: TButton;
    procedure FormCreate(Sender: TObject);
  private
    function GetValue: Integer;
    procedure SetValue(const Value: Integer);
    { Private declarations }
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _lbl : TControl;
    procedure Localize; override;
    property Value: Integer read GetValue write SetValue;
  end;

implementation

{$R *.dfm}

{ TTfrmInteger }

function TfrmInteger.GetValue: Integer;
begin
  Result := se.AsInteger;
end;

procedure TfrmInteger.Localize;
begin
  inherited;
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
end;

{$IFDEF RVASKINNED}
procedure TfrmInteger.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = _lbl then
    _lbl := NewControl;
end;
{$ENDIF}

procedure TfrmInteger.SetValue(const Value: Integer);
begin
  se.Value := Value;
end;

procedure TfrmInteger.FormCreate(Sender: TObject);
begin
  _lbl := lbl;
  inherited;
end;

end.
