
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for inserting hyperlink                  }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit HypRVFrm;

interface

{$I RichViewActions.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, RVALocalize, BaseRVFrm;

type
  TfrmRVHyp = class(TfrmRVBase)
    gb: TGroupBox;
    btnOk: TButton;
    btnCancel: TButton;
    lblText: TLabel;
    txtText: TEdit;
    lblTarget: TLabel;
    txtTarget: TEdit;
    btnHypProp: TButton;
    procedure FormActivate(Sender: TObject);
    procedure txtTargetChange(Sender: TObject);
    procedure btnHypPropClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    _btnOk: TControl;
  protected
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _txtText, _txtTarget: TControl;
    TextColor, HoverColor, BackColor, HoverBackColor: TColor;
    procedure Localize; override;
  end;

implementation

uses HypPropRVFrm;

{$R *.dfm}

procedure TfrmRVHyp.FormActivate(Sender: TObject);
begin
  _btnOk.Enabled := not _txtText.Enabled or
    ((Trim(GetEditText(_txtTarget))<>'')  and (GetEditText(_txtText)<>''));
end;


procedure TfrmRVHyp.txtTargetChange(Sender: TObject);
begin
  _btnOk.Enabled := not _txtText.Enabled or
    ((Trim(GetEditText(_txtTarget))<>'')  and (GetEditText(_txtText)<>''));
end;

procedure TfrmRVHyp.Localize;
begin
  inherited;
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_hl_Title));
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  gb.Caption := RVA_GetSH(rvam_hl_GBTitle);
  lblText.Caption := RVA_GetS(rvam_hl_Text);
  lblTarget.Caption := RVA_GetS(rvam_hl_Target);
  btnHypProp.Caption := RVA_GetS(rvam_hl_HypProperties);
end;

procedure TfrmRVHyp.btnHypPropClick(Sender: TObject);
var frm: TfrmRVHypProp;
begin
  frm := TfrmRVHypProp.Create(Application);
  try
    frm.cmbText.ChosenColor          := TextColor;
    frm.cmbTextBack.ChosenColor      := BackColor;
    frm.cmbHoverText.ChosenColor     := HoverColor;
    frm.cmbHoverTextBack.ChosenColor := HoverBackColor;
    if frm.ShowModal=mrOk then begin
      TextColor      := frm.cmbText.ChosenColor;
      BackColor      := frm.cmbTextBack.ChosenColor;
      HoverColor     := frm.cmbHoverText.ChosenColor;
      HoverBackColor := frm.cmbHoverTextBack.ChosenColor;
    end;
  finally
    frm.Free;
  end;
end;

procedure TfrmRVHyp.FormCreate(Sender: TObject);
begin
  _btnOk := btnOk;
  _txtText := txtText;
  _txtTarget := txtTarget;
  inherited;
end;

{$IFDEF RVASKINNED}
procedure TfrmRVHyp.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl = btnOk then
    _btnOk := NewControl
  else if OldControl = _txtText then
    _txtText := NewControl
  else if OldControl = _txtTarget then
    _txtTarget := NewControl;
end;
{$ENDIF}

end.
