
{*******************************************************}
{                                                       }
{       RichViewActions                                 }
{       Dialog for choosing color for text, paragraph,  }
{       table and cell background.                      }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit FillColorRVFrm;

interface

{$I RichViewActions.inc}

{$I RV_Defs.inc}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, BaseRVFrm, StdCtrls, RVColorGrid, ColorRVFrm, RVStyle,
  RVALocalize, RVGrids;

type
  TfrmRVFillColor = class(TfrmRVBase)
    gb: TGroupBox;
    lblColor: TLabel;
    rvcg: TRVColorGrid;
    btnColor: TButton;
    btnOk: TButton;
    btnCancel: TButton;
    lbl: TLabel;
    cmb: TComboBox;
    ColorDialog1: TColorDialog;
    btnPadding: TButton;
    procedure btnColorClick(Sender: TObject);
    procedure rvcgColorChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnOkClick(Sender: TObject);
    procedure cmbClick(Sender: TObject);
    procedure btnPaddingClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    _btnPadding: TControl;
    FChosenColor: TColor;
    Updating: Boolean;
    PaddingLeft, PaddingTop, PaddingRight, PaddingBottom: Integer;
    FPaddingLeft, FPaddingTop, FPaddingRight, FPaddingBottom: Boolean;
    { Private declarations }
    function GetCD: TColorDialog;
    procedure SetChosenColor(Value: TColor);
  protected
    function GetOkButton: TButton; override;
    {$IFDEF RVASKINNED}
    procedure OnCreateThemedControl(OldControl, NewControl: TControl); override;
    {$ENDIF}
  public
    { Public declarations }
    _cmb, _lblColor: TControl;
    ColorDialog: TColorDialog;
    Indeterminate: Boolean;
    procedure SetPadding(Padding: TRVRect; UsePadding: TRVBooleanRect);
    procedure GetPadding(Padding: TRVRect; UsePadding: TRVBooleanRect);
    procedure Localize; override;
    property ChosenColor: TColor read FChosenColor write SetChosenColor;
  end;

implementation
uses FourSidesRVFrm;

{$R *.dfm}

{ TfrmRVFillColor }

function TfrmRVFillColor.GetCD: TColorDialog;
begin
  if ColorDialog<>nil then
    Result := ColorDialog
  else
    Result := ColorDialog1;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.SetChosenColor(Value: TColor);
var rgb: Integer;
begin
  if Value<>clNone then
    Value := ColorToRGB(Value);
  if Indeterminate then begin
    SetControlCaption(_lblColor, '');
    rvcg.Indeterminate := True;
    end
  else begin
    FChosenColor := Value;
    Updating := True;
    rvcg.ChosenColor := Value;
    Updating := False;
    if rvcg.Indeterminate then begin
      rgb := ColorToRGB(FChosenColor);
      SetControlCaption(_lblColor, 'RGB('+
        IntToStr(rgb and $0000FF)+','+
        IntToStr((rgb and $00FF00) shr 8)+','+
        IntToStr((rgb and $FF0000) shr 16)+')');
      end
    else
      SetControlCaption(_lblColor, rvcg.GetColorName);
  end;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.btnColorClick(Sender: TObject);
begin
  if ChosenColor=clNone then
    GetCD.Color := clYellow
  else
    GetCD.Color := ColorToRGB(ChosenColor);
  if GetCD.Execute then begin
    Indeterminate := False;
    ChosenColor := GetCD.Color;
  end;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.rvcgColorChange(Sender: TObject);
begin
  if not Visible or Updating then
    exit;
  Indeterminate := rvcg.Indeterminate;
  ChosenColor := rvcg.ChosenColor;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.FormCreate(Sender: TObject);
begin
  _btnPadding := btnPadding;
  _cmb := cmb;
  _lblColor := lblColor;
  inherited;
  SetControlCaption(_lblColor, '');
  Indeterminate := True;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.btnOkClick(Sender: TObject);
begin
  if Indeterminate then
    Application.MessageBox(RVA_GetPC(rvam_fillc_PleaseSelect), RVA_GetPC(rvam_fillc_Title), MB_ICONSTOP)
  else
    ModalResult := mrOk;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.cmbClick(Sender: TObject);
begin
  _btnPadding.Enabled := (GetXBoxItemIndex(_cmb)>=0) and
    (Integer(GetXBoxObject(_cmb, GetXBoxItemIndex(_cmb)))=3);
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.btnPaddingClick(Sender: TObject);
var frm: TfrmRVFourSides;
begin
  frm := TfrmRVFourSides.Create(Application);
  try
    frm.SetValues(PaddingLeft, PaddingTop, PaddingRight, PaddingBottom,
       FPaddingLeft, FPaddingTop, FPaddingRight, FPaddingBottom);
    if frm.ShowModal=mrOk then
      frm.GetValues(PaddingLeft, PaddingTop, PaddingRight, PaddingBottom,
       FPaddingLeft, FPaddingTop, FPaddingRight, FPaddingBottom);
  finally
    frm.Free;
  end;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.FormActivate(Sender: TObject);
begin
  cmbClick(Sender);
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.GetPadding(Padding: TRVRect; UsePadding: TRVBooleanRect);
begin
  with Padding do begin
    Left   := PaddingLeft;
    Top    := PaddingTop;
    Right  := PaddingRight;
    Bottom := PaddingBottom;
  end;

  with UsePadding do begin
    Left   := FPaddingLeft;
    Top    := FPaddingTop;
    Right  := FPaddingRight;
    Bottom := FPaddingBottom;
  end;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.SetPadding(Padding: TRVRect; UsePadding: TRVBooleanRect);
begin
  with Padding do begin
    PaddingLeft   := Left;
    PaddingTop    := Top;
    PaddingRight  := Right;
    PaddingBottom := Bottom;
  end;

  with UsePadding do begin
    FPaddingLeft   := Left;
    FPaddingTop    := Top;
    FPaddingRight  := Right;
    FPaddingBottom := Bottom;
  end;
end;
{------------------------------------------------------------------------------}
procedure TfrmRVFillColor.Localize;
begin
  inherited;
  Caption := {$IFDEF USERVTNT}_GetWideString{$ENDIF}(RVA_GetS(rvam_fillc_Title));
  btnOk.Caption := RVA_GetS(rvam_btn_OK);
  btnCancel.Caption := RVA_GetS(rvam_btn_Cancel);
  gb.Caption := RVA_GetSH(rvam_fillc_Title);
  lbl.Caption := RVA_GetS(rvam_fillc_ApplyTo);
  btnColor.Caption := RVA_GetS(rvam_fillc_MoreColors);
  btnPadding.Caption := RVA_GetS(rvam_fillc_Padding);
  rvcg.FirstCaption := RVA_GetS(rvam_cl_Transparent);
end;

function TfrmRVFillColor.GetOkButton: TButton;
begin
  Result := btnOk;
end;

{$IFDEF RVASKINNED}
procedure TfrmRVFillColor.OnCreateThemedControl(OldControl,
  NewControl: TControl);
begin
  if OldControl=btnPadding then
    _btnPadding := NewControl
  else if OldControl = _cmb then
    _cmb := NewControl
  else if OldControl = _lblColor then
    _lblColor := NewControl;
end;
{$ENDIF}

end.
